/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.player;

import com.yy.mobile.sdkwrapper.flowmanagement.api.audience.liveinfo.LiveInfoChangeEventHandler;
import com.yy.mobile.sdkwrapper.flowmanagement.api.audience.player.ILivePlayerManager;
import com.yy.mobile.sdkwrapper.flowmanagement.base.audience.liveinfo.LiveInfoChangeListener;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.liveinfo.LiveInfoUtils;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.player.LivePlayerListHolder;
import com.yy.mobile.util.log.MLog;
import com.yy.yylivekit.audience.LivePlayer;
import com.yy.yylivekit.model.LiveInfo;
import com.yyproto.utils.FP;
import java.util.List;

public class LivePlayerManagerImpl
implements ILivePlayerManager,
LiveInfoChangeListener {
    private static final String TAG = "LivePlayerManagerImpl";

    @Override
    public void stopPlayers() {
        MLog.info((Object)TAG, (String)"stopPlayers:", (Object[])new Object[0]);
        List<LivePlayer> livePlayers = LivePlayerListHolder.getInstance().getPlayers();
        for (LivePlayer livePlayer : livePlayers) {
            livePlayer.stopPlay();
        }
    }

    public void release() {
        this.stopPlayers();
    }

    @Override
    public boolean isAllPlayersVideoEnabled() {
        Boolean enabled = null;
        List<LivePlayer> livePlayers = LivePlayerListHolder.getInstance().getPlayers();
        for (LivePlayer livePlayer : livePlayers) {
            if (!LiveInfoUtils.hasVideo(livePlayer.getAllLiveInfo()) || livePlayer.isVideoEnable()) continue;
            enabled = false;
            break;
        }
        if (enabled == null) {
            enabled = true;
        }
        MLog.info((Object)TAG, (String)"isAllPlayersVideoEnabled: %b, players size: %d", (Object[])new Object[]{enabled, FP.size(livePlayers)});
        return enabled;
    }

    @Override
    public void setPlayersVideoEnable(boolean enableVideo) {
        MLog.info((Object)TAG, (String)("setPlayersVideoEnable called with: enableVideo = [" + enableVideo + "]"), (Object[])new Object[0]);
        List<LivePlayer> livePlayers = LivePlayerListHolder.getInstance().getPlayers();
        for (LivePlayer livePlayer : livePlayers) {
            livePlayer.setVideoEnabled(enableVideo);
        }
    }

    @Override
    public void onAddLiveInfos(List<LiveInfo> liveInfos) {
    }

    @Override
    public void onRemoveLiveInfos(List<LiveInfo> liveInfos) {
    }

    @Override
    public void onUpdateLiveInfos(List<LiveInfo> fromLiveInfos, List<LiveInfo> toLiveInfos) {
    }

    public void init() {
    }

    private LivePlayerManagerImpl() {
        LiveInfoChangeEventHandler.getInstance().addLiveInfoChangeListener(this);
    }

    public static LivePlayerManagerImpl getInstance() {
        return Holder.INSTANCE;
    }

    private static class Holder {
        private static LivePlayerManagerImpl INSTANCE = new LivePlayerManagerImpl();

        private Holder() {
        }
    }
}

