/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.player;

import com.yy.mobile.sdkwrapper.flowmanagement.internal.common.ListHolder;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.log.MLog;
import com.yy.yylivekit.audience.LivePlayer;
import java.util.Iterator;
import java.util.List;

public class LivePlayerListHolder
extends ListHolder<LivePlayer> {
    private static final String TAG = "PlayerListHolder";

    public static LivePlayerListHolder getInstance() {
        return Holder.INSTANCE;
    }

    private LivePlayerListHolder() {
    }

    public void addPlayer(LivePlayer player) {
        this.add(player);
        MLog.info((Object)TAG, (String)"addLivePlayer, size: %d, player: %s", (Object[])new Object[]{FP.size(this.getList()), player});
    }

    public void removePlayer(LivePlayer player) {
        this.remove(player);
        MLog.info((Object)TAG, (String)"removeLivePlayer, size: %d, player: %s", (Object[])new Object[]{FP.size(this.getList()), player});
    }

    public List<LivePlayer> getPlayers() {
        return this.getList();
    }

    public void clearAndRelease() {
        MLog.info((Object)TAG, (String)"clear player list holder, player size: %d", (Object[])new Object[]{FP.size(this.getList())});
        Iterator it = this.getList().iterator();
        while (it.hasNext()) {
            LivePlayer livePlayer = (LivePlayer)it.next();
            livePlayer.release();
            it.remove();
        }
    }

    private static class Holder {
        private static final LivePlayerListHolder INSTANCE = new LivePlayerListHolder();

        private Holder() {
        }
    }
}

