/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.player;

import android.support.annotation.Nullable;
import com.yy.mobile.sdkwrapper.flowmanagement.api.audience.liveinfo.LiveInfoChangeEventHandler;
import com.yy.mobile.sdkwrapper.flowmanagement.api.audience.videoquality.AudienceStreamLineEventHandler;
import com.yy.mobile.sdkwrapper.flowmanagement.base.audience.liveinfo.LiveInfoChangeListener;
import com.yy.mobile.sdkwrapper.flowmanagement.base.audience.liveinfo.SimpleLiveInfoChangeListener;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.player.LivePlayerListHolder;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.player.eventhandler.PlayerEventHandler;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.player.eventhandler.QosEventHandler;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.player.eventhandler.ViewerEventHandler;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.player.playerkey.DoubleSourcePlayerKey;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.player.playerkey.IPlayerKey;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.player.playerkey.SingleSourcePlayerKey;
import com.yy.mobile.util.log.MLog;
import com.yy.yylivekit.ILivePlayer;
import com.yy.yylivekit.audience.LivePlayer;
import com.yy.yylivekit.model.LiveInfo;
import com.yyproto.utils.FP;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;

public class LivePlayerFactory {
    private static final String TAG = "LivePlayerFactory";
    private Map<IPlayerKey, LivePlayer> mLiveInfoLivePlayerMap = new HashMap<IPlayerKey, LivePlayer>();
    private LiveInfoChangeListener mLiveInfoChangeListener = new SimpleLiveInfoChangeListener(){

        @Override
        public void onRemoveLiveInfos(List<LiveInfo> liveInfos) {
            LivePlayerFactory.this.onRemoveLiveInfos(liveInfos);
        }
    };

    public void init() {
        LiveInfoChangeEventHandler.getInstance().addLiveInfoChangeListener(this.mLiveInfoChangeListener);
    }

    public LivePlayer getOrCreateLivePlayer(LiveInfo liveInfo) {
        MLog.info((Object)TAG, (String)"getOrCreateLivePlayer start", (Object[])new Object[0]);
        IPlayerKey playerKey = this.createPlayerKey(liveInfo);
        LivePlayer playerTmp = this.mLiveInfoLivePlayerMap.get(playerKey);
        if (playerTmp == null) {
            LivePlayer player = this.createLivePlayer(liveInfo, playerKey);
            MLog.info((Object)TAG, (String)"getOrCreateLivePlayer end, create new live player: %s, liveInfo: %s", (Object[])new Object[]{player, liveInfo});
            return player;
        }
        MLog.info((Object)TAG, (String)"getOrCreateLivePlayer end, return cached live player: %s, liveInfo: %s", (Object[])new Object[]{playerTmp, liveInfo});
        return playerTmp;
    }

    private IPlayerKey createPlayerKey(LiveInfo liveInfo) {
        if (liveInfo.isMultiSource()) {
            return new DoubleSourcePlayerKey(liveInfo, liveInfo.isMix, liveInfo.micNo, liveInfo.isMix);
        }
        return new SingleSourcePlayerKey(liveInfo);
    }

    @Nullable
    public LivePlayer getLivePlayer(LiveInfo liveInfo) {
        return this.mLiveInfoLivePlayerMap.get(this.createPlayerKey(liveInfo));
    }

    public LivePlayer createLivePlayer(LiveInfo liveInfo) {
        return this.createLivePlayer(liveInfo, this.createPlayerKey(liveInfo));
    }

    private LivePlayer createLivePlayer(LiveInfo liveInfo, IPlayerKey playerKey) {
        HashSet<LiveInfo> liveInfoSet = new HashSet<LiveInfo>();
        liveInfoSet.add(liveInfo);
        LivePlayer player = new LivePlayer(liveInfoSet);
        LivePlayerListHolder.getInstance().addPlayer(player);
        player.addPlayerEventHandler(PlayerEventHandler.getInstance());
        player.addQosEventHandler(QosEventHandler.getInstance());
        player.addViewerEventHandler((ILivePlayer.ViewerEventHandler)ViewerEventHandler.getInstance());
        player.addStreamLineEventHandler((ILivePlayer.StreamLineEventHandler)AudienceStreamLineEventHandler.getInstance());
        this.mLiveInfoLivePlayerMap.put(playerKey, player);
        MLog.info((Object)TAG, (String)("createLivePlayer called, player map size: %s, player: %s, liveInfo = [" + liveInfo + "]"), (Object[])new Object[]{this.mLiveInfoLivePlayerMap.size(), player});
        return player;
    }

    private void onRemoveLiveInfos(List<LiveInfo> liveInfos) {
        MLog.info((Object)TAG, (String)("onRemoveLiveInfos called with: livePlayerMap: %s, liveInfos = [" + liveInfos + "]"), (Object[])new Object[]{this.mLiveInfoLivePlayerMap});
        for (LiveInfo removeLiveInfo : liveInfos) {
            IPlayerKey playerKey = this.createPlayerKey(removeLiveInfo);
            LivePlayer player = this.mLiveInfoLivePlayerMap.get(playerKey);
            if (player == null) continue;
            MLog.info((Object)TAG, (String)"onRemoveLiveInfos, found live player to remove, liveinfo: %s, player: %s", (Object[])new Object[]{removeLiveInfo, player});
            HashSet<LiveInfo> liveInfoSet = new HashSet<LiveInfo>();
            liveInfoSet.add(removeLiveInfo);
            player.removeLiveInfoSet(liveInfoSet);
            if (FP.empty((Collection)player.getAllLiveInfo())) {
                MLog.info((Object)TAG, (String)"onRemoveLiveInfos, player has no live info, stop, release and remove from local map, player: %s, liveInfo: %s, liveInfos: %s", (Object[])new Object[]{player, removeLiveInfo, liveInfos});
                player.stopPlay();
                player.release();
                this.mLiveInfoLivePlayerMap.remove(playerKey);
                LivePlayerListHolder.getInstance().removePlayer(player);
                continue;
            }
            MLog.info((Object)TAG, (String)"onRemoveLiveInfos, player has live info left, just remove live info from player, player: %s, liveInfo: %s, liveInfos: %s", (Object[])new Object[]{player, removeLiveInfo, liveInfos});
        }
        int mapSize = this.mLiveInfoLivePlayerMap.size();
        MLog.info((Object)TAG, (String)"removeLivePlayer called with: player map size: %d, playerMap: %s", (Object[])new Object[]{mapSize, this.mLiveInfoLivePlayerMap});
    }

    public void releaseLivePlayers() {
        if (this.mLiveInfoLivePlayerMap != null) {
            this.mLiveInfoLivePlayerMap.clear();
            LivePlayerListHolder.getInstance().clearAndRelease();
        }
    }

    public static LivePlayerFactory getInstance() {
        return Holder.INSTANCE;
    }

    private LivePlayerFactory() {
    }

    private static class Holder {
        private static final LivePlayerFactory INSTANCE = new LivePlayerFactory();

        private Holder() {
        }
    }
}

