/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.player;

import android.support.annotation.Nullable;
import com.yy.mobile.sdkwrapper.flowmanagement.api.audience.streamcompat.VideoStreamCompat;
import com.yy.mobile.sdkwrapper.flowmanagement.base.audience.player.IAudienceVideoManager;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.AudienceManagerInternal;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.common.RoleManager;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.log.MLog;
import com.yy.yylivekit.audience.Audience;

public class AudienceVideoManagerImpl
implements IAudienceVideoManager {
    private static final String TAG = "AudienceVideoManagerImpl";
    private Boolean mIsNeedVideoMixture = null;
    private Boolean mIsNeedTransCode = true;

    @Override
    public boolean isChannelHasVideo() {
        boolean hasVideo = VideoStreamCompat.getInstance().getVideoStreamListSize() > 0;
        MLog.info((Object)TAG, (String)"isChannelHasVideo called, hasVideo: %b", (Object[])new Object[]{hasVideo});
        return hasVideo;
    }

    @Override
    public void setVideoNeedMixture(boolean needMixture) {
        MLog.info((Object)TAG, (String)("setAudienceVideoNeedMixture called with: needMixture = [" + needMixture + "], mIsNeedTransCode: %b"), (Object[])new Object[]{this.mIsNeedTransCode});
        this.innerSetNeedMixture(needMixture, this.mIsNeedTransCode);
    }

    @Override
    public void setVideoNeedMixture(boolean needMixture, boolean needTransCode) {
        MLog.info((Object)TAG, (String)("setVideoNeedMixture() called with: needMixture = [" + needMixture + "], needTransCode = [" + needTransCode + "]"), (Object[])new Object[0]);
        this.innerSetNeedMixture(needMixture, needTransCode);
    }

    @Override
    @Nullable
    public Boolean isVideoMixture() {
        MLog.info((Object)TAG, (String)"isVideoMixture called: %b", (Object[])new Object[]{this.mIsNeedVideoMixture});
        return this.mIsNeedVideoMixture;
    }

    @Override
    public void enableVideoLowLatency() {
        MLog.info((Object)TAG, (String)"enableVideoLowLatency called", (Object[])new Object[0]);
        AudienceManagerInternal.getInstance().setEnableVideoLowLatency(true);
    }

    @Override
    public void disableVideoLowLatency() {
        MLog.info((Object)TAG, (String)"disableVideoLowLatency called", (Object[])new Object[0]);
        AudienceManagerInternal.getInstance().setEnableVideoLowLatency(false);
    }

    private void innerSetNeedMixture(boolean needMixture, boolean needTransCode) {
        Audience audience = AudienceManagerInternal.getInstance().getAudience();
        if (audience != null) {
            if (FP.eq((Object)this.mIsNeedVideoMixture, (Object)needMixture) && FP.eq((Object)this.mIsNeedTransCode, (Object)needTransCode)) {
                MLog.info((Object)TAG, (String)("setNeedMixture, same value, do nothing: needMixture = [" + needMixture + "], needTransCode: %b"), (Object[])new Object[]{needTransCode});
                return;
            }
            String clientRoleLog = needMixture ? "Audience" : "Anchor";
            MLog.info((Object)TAG, (String)"setNeedMixture called with: needMixture from: %b to: %b, needTransCode: from: %b, to: %b, setClientRole: %s", (Object[])new Object[]{this.mIsNeedVideoMixture, needMixture, this.mIsNeedTransCode, needTransCode, clientRoleLog});
            audience.setNeedMixture(needMixture, needTransCode);
            this.mIsNeedVideoMixture = needMixture;
            this.mIsNeedTransCode = needTransCode;
            if (needMixture) {
                RoleManager.getInstance().setAudienceRole();
            } else {
                RoleManager.getInstance().setAnchorRole();
            }
        } else {
            MLog.error((Object)TAG, (String)"setNeedMixture called with null mAudience, do nothing", (Object[])new Object[0]);
        }
    }

    public static AudienceVideoManagerImpl getInstance() {
        return Holder.INSTANCE;
    }

    private AudienceVideoManagerImpl() {
    }

    private static class Holder {
        private static final AudienceVideoManagerImpl INSTANCE = new AudienceVideoManagerImpl();

        private Holder() {
        }
    }
}

