/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.nolive;

import com.yy.mobile.RxBus;
import com.yy.mobile.sdkwrapper.flowmanagement.api.audience.liveinfo.LiveInfoChangeEventHandler;
import com.yy.mobile.sdkwrapper.flowmanagement.api.audience.streamcompat.VideoStreamCompat;
import com.yy.mobile.sdkwrapper.flowmanagement.base.audience.liveinfo.LiveInfoChangeListener;
import com.yy.mobile.sdkwrapper.flowmanagement.event.audience.HasVideoStreamEvent;
import com.yy.mobile.sdkwrapper.flowmanagement.event.audience.NoVideoStreamEvent;
import com.yy.mobile.util.RxUtils;
import com.yy.mobile.util.log.MLog;
import com.yy.yylivekit.model.LiveInfo;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class NoLiveManager
implements LiveInfoChangeListener {
    private static final String TAG = "NoLiveManager";
    private static final long NO_LIVE_DELAY_NOTIFY_IN_MILLIS = 0L;
    private boolean mIsCurrentNoLive;
    private Disposable mNoLiveDelayDisposable;
    private boolean mHasNotifyFistHasVideo = false;

    public void init() {
        MLog.info((Object)TAG, (String)"init called", (Object[])new Object[0]);
        this.updateIsCurrentNoLive(false);
        LiveInfoChangeEventHandler.getInstance().addLiveInfoChangeListener(this);
    }

    public void onNoLiveInfoSetNotify() {
        MLog.info((Object)TAG, (String)"onNoLiveInfoSetNotify called", (Object[])new Object[0]);
        this.checkNoLive();
    }

    public boolean isCurrentNoLive() {
        return this.mIsCurrentNoLive;
    }

    public void reset() {
        MLog.info((Object)TAG, (String)"reset called", (Object[])new Object[0]);
        this.cancelNoLiveNotifyTask();
        this.updateIsCurrentNoLive(false);
        this.mHasNotifyFistHasVideo = false;
    }

    private void notifyNoVideoStream() {
        MLog.info((Object)TAG, (String)"======notifyNoVideoStream called======", (Object[])new Object[0]);
        this.updateIsCurrentNoLive(true);
        this.updateHasNotifyFistHasVideo(false);
        RxBus.getDefault().post((Object)new NoVideoStreamEvent());
    }

    private void notifyHasVideoStream() {
        MLog.info((Object)TAG, (String)"notifyHasVideoStream called", (Object[])new Object[0]);
        this.cancelNoLiveNotifyTask();
        this.updateIsCurrentNoLive(false);
        RxBus.getDefault().post((Object)new HasVideoStreamEvent());
    }

    private void updateIsCurrentNoLive(boolean isCurrentNoLive) {
        MLog.info((Object)TAG, (String)("updateIsCurrentNoLive called with: isCurrentNoLive = [" + isCurrentNoLive + "]"), (Object[])new Object[0]);
        this.mIsCurrentNoLive = isCurrentNoLive;
    }

    private void updateHasNotifyFistHasVideo(boolean hasNotifyFistHasVideo) {
        MLog.info((Object)TAG, (String)"updateHasNotifyFistHasVideo called with: from: %b, to: %b", (Object[])new Object[]{this.mHasNotifyFistHasVideo, hasNotifyFistHasVideo});
        this.mHasNotifyFistHasVideo = hasNotifyFistHasVideo;
    }

    @Override
    public void onAddLiveInfos(List<LiveInfo> liveInfos) {
        this.checkNoLive();
    }

    @Override
    public void onRemoveLiveInfos(List<LiveInfo> liveInfos) {
        this.checkNoLive();
    }

    @Override
    public void onUpdateLiveInfos(List<LiveInfo> fromLiveInfos, List<LiveInfo> toLiveInfos) {
        this.checkNoLive();
    }

    private void checkNoLive() {
        int streamCount = VideoStreamCompat.getInstance().getVideoStreamListSize();
        MLog.info((Object)TAG, (String)"checkNoLive called\uff0c streamCount: %d, isCurrentNoLive: %b, mHasNotifyFistHasVideo: %b", (Object[])new Object[]{streamCount, this.mIsCurrentNoLive, this.mHasNotifyFistHasVideo});
        if (streamCount > 0) {
            this.cancelNoLiveNotifyTask();
            if (!this.mHasNotifyFistHasVideo) {
                this.notifyHasVideoStream();
                this.updateHasNotifyFistHasVideo(true);
            }
        } else {
            this.startNoLiveNotifyTask();
        }
    }

    private void startNoLiveNotifyTask() {
        MLog.info((Object)TAG, (String)"startNoLiveNotifyTask called", (Object[])new Object[0]);
        this.cancelNoLiveNotifyTask();
        this.mNoLiveDelayDisposable = Observable.timer((long)0L, (TimeUnit)TimeUnit.MILLISECONDS).observeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Long>(){

            public void accept(Long aLong) throws Exception {
                NoLiveManager.this.notifyNoVideoStream();
            }
        }, RxUtils.errorConsumer((String)"NoLiveManager:startNoLiveNotifyTask"));
    }

    private void cancelNoLiveNotifyTask() {
        MLog.info((Object)TAG, (String)"cancelNoLiveNotifyTask called", (Object[])new Object[0]);
        RxUtils.dispose((Disposable)this.mNoLiveDelayDisposable);
    }

    public static NoLiveManager getInstance() {
        return Holder.INSTANCE;
    }

    private NoLiveManager() {
    }

    private static class Holder {
        private static final NoLiveManager INSTANCE = new NoLiveManager();

        private Holder() {
        }
    }
}

