/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.metadata;

import com.yy.mobile.sdkwrapper.flowmanagement.api.audience.streamcompat.VideoStreamCompat;
import com.yy.mobile.sdkwrapper.flowmanagement.base.audience.metadata.IAudienceMetadataManager;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.liveinfo.LiveInfoListHolder;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yy.yylivekit.model.LiveInfo;
import com.yyproto.utils.FP;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class AudienceMetadataManagerImpl
implements IAudienceMetadataManager {
    private static final String TAG = "AudienceMetadataManagerImpl";
    private Map<Long, Map<Short, Long>> mMetaDataMap = new ConcurrentHashMap<Long, Map<Short, Long>>();

    @Override
    public boolean isGreedyFaceLianMai() {
        boolean isGreedyFaceLianMai = this.metadataContains(86, 2);
        MLog.info((Object)TAG, (String)"isGreedyFaceLianMai called, isGreedyFaceLianMai: %b, metadata: %s", (Object[])new Object[]{isGreedyFaceLianMai, this.mMetaDataMap});
        return isGreedyFaceLianMai;
    }

    @Override
    public boolean isTransLianmai() {
        boolean isTransLianmai = this.metadataContains(83, 1);
        MLog.info((Object)TAG, (String)"isTransLianmai called, isTransLianmai: %b, metadata: %s", (Object[])new Object[]{isTransLianmai, this.mMetaDataMap});
        return isTransLianmai;
    }

    @Override
    public boolean isBasketBallLianMai() {
        boolean isBasketBallLianMai = this.metadataContains(86, 1);
        MLog.info((Object)TAG, (String)"isBasketBallLianMai called, isBasketBallLianMai: %b, metadata: %s", (Object[])new Object[]{isBasketBallLianMai, this.mMetaDataMap});
        return isBasketBallLianMai;
    }

    @Override
    public boolean isOppositeScoreLianMai() {
        boolean isOppositeScoreLianMai = this.metadataContains(86, 3);
        MLog.info((Object)TAG, (String)"isOppositeScoreLianMai called, isOppositeScoreLianMai: %b, metadata: %s", (Object[])new Object[]{isOppositeScoreLianMai, this.mMetaDataMap});
        return isOppositeScoreLianMai;
    }

    @Override
    public boolean isArenaLive() {
        boolean isArenaLive = this.metadataContains(91, 1, 2, 3);
        MLog.info((Object)TAG, (String)"isArenaLive called, isArenaLive: %b, metadata: %s", (Object[])new Object[]{isArenaLive, this.mMetaDataMap});
        return isArenaLive;
    }

    @Override
    public boolean isAnchorPreviewStop() {
        boolean isAnchorPreviewStop = this.metadataContains(95, 1);
        MLog.info((Object)TAG, (String)"isAnchorPreviewStop called, isAnchorPreviewStop: %b, metadata: %s", (Object[])new Object[]{isAnchorPreviewStop, this.mMetaDataMap});
        return isAnchorPreviewStop;
    }

    @Override
    public Boolean isFirstMicMobileLiveStreaming() {
        long firstMicUid = VideoStreamCompat.getInstance().getFirstVideoStreamUid();
        List<LiveInfo> liveInfoList = LiveInfoListHolder.getInstance().getLiveInfosByUid(firstMicUid);
        if (FP.empty(liveInfoList)) {
            MLog.info((Object)TAG, (String)"isFirstMicMobileLiveStreaming called, first mic live info not exist, return null", (Object[])new Object[0]);
            return null;
        }
        boolean isMobileLiveStreaming = this.metadataContainsByUid(firstMicUid, 42, 2, 3, 4);
        if (!isMobileLiveStreaming) {
            isMobileLiveStreaming = this.isMobileLiveByBizInfoMap(0);
        }
        MLog.info((Object)TAG, (String)"isFirstMicMobileLiveStreaming called, isFirstMicMobileLiveStreaming: %b, metadata: %s", (Object[])new Object[]{isMobileLiveStreaming, this.mMetaDataMap});
        return isMobileLiveStreaming;
    }

    private Boolean isMobileLiveByBizInfoMap(int micNo) {
        String clientType = LiveInfoListHolder.getInstance().getBizInfoMap(micNo, "clientType");
        int clientTypeInt = StringUtils.safeParseInt((String)clientType);
        MLog.info((Object)TAG, (String)"isMobileLiveByBizInfoMap called, clientType: %s, micNo: %d", (Object[])new Object[]{clientType, micNo});
        return clientTypeInt == 2 || clientTypeInt == 3 || clientTypeInt == 4;
    }

    public void updateMetadata(Map<Long, Map<Short, Long>> metaData) {
        MLog.info((Object)TAG, (String)"updateMetadata called with: oldMetadata: %s, newMetadata: %s,", (Object[])new Object[]{this.mMetaDataMap, metaData});
        this.mMetaDataMap.clear();
        if (metaData == null) {
            MLog.info((Object)TAG, (String)"updateMetadata called with: null metadata", (Object[])new Object[0]);
            return;
        }
        for (Long uid : metaData.keySet()) {
            Map<Short, Long> value = metaData.get(uid);
            if (value != null) {
                this.mMetaDataMap.put(uid, value);
                continue;
            }
            MLog.info((Object)TAG, (String)"updateMetadata uid: %d, value is null, ignore", (Object[])new Object[]{uid});
        }
    }

    private boolean metadataContains(int key, Integer ... expectedValues) {
        if (FP.empty((Object[])expectedValues)) {
            return false;
        }
        for (Long uid : this.mMetaDataMap.keySet()) {
            Map<Short, Long> metaData = this.mMetaDataMap.get(uid);
            Long value = metaData.get((short)key);
            for (Integer intValue : expectedValues) {
                Long expectedValueLong = (long)intValue;
                if (!FP.eq((Object)expectedValueLong, (Object)value)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean metadataContainsByUid(long uid, int key, Integer ... expectedValues) {
        if (FP.empty((Object[])expectedValues)) {
            return false;
        }
        Map<Short, Long> metaData = this.mMetaDataMap.get(uid);
        if (metaData == null) {
            return false;
        }
        Long value = metaData.get((short)key);
        for (Integer intValue : expectedValues) {
            Long expectedValueLong = (long)intValue;
            if (!FP.eq((Object)expectedValueLong, (Object)value)) continue;
            return true;
        }
        return false;
    }

    public static AudienceMetadataManagerImpl getInstance() {
        return Holder.INSTANCE;
    }

    private AudienceMetadataManagerImpl() {
    }

    private static class Holder {
        private static final AudienceMetadataManagerImpl INSTANCE = new AudienceMetadataManagerImpl();

        private Holder() {
        }
    }
}

