/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.liveinfo;

import com.yy.mobile.sdkwrapper.flowmanagement.base.entity.VideoPlayInfo;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.exception.ExceptionUtil;
import com.yy.mobile.util.log.MLog;
import com.yy.yylivekit.model.LiveInfo;
import com.yy.yylivekit.model.MixVideoLayout;
import com.yy.yylivekit.model.StreamInfo;
import com.yy.yylivekit.model.VideoInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;

public class LiveInfoUtils {
    private static final String TAG = "LiveInfoUtils";

    public static boolean hasVideo(Collection<LiveInfo> liveInfos) {
        boolean hasVideo = false;
        if (!FP.empty(liveInfos)) {
            for (LiveInfo liveInfo : liveInfos) {
                if (!liveInfo.hasVideo()) continue;
                hasVideo = true;
                break;
            }
        }
        return hasVideo;
    }

    public static List<LiveInfo> getLiveInfosByMicNo(Collection<LiveInfo> liveInfoList, int micNo, boolean videoOnly) {
        MLog.info((Object)TAG, (String)("getLiveInfosByMicNo called with: liveInfoList = [" + liveInfoList + "], micNo = [" + micNo + "], videoOnly = [" + videoOnly + "]"), (Object[])new Object[0]);
        ArrayList<LiveInfo> resultLiveInfoList = new ArrayList<LiveInfo>();
        if (FP.empty(liveInfoList)) {
            return resultLiveInfoList;
        }
        for (LiveInfo liveInfo : liveInfoList) {
            if (videoOnly && !liveInfo.hasVideo()) continue;
            if (liveInfo.isMix) {
                for (StreamInfo streamInfo : liveInfo.streamInfoList) {
                    if (streamInfo.video == null || streamInfo.video.mixLayout == null || streamInfo.video.mixLayout.params == null) continue;
                    for (MixVideoLayout.Params param : streamInfo.video.mixLayout.params) {
                        if (param.mic != micNo) continue;
                        resultLiveInfoList.add(liveInfo);
                    }
                }
                continue;
            }
            if (liveInfo.micNo != micNo || videoOnly && !liveInfo.hasVideo()) continue;
            resultLiveInfoList.add(liveInfo);
        }
        MLog.info((Object)TAG, (String)("getLiveInfosByMicNo called with: liveInfoList = [" + liveInfoList + "], micNo = [" + micNo + "], videoOnly = [" + videoOnly + "], resultList: %s"), (Object[])new Object[]{resultLiveInfoList});
        return resultLiveInfoList;
    }

    public static List<LiveInfo> getLiveInfosByUid(Collection<LiveInfo> liveInfoList, long uid, boolean videoOnly) {
        MLog.info((Object)TAG, (String)("getLiveInfosByUid called with: liveInfoList = [" + liveInfoList + "], uid = [" + uid + "], videoOnly = [" + videoOnly + "]"), (Object[])new Object[0]);
        ArrayList<LiveInfo> resultLiveInfoList = new ArrayList<LiveInfo>();
        if (FP.empty(liveInfoList)) {
            return resultLiveInfoList;
        }
        for (LiveInfo liveInfo : liveInfoList) {
            if (videoOnly && !liveInfo.hasVideo()) continue;
            if (liveInfo.isMix) {
                for (StreamInfo streamInfo : liveInfo.streamInfoList) {
                    if (streamInfo.video == null || streamInfo.video.mixLayout == null || streamInfo.video.mixLayout.params == null) continue;
                    for (MixVideoLayout.Params param : streamInfo.video.mixLayout.params) {
                        if (param.uid != uid) continue;
                        resultLiveInfoList.add(liveInfo);
                    }
                }
                continue;
            }
            if (liveInfo.uid != uid || videoOnly && !liveInfo.hasVideo()) continue;
            resultLiveInfoList.add(liveInfo);
        }
        MLog.info((Object)TAG, (String)("getLiveInfosByUid called with: liveInfoList = [" + liveInfoList + "], uid = [" + uid + "], videoOnly = [" + videoOnly + "],resultList: %s"), (Object[])new Object[]{resultLiveInfoList});
        return resultLiveInfoList;
    }

    public static List<VideoPlayInfo> getVideoPlayInfos(Collection<LiveInfo> liveInfos) {
        ArrayList<VideoPlayInfo> playInfos = new ArrayList<VideoPlayInfo>();
        try {
            if (FP.empty(liveInfos)) {
                MLog.info((Object)TAG, (String)("getVideoStreamUids called with: uids: %s, liveInfos = [" + liveInfos + "]"), (Object[])new Object[]{playInfos});
                return playInfos;
            }
            for (LiveInfo liveInfo : liveInfos) {
                VideoInfo videoInfo;
                if (!liveInfo.hasVideo()) continue;
                if (liveInfo.isMix) {
                    videoInfo = ((StreamInfo)liveInfo.streamInfoList.get((int)0)).video;
                    List params = videoInfo.mixLayout.params;
                    for (MixVideoLayout.Params param : params) {
                        int videoIndex = videoInfo.buzInfo != null ? videoInfo.buzInfo.seat : -1;
                        HashMap<String, String> bizInfoMap = videoInfo.buzInfo == null ? new HashMap<String, String>() : new HashMap(videoInfo.buzInfo.extend);
                        playInfos.add(new VideoPlayInfo(videoInfo.appId, param.uid, true, param.mic, videoIndex, param.w, param.h, -1L, videoInfo.codeRate, videoInfo.fps, bizInfoMap));
                    }
                    continue;
                }
                videoInfo = ((StreamInfo)liveInfo.streamInfoList.get((int)0)).video;
                int videoIndex = videoInfo.buzInfo != null ? videoInfo.buzInfo.seat : -1;
                HashMap<String, String> bizInfoMap = videoInfo.buzInfo == null ? new HashMap<String, String>() : new HashMap(videoInfo.buzInfo.extend);
                playInfos.add(new VideoPlayInfo(videoInfo.appId, liveInfo.uid, false, liveInfo.micNo, videoIndex, videoInfo.width, videoInfo.height, -1L, videoInfo.codeRate, videoInfo.fps, bizInfoMap));
            }
        }
        catch (Exception ex) {
            ExceptionUtil.throwOrWriteLog(TAG, "getVideoPlayInfos failed: %s", ex);
        }
        MLog.info((Object)TAG, (String)("getVideoPlayInfos called with: uids: %s, liveInfos = [" + liveInfos + "]"), (Object[])new Object[]{playInfos});
        return playInfos;
    }

    public static boolean containsUid(LiveInfo liveInfo, long uid) {
        if (!liveInfo.isMix) {
            return liveInfo.uid == uid;
        }
        for (StreamInfo streamInfo : liveInfo.streamInfoList) {
            if (streamInfo.video == null || streamInfo.video.mixLayout == null || streamInfo.video.mixLayout.params == null) continue;
            for (MixVideoLayout.Params param : streamInfo.video.mixLayout.params) {
                if (param.uid != uid) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean containsMicNo(LiveInfo liveInfo, int micNo) {
        if (!liveInfo.isMix) {
            return liveInfo.micNo == micNo;
        }
        for (StreamInfo streamInfo : liveInfo.streamInfoList) {
            if (streamInfo.video == null || streamInfo.video.mixLayout == null || streamInfo.video.mixLayout.params == null) continue;
            for (MixVideoLayout.Params param : streamInfo.video.mixLayout.params) {
                if (param.mic != micNo) continue;
                return true;
            }
        }
        return false;
    }

    public static long getUidByMicNo(Collection<LiveInfo> liveInfos, int micNo) {
        if (FP.empty(liveInfos)) {
            return 0L;
        }
        long uid = 0L;
        boolean hasFoundUidFromStream = false;
        for (LiveInfo liveInfo : liveInfos) {
            if (!liveInfo.hasVideo()) continue;
            if (liveInfo.isMix) {
                block1: for (StreamInfo streamInfo : liveInfo.streamInfoList) {
                    if (streamInfo.video == null || streamInfo.video.mixLayout == null || streamInfo.video.mixLayout.params == null) continue;
                    for (MixVideoLayout.Params param : streamInfo.video.mixLayout.params) {
                        if (param.mic != micNo) continue;
                        hasFoundUidFromStream = true;
                        uid = param.uid;
                        continue block1;
                    }
                }
                continue;
            }
            if (liveInfo.micNo != micNo) continue;
            hasFoundUidFromStream = true;
            uid = liveInfo.uid;
            break;
        }
        if (hasFoundUidFromStream && uid == 0L) {
            MLog.error((Object)TAG, (String)"getUidByMicNo error,  micNo: %d, uid is 0 from live info, liveInfos: %s", (Object[])new Object[]{micNo, liveInfos});
        } else {
            MLog.info((Object)TAG, (String)"getUidByMicNo, micNo: %d uid: %d, liveInfos: %s", (Object[])new Object[]{micNo, uid, liveInfos});
        }
        return uid;
    }
}

