/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.liveinfo;

import android.support.annotation.Nullable;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.liveinfo.LiveInfoUtils;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.log.MLog;
import com.yy.yylivekit.model.LiveInfo;
import com.yy.yylivekit.model.StreamInfo;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;

public class LiveInfoListHolder {
    private static final String TAG = "LiveInfoListHolder";
    private final List<LiveInfo> mLiveInfoList = new CopyOnWriteArrayList<LiveInfo>();

    public void addLiveInfoSet(Set<LiveInfo> liveInfoSet) {
        if (FP.empty(liveInfoSet)) {
            return;
        }
        for (LiveInfo info : liveInfoSet) {
            this.addLiveInfo(info);
        }
    }

    public void removeLiveInfoSet(List<LiveInfo> liveInfoSet) {
        if (FP.empty(liveInfoSet)) {
            return;
        }
        MLog.info((Object)TAG, (String)"removeLiveInfoSet, mLiveInfoList:%s, removedLiveInfoSet:%s", (Object[])new Object[]{this.mLiveInfoList, liveInfoSet});
        for (LiveInfo info : liveInfoSet) {
            this.removeLiveInfo(info);
        }
        MLog.info((Object)TAG, (String)"removeLiveInfoSet, after mLiveInfoList:%s", (Object[])new Object[]{this.mLiveInfoList});
    }

    public void clearLiveInfoList() {
        MLog.info((Object)TAG, (String)"clearLiveInfoList: size:%d", (Object[])new Object[]{this.mLiveInfoList.size()});
        this.mLiveInfoList.clear();
    }

    public List<LiveInfo> getLiveInfoList() {
        return this.mLiveInfoList;
    }

    public int getVideoStreamListSize() {
        List<LiveInfo> liveInfos = this.getLiveInfoList();
        int count = 0;
        block0: for (LiveInfo liveInfo : liveInfos) {
            if (!liveInfo.hasVideo()) continue;
            if (liveInfo.isMultiSource()) {
                return this.getVideoStreamListSizeOnMultiSource(liveInfos);
            }
            if (liveInfo.isMix) {
                for (StreamInfo streamInfo : liveInfo.streamInfoList) {
                    if (streamInfo.video == null) continue;
                    if (streamInfo.video.mixLayout == null) {
                        MLog.error((Object)TAG, (String)"bug!!!!getVideoStreamListSize failed, video is not null while mix layout is null", (Object[])new Object[0]);
                        continue block0;
                    }
                    count += FP.size((Collection)streamInfo.video.mixLayout.params);
                    continue block0;
                }
                continue;
            }
            ++count;
        }
        return count;
    }

    @Nullable
    public String getBizInfoMap(int micNo, String key) {
        List<LiveInfo> liveInfos = LiveInfoUtils.getLiveInfosByMicNo(this.getLiveInfoList(), micNo, true);
        HashMap bizInfoMap = new HashMap();
        for (LiveInfo liveInfo : liveInfos) {
            if (!liveInfo.hasVideo()) continue;
            for (StreamInfo streamInfo : liveInfo.streamInfoList) {
                if (streamInfo.video == null || streamInfo.video.buzInfo == null) continue;
                bizInfoMap.putAll(streamInfo.video.buzInfo.extend);
            }
        }
        String value = (String)bizInfoMap.get(key);
        MLog.info((Object)TAG, (String)("getBizInfoMap called with: key = [" + key + "], micNo: %d value: %s, bizInfoMap: %s"), (Object[])new Object[]{micNo, value, bizInfoMap});
        return value;
    }

    private int getVideoStreamListSizeOnMultiSource(List<LiveInfo> liveInfos) {
        MLog.info((Object)TAG, (String)("getVideoStreamListSizeOnMultiSource called with: liveInfos = [" + liveInfos + "]"), (Object[])new Object[0]);
        return 1;
    }

    public long getUidByMicNo(int micNo) {
        List<LiveInfo> liveInfos = LiveInfoListHolder.getInstance().getLiveInfoList();
        return LiveInfoUtils.getUidByMicNo(liveInfos, micNo);
    }

    @Nullable
    public List<LiveInfo> getLiveInfosByUid(long uid) {
        MLog.info((Object)TAG, (String)"getLiveInfoByUid called with: uid = %d", (Object[])new Object[]{uid});
        return LiveInfoUtils.getLiveInfosByUid(this.mLiveInfoList, uid, false);
    }

    private void addLiveInfo(LiveInfo liveInfo) {
        if (liveInfo != null && !this.mLiveInfoList.contains(liveInfo)) {
            this.mLiveInfoList.add(liveInfo);
            MLog.info((Object)TAG, (String)"\naddLiveInfo, list count: %d, \nliveInfo: %s \nmLiveInfoList:%s", (Object[])new Object[]{this.mLiveInfoList.size(), liveInfo, this.mLiveInfoList});
        } else {
            MLog.error((Object)TAG, (String)"[Bug]addLiveInfo is null or added, info: %s", (Object[])new Object[]{liveInfo});
        }
    }

    private void removeLiveInfo(LiveInfo liveInfo) {
        if (liveInfo != null && !this.mLiveInfoList.isEmpty()) {
            this.mLiveInfoList.remove(liveInfo);
            MLog.info((Object)TAG, (String)"removeLiveInfo, list count: %d, \nliveInfo:%s \nmLiveInfoList:%s", (Object[])new Object[]{this.mLiveInfoList.size(), liveInfo, this.mLiveInfoList});
        }
    }

    public static LiveInfoListHolder getInstance() {
        return Holder.INSTANCE;
    }

    private LiveInfoListHolder() {
    }

    public boolean hasLiveInfos() {
        return FP.size(this.mLiveInfoList) > 0;
    }

    private static class Holder {
        private static final LiveInfoListHolder INSTANCE = new LiveInfoListHolder();

        private Holder() {
        }
    }
}

