/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.liveinfo;

import com.yy.mobile.sdkwrapper.flowmanagement.base.audience.liveinfo.ILiveInfoEntrance;
import com.yy.mobile.sdkwrapper.flowmanagement.base.util.CollectionUtils;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.liveinfo.LiveInfoListHolder;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.liveinfo.LiveInfoNotifyCenter;
import com.yy.mobile.util.exception.ExceptionUtil;
import com.yy.mobile.util.log.MLog;
import com.yy.yylivekit.model.LiveInfo;
import com.yyproto.utils.FP;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class LiveInfoEntranceImpl
implements ILiveInfoEntrance {
    private static final String TAG = "LiveInfoEntranceImpl";
    private LiveInfoListHolder mListHolder = LiveInfoListHolder.getInstance();

    @Override
    public void removeLiveInfoByUid(long uid) {
        List<LiveInfo> removedList = this.mListHolder.getLiveInfosByUid(uid);
        if (removedList != null) {
            this.mListHolder.removeLiveInfoSet(removedList);
        }
        this.notifyRemove(removedList);
    }

    @Override
    public void addLiveInfoSet(Set<LiveInfo> addedSet) {
        MLog.info((Object)TAG, (String)("before addLiveInfoSet called with: total live info list: %s, addedSet = [" + addedSet + "]"), (Object[])new Object[]{this.mListHolder.getLiveInfoList()});
        this.mListHolder.addLiveInfoSet(addedSet);
        MLog.info((Object)TAG, (String)("after addLiveInfoSet called with: total live info list: %s, addedSet = [" + addedSet + "]"), (Object[])new Object[]{this.mListHolder.getLiveInfoList()});
        List<LiveInfo> addedList = this.liveInfoSetToList(addedSet);
        this.notifyAdd(addedList);
    }

    @Override
    public void removeLiveInfoSet(Set<LiveInfo> removedSet) {
        MLog.info((Object)TAG, (String)("before removeLiveInfoSet called with: total live info list: %s, removedSet = [" + removedSet + "]"), (Object[])new Object[]{this.mListHolder.getLiveInfoList()});
        List<LiveInfo> removedList = this.liveInfoSetToList(removedSet);
        this.tryToFixMicNo(removedSet);
        this.mListHolder.removeLiveInfoSet(removedList);
        MLog.info((Object)TAG, (String)("after removeLiveInfoSet called with: total live info list: %s, removedSet = [" + removedSet + "]"), (Object[])new Object[]{this.mListHolder.getLiveInfoList()});
        this.notifyRemove(removedList);
    }

    private void tryToFixMicNo(Set<LiveInfo> removedSet) {
        for (LiveInfo newLiveInfo : removedSet) {
            LiveInfo old;
            List<LiveInfo> oldList;
            if (newLiveInfo.isMix || newLiveInfo.micNo != -1 || FP.empty(oldList = this.mListHolder.getLiveInfosByUid(newLiveInfo.uid)) || (old = oldList.get(0)) == null || old.micNo == newLiveInfo.micNo) continue;
            MLog.error((Object)TAG, (String)"removeLiveInfoSet called, diff mic no, fix it, oldLiveInfo: %s, newLiveInfo: %s", (Object[])new Object[]{old, newLiveInfo});
            newLiveInfo.micNo = old.micNo;
        }
    }

    @Override
    public void removeAllLiveInfoSet() {
        MLog.info((Object)TAG, (String)"removeAllLiveInfoSet called", (Object[])new Object[0]);
        List<LiveInfo> removedList = this.mListHolder.getLiveInfoList();
        this.mListHolder.clearLiveInfoList();
        this.notifyRemove(removedList);
    }

    public void updateLiveInfoSet(Set<LiveInfo> fromSet, Set<LiveInfo> toSet) {
        List<LiveInfo> fromList = this.liveInfoSetToList(fromSet);
        List<LiveInfo> updatedList = this.liveInfoSetToList(toSet);
        List<LiveInfo> totalList = this.mListHolder.getLiveInfoList();
        int expectUpdateCount = FP.size(updatedList);
        MLog.info((Object)TAG, (String)"before updateLiveInfoSet called, before update, origin live info list: %s, target update list: %s", (Object[])new Object[]{totalList, updatedList});
        int actualUpdateCount = CollectionUtils.update(totalList, updatedList);
        if (actualUpdateCount != expectUpdateCount) {
            ExceptionUtil.throwOrWriteLog(TAG, "[Bug]updateLiveInfoSet error, expect update count: %d, actual count: %d", expectUpdateCount, actualUpdateCount);
        }
        MLog.info((Object)TAG, (String)("after updateLiveInfoSet called: total live info list = [" + totalList + "]"), (Object[])new Object[0]);
        this.notifyUpdate(fromList, updatedList);
    }

    private void notifyRemove(List<LiveInfo> liveInfos) {
        LiveInfoNotifyCenter.getInstance().notifyRemove(liveInfos);
    }

    private void notifyAdd(List<LiveInfo> liveInfos) {
        LiveInfoNotifyCenter.getInstance().notifyAdd(liveInfos);
    }

    private void notifyUpdate(List<LiveInfo> fromLiveInfos, List<LiveInfo> toLiveInfos) {
        LiveInfoNotifyCenter.getInstance().notifyUpdate(fromLiveInfos, toLiveInfos);
    }

    private List<LiveInfo> liveInfoSetToList(Set<LiveInfo> set) {
        ArrayList<LiveInfo> liveInfos = new ArrayList<LiveInfo>();
        if (FP.size(set) > 0) {
            for (LiveInfo liveInfo : set) {
                if (liveInfo != null) {
                    liveInfos.add(liveInfo);
                    continue;
                }
                ExceptionUtil.throwOrWriteLog(TAG, "liveInfoSetToList failed, live info is null", new Object[0]);
            }
        }
        return liveInfos;
    }

    public static LiveInfoEntranceImpl getInstance() {
        return Holder.INSTANCE;
    }

    private LiveInfoEntranceImpl() {
    }

    private static class Holder {
        private static final LiveInfoEntranceImpl INSTANCE = new LiveInfoEntranceImpl();

        private Holder() {
        }
    }
}

