/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.groupinfo;

import com.yy.mobile.sdkwrapper.flowmanagement.base.audience.groupinfo.GroupInfoChangeEventHandler;
import com.yy.mobile.sdkwrapper.flowmanagement.base.audience.groupinfo.IGroupInfoEntrance;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.groupinfo.GroupInfoListHolder;
import com.yy.yylivekit.model.GroupInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class GroupInfoEntranceImpl
implements IGroupInfoEntrance {
    private static final String TAG = "GroupInfoEntranceImpl";
    private GroupInfoListHolder groupInfoListHolder = GroupInfoListHolder.getInstance();

    @Override
    public void addGroupInfoSet(Set<GroupInfo> setToAdd) {
        this.groupInfoListHolder.addGroupInfoSet(setToAdd);
        ArrayList<GroupInfo> groupInfos = new ArrayList<GroupInfo>(setToAdd);
        this.notifyAddGroupInfo(groupInfos);
    }

    @Override
    public void removeGroupInfoSet(Set<GroupInfo> setToRemove) {
        this.groupInfoListHolder.removeGroupInfoSet(setToRemove);
        ArrayList<GroupInfo> groupInfos = new ArrayList<GroupInfo>(setToRemove);
        this.notifyRemoveGroupInfo(groupInfos);
    }

    public void clearGroupInfoData() {
        this.groupInfoListHolder.clearGroupInfos();
    }

    private void notifyAddGroupInfo(List<GroupInfo> groupInfos) {
        GroupInfoChangeEventHandler.getInstance().notifyAddGroupInfos(groupInfos, this.groupInfoListHolder.getGroupInfoList());
    }

    private void notifyRemoveGroupInfo(List<GroupInfo> groupInfos) {
        GroupInfoChangeEventHandler.getInstance().notifyRemoveGroupInfos(groupInfos, this.groupInfoListHolder.getGroupInfoList());
    }

    private GroupInfoEntranceImpl() {
    }

    public static GroupInfoEntranceImpl getInstance() {
        return Holder.INSTANCE;
    }

    private static class Holder {
        private static GroupInfoEntranceImpl INSTANCE = new GroupInfoEntranceImpl();

        private Holder() {
        }
    }
}

