/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.groupinfo;

import com.medialib.video.MediaVideoMsg;
import com.yy.mobile.RxBus;
import com.yy.mobile.sdkwrapper.yylive.media.event.AudioSpeakerInfoEventArgs;
import com.yy.mobile.util.log.MLog;
import com.yyproto.utils.FP;
import io.reactivex.Observable;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;

public class AudioStreamStatusProxy {
    public static final String TAG = "AudioStreamStatusProxy";
    private Map<Long, Long> mAudioStreamSpeakers = new ConcurrentHashMap<Long, Long>();
    private Map<Long, Long> mRemovedSpeakers = new ConcurrentHashMap<Long, Long>();
    private List<Long> tempBuffList = new ArrayList<Long>();
    private Disposable mTimer;

    public synchronized void acceptOriginData(MediaVideoMsg.LiveAudioStreamStatusInfo info) {
        if (info.status == 2) {
            this.filterSpeakers(this.mAudioStreamSpeakers, info.actualUids);
            this.filterSpeakers(this.mRemovedSpeakers, info.actualUids);
            this.nofitySpeakersStatus(info.actualUids, 2);
            return;
        }
        long[] removedUids = this.findDiffRemovedSpeaker(this.mAudioStreamSpeakers, info.actualUids);
        this.filterSpeakers(this.mAudioStreamSpeakers, removedUids);
        this.filterSpeakers(this.mRemovedSpeakers, info.actualUids);
        this.updateSpeakersCurrentTime(this.mRemovedSpeakers, removedUids);
        long[] newSpeakers = this.findAndUpdateNewSpeakers(info.actualUids);
        this.nofitySpeakersStatus(newSpeakers, 1);
        this.filterNotifyTimeoutSpeakers();
    }

    private void resetTempBuffList() {
        if (this.tempBuffList == null) {
            this.tempBuffList = new ArrayList<Long>();
        }
        this.tempBuffList.clear();
    }

    private long[] findDiffRemovedSpeaker(Map<Long, Long> targetMap, long[] actualUids) {
        this.resetTempBuffList();
        if (null != targetMap) {
            for (Map.Entry<Long, Long> entry : targetMap.entrySet()) {
                long uid = entry.getKey();
                boolean removed = true;
                for (int i = 0; i < actualUids.length; ++i) {
                    if (uid != actualUids[i]) continue;
                    removed = false;
                }
                if (!removed) continue;
                this.tempBuffList.add(uid);
            }
        }
        long[] removers = new long[this.tempBuffList.size()];
        for (int i = 0; i < this.tempBuffList.size(); ++i) {
            removers[i] = this.tempBuffList.get(i);
        }
        return removers;
    }

    private long[] findAndUpdateNewSpeakers(long[] actualUids) {
        this.resetTempBuffList();
        if (this.mAudioStreamSpeakers != null) {
            for (int i = 0; i < actualUids.length; ++i) {
                if (!this.mAudioStreamSpeakers.containsKey(actualUids[i])) {
                    this.tempBuffList.add(actualUids[i]);
                }
                long curTime = System.currentTimeMillis();
                this.mAudioStreamSpeakers.put(actualUids[i], curTime);
            }
        }
        long[] newers = new long[this.tempBuffList.size()];
        for (int i = 0; i < this.tempBuffList.size(); ++i) {
            newers[i] = this.tempBuffList.get(i);
        }
        return newers;
    }

    private void nofitySpeakersStatus(long[] uids, int status) {
        if (!FP.empty((long[])uids)) {
            for (int i = 0; i < uids.length; ++i) {
                RxBus.getDefault().post((Object)new AudioSpeakerInfoEventArgs(uids[i], status));
            }
        }
    }

    private void updateSpeakersCurrentTime(Map<Long, Long> targetMap, long[] uids) {
        if (targetMap != null && !FP.empty((long[])uids)) {
            long curTime = System.currentTimeMillis();
            long[] lArray = uids;
            int n = lArray.length;
            for (int i = 0; i < n; ++i) {
                Long uid = lArray[i];
                targetMap.put(uid, curTime);
            }
        }
    }

    private void filterSpeakers(Map<Long, Long> targetMap, long[] uids) {
        if (targetMap != null && !FP.empty((long[])uids)) {
            for (int i = 0; i < uids.length; ++i) {
                if (!targetMap.containsKey(uids[i])) continue;
                targetMap.remove(uids[i]);
            }
        }
    }

    private void filterNotifyTimeoutSpeakers() {
        if (this.mTimer == null || this.mTimer.isDisposed()) {
            this.mTimer = Observable.interval((long)5000L, (TimeUnit)TimeUnit.MILLISECONDS).observeOn(Schedulers.io()).subscribeOn(AndroidSchedulers.mainThread()).subscribe((Consumer)new Consumer<Long>(){

                public void accept(Long aLong) throws Exception {
                    if (!FP.empty((Map)AudioStreamStatusProxy.this.mRemovedSpeakers)) {
                        long curTime = System.currentTimeMillis();
                        for (Map.Entry entry : AudioStreamStatusProxy.this.mRemovedSpeakers.entrySet()) {
                            if (curTime - (Long)entry.getValue() <= 5000L) continue;
                            RxBus.getDefault().post((Object)new AudioSpeakerInfoEventArgs((Long)entry.getKey(), 2));
                            AudioStreamStatusProxy.this.mRemovedSpeakers.remove(entry.getKey());
                        }
                    }
                }
            }, (Consumer)new Consumer<Throwable>(){

                public void accept(Throwable throwable) throws Exception {
                    MLog.error((Object)AudioStreamStatusProxy.TAG, (String)("filterNotifyTimeoutSpeakers: throwable=" + throwable), (Object[])new Object[0]);
                }
            });
        }
    }

    public void release() {
        if (this.mAudioStreamSpeakers != null) {
            this.mAudioStreamSpeakers.clear();
        }
        if (this.mTimer != null && !this.mTimer.isDisposed()) {
            this.mTimer.dispose();
            this.mTimer = null;
        }
    }

    public static AudioStreamStatusProxy getInstance() {
        return Holder.INSTANCE;
    }

    private static class Holder {
        private static AudioStreamStatusProxy INSTANCE = new AudioStreamStatusProxy();

        private Holder() {
        }
    }

    public static class AudioStreamStatus {
        public static final int START = 1;
        public static final int STOP = 2;
        public static final int SPEAKING = 3;
    }
}

