/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.sdkwrapper.flowmanagement.internal.audience;

import android.content.Context;
import android.graphics.Bitmap;
import android.view.View;
import android.view.ViewGroup;
import com.yy.mobile.RxBus;
import com.yy.mobile.sdkwrapper.flowmanagement.api.audience.liveinfo.LiveInfoChangeEventHandler;
import com.yy.mobile.sdkwrapper.flowmanagement.base.audience.IAudienceVideoView;
import com.yy.mobile.sdkwrapper.flowmanagement.base.audience.liveinfo.LiveInfoChangeListener;
import com.yy.mobile.sdkwrapper.flowmanagement.base.entity.AudienceVideoQuality;
import com.yy.mobile.sdkwrapper.flowmanagement.base.entity.VideoScaleMode;
import com.yy.mobile.sdkwrapper.flowmanagement.event.audience.videoview.AudienceVideoAddViewStartEvent;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.liveinfo.LiveInfoUtils;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.player.LivePlayerFactory;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.videoid.AbsVideoId;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.videoquality.AudienceVideoQualityManagerImpl;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audio.AudioManagerImpl;
import com.yy.mobile.util.exception.ExceptionUtil;
import com.yy.mobile.util.log.MLog;
import com.yy.yylivekit.ILivePlayer;
import com.yy.yylivekit.audience.LivePlayer;
import com.yy.yylivekit.model.LiveInfo;
import com.yyproto.utils.FP;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class AudienceVideoViewSource
implements IAudienceVideoView,
LiveInfoChangeListener {
    private static final String TAG = "AudienceVideoViewSource";
    private LivePlayer mLivePlayer;
    private ViewGroup mVideoContainer;
    private View mVideoView;
    private Context mContext;
    private VideoScaleMode mCurrentScaleMode;
    private AbsVideoId mVideoId;
    private boolean mIsVideoEnable = true;
    private boolean mHasStarted;
    private boolean mIsReleased;

    public AudienceVideoViewSource(ViewGroup videoContainer) {
        MLog.info((Object)TAG, (String)"init AudienceVideoViewSource, this: %s", (Object[])new Object[]{this});
        this.mContext = videoContainer.getContext();
        this.mVideoContainer = videoContainer;
    }

    public void init() {
        MLog.info((Object)TAG, (String)"init called", (Object[])new Object[0]);
        this.updateIsReleased(false);
    }

    private void updateIsReleased(boolean isReleased) {
        MLog.info((Object)TAG, (String)"updateIsReleased, from %b to %b", (Object[])new Object[]{this.mIsReleased, isReleased});
        this.mIsReleased = isReleased;
    }

    @Override
    public void start(AbsVideoId videoId) {
        if (this.mHasStarted && FP.eq((Object)this.mVideoId, (Object)videoId)) {
            MLog.info((Object)TAG, (String)"start called, has started and same video id, do nothing", (Object[])new Object[0]);
            return;
        }
        if (this.mIsReleased) {
            MLog.error((Object)TAG, (String)"AudienceVideoView start called ignore, already released, videoId: %s, this: %s", (Object[])new Object[]{this.mVideoId, this});
            return;
        }
        MLog.info((Object)TAG, (String)("start called with: videoId = [" + videoId + "], this: %s"), (Object[])new Object[]{this});
        this.setHasStarted(true);
        this.setVideoId(videoId);
        this.ensureRegisterLiveInfoChangeListener();
    }

    private void ensureRegisterLiveInfoChangeListener() {
        LiveInfoChangeEventHandler.getInstance().addLiveInfoChangeListener(this);
    }

    @Override
    public void stop() {
        MLog.info((Object)TAG, (String)"stop called", (Object[])new Object[0]);
        LiveInfoChangeEventHandler.getInstance().removeLiveInfoChangeListener(this);
        this.innerStopVideo();
    }

    @Override
    public void setVideoEnable(boolean enable) {
        this.mIsVideoEnable = enable;
        if (this.mLivePlayer != null) {
            MLog.info((Object)TAG, (String)("setVideoEnable called with: enable = [" + enable + "], this: %s"), (Object[])new Object[]{this});
            if (enable) {
                this.createAndAddVideoViewToContainer();
            } else {
                this.destroyVideoView();
            }
            this.mLivePlayer.setVideoEnabled(enable);
        } else {
            MLog.info((Object)TAG, (String)("setVideoEnable called with: enable = [" + enable + "], player is null, ignore, this: %s"), (Object[])new Object[]{this});
        }
    }

    @Override
    public void setAudioEnable(boolean enable) {
        if (this.mLivePlayer != null) {
            MLog.info((Object)TAG, (String)("setAudioEnable called with: enable = [" + enable + "]"), (Object[])new Object[0]);
            this.mLivePlayer.setAudioEnable(enable);
        } else {
            MLog.info((Object)TAG, (String)"setAudioEnable ignore, player is null, enable: %b", (Object[])new Object[]{enable});
        }
    }

    @Override
    public void release() {
        MLog.info((Object)TAG, (String)"-----release, this: %s, videoId: %s", (Object[])new Object[]{this, this.mVideoId});
        LiveInfoChangeEventHandler.getInstance().removeLiveInfoChangeListener(this);
        this.updateIsReleased(true);
        this.innerStopVideo();
    }

    @Override
    public void setScaleMode(VideoScaleMode scaleMode) {
        this.mCurrentScaleMode = scaleMode;
        this.setScaleModeIfPlayerCreated(scaleMode);
    }

    @Override
    public void setZOrderMediaOverlay(boolean isMediaOverlay) {
        MLog.info((Object)TAG, (String)("setZOrderMediaOverlay() called with: isMediaOverlay = [" + isMediaOverlay + "]"), (Object[])new Object[0]);
        if (this.mLivePlayer != null) {
            this.mLivePlayer.getMediaViewProxy().setZOrderMediaOverlay(isMediaOverlay);
        } else {
            MLog.info((Object)TAG, (String)"setZOrderMediaOverlay: null mLivePlayer", (Object[])new Object[0]);
        }
    }

    @Override
    public void setZOrderOnTop(boolean onTop) {
        MLog.info((Object)TAG, (String)("setZOrderOnTop() called with: onTop = [" + onTop + "]"), (Object[])new Object[0]);
        if (this.mLivePlayer != null) {
            this.mLivePlayer.getMediaViewProxy().setZOrderOnTop(onTop);
        } else {
            MLog.info((Object)TAG, (String)"setZOrderOnTop: null mLivePlayer", (Object[])new Object[0]);
        }
    }

    @Override
    public void setVideoViewVisible(boolean visible) {
        MLog.info((Object)TAG, (String)("setVideoViewVisible() called with: visible = [" + visible + "]"), (Object[])new Object[0]);
        if (this.mLivePlayer != null) {
            this.mLivePlayer.getMediaViewProxy().setVideoContainVisibility(visible ? 0 : 8);
        } else {
            MLog.info((Object)TAG, (String)"setVideoViewVisible: null mLivePlayer", (Object[])new Object[0]);
        }
    }

    @Override
    public Bitmap getVideoScreenshot() {
        Bitmap bitmap = null;
        if (this.mLivePlayer != null) {
            bitmap = this.mLivePlayer.getVideoScreenShot();
        }
        MLog.info((Object)TAG, (String)"getVideoScreenshot called: %s", (Object[])new Object[]{bitmap});
        return bitmap;
    }

    @Override
    public void onAddLiveInfos(List<LiveInfo> liveInfos) {
        if (this.mVideoId == null) {
            return;
        }
        MLog.info((Object)TAG, (String)("onAddLiveInfos called with: videoId: %s, liveInfos = [" + liveInfos + "]"), (Object[])new Object[]{this.mVideoId});
        Set<LiveInfo> addedLiveInfos = this.mVideoId.getLiveInfosToAdd(liveInfos);
        boolean started = this.tryToStartVideo(addedLiveInfos);
        if (started) {
            MLog.info((Object)TAG, (String)"====found liveInfos to start video onAddLiveInfos, videoId: %s, this: %s, fullAdd: %s, found live infos: %s", (Object[])new Object[]{this.mVideoId, this, liveInfos, addedLiveInfos});
        }
    }

    @Override
    public void onRemoveLiveInfos(List<LiveInfo> liveInfos) {
        if (this.mVideoId == null) {
            MLog.info((Object)TAG, (String)("onRemoveLiveInfos called with null video id, return, liveInfos = [" + liveInfos + "]"), (Object[])new Object[0]);
            return;
        }
        Set<LiveInfo> removedLiveInfos = this.mVideoId.removeLiveInfoIfNeeded(liveInfos);
        MLog.info((Object)TAG, (String)("onRemoveLiveInfos called with: removedLiveInfos\uff1a %s, liveInfos = [" + liveInfos + "], videoId: %s, this: %s"), (Object[])new Object[]{removedLiveInfos, this.mVideoId, this});
        if (removedLiveInfos.size() > 0) {
            MLog.info((Object)TAG, (String)"onRemoveLiveInfos, found live infos to remove: %s, fullRemovedLiveInfoList see pre log, mVideoId: %s, this: %s", (Object[])new Object[]{removedLiveInfos, this.mVideoId, this});
            if (!this.mVideoId.hasVideo()) {
                MLog.info((Object)TAG, (String)"onRemoveLiveInfos, no more video left, stop video, mVideoId: %s, removedLiveInfos: %s, this: %s", (Object[])new Object[]{this.mVideoId, removedLiveInfos, this});
                this.innerStopVideo();
            } else {
                MLog.info((Object)TAG, (String)"onRemoveLiveInfos, removed some live infos, still has video left, removedLiveInfos: %s, this: %s", (Object[])new Object[]{removedLiveInfos, this});
            }
        }
    }

    @Override
    public void onUpdateLiveInfos(List<LiveInfo> fromLiveInfos, List<LiveInfo> toLiveInfos) {
        if (this.mVideoId == null) {
            return;
        }
        MLog.info((Object)TAG, (String)("onUpdateLiveInfos called with: fromLiveInfos = [" + fromLiveInfos + "], toLiveInfos = [" + toLiveInfos + "], videoId: %s, this: %s"), (Object[])new Object[]{this.mVideoId, this});
        Set<LiveInfo> addedLiveInos = this.mVideoId.getLiveInfosToAdd(toLiveInfos);
        boolean started = this.tryToStartVideo(addedLiveInos);
        if (started) {
            MLog.info((Object)TAG, (String)"====found liveInfos to start video onUpdateLiveInfos, videoId: %s, this: %s, fullUpdatedInfos: %s, found live infos: %s", (Object[])new Object[]{this.mVideoId, this, toLiveInfos, addedLiveInos});
        }
        Set<LiveInfo> newUpdatedLiveInfo = this.mVideoId.getLiveInfosToUpdate(toLiveInfos);
        this.mVideoId.updateLiveInfos(newUpdatedLiveInfo);
        this.tryToUpdateLivePlayerOnUpdate(fromLiveInfos, toLiveInfos, newUpdatedLiveInfo);
        this.tryToStopPlayerOnUpdate(fromLiveInfos, toLiveInfos, newUpdatedLiveInfo);
    }

    private void tryToStopPlayerOnUpdate(List<LiveInfo> fromLiveInfos, List<LiveInfo> toLiveInfos, Set<LiveInfo> newUpdatedLiveInfo) {
        if (this.mVideoId != null && !this.mVideoId.hasVideo()) {
            MLog.info((Object)TAG, (String)("====onUpdateLiveInfos, VideoId has no video, ====stop video====, videoId: %s, fromLiveInfos = [" + fromLiveInfos + "], toLiveInfos = [" + toLiveInfos + "], newUpdatedLiveInfos: %s"), (Object[])new Object[]{this.mVideoId, newUpdatedLiveInfo});
            this.innerStopVideo();
        }
    }

    private void tryToUpdateLivePlayerOnUpdate(List<LiveInfo> fromLiveInfos, List<LiveInfo> toLiveInfos, Set<LiveInfo> newUpdatedLiveInfo) {
        if (newUpdatedLiveInfo.size() > 0) {
            MLog.info((Object)TAG, (String)("====onUpdateLiveInfos found live info to update player, newUpdatedLiveInfo: %s: fromLiveInfos = [" + fromLiveInfos + "], toLiveInfos = [" + toLiveInfos + "]"), (Object[])new Object[]{newUpdatedLiveInfo});
            if (LiveInfoUtils.hasVideo(newUpdatedLiveInfo)) {
                AudienceVideoQuality quality = AudienceVideoQualityManagerImpl.getInstance().getVideoQualityToPlay();
                this.setVideoQualityInner(quality);
            }
            this.mLivePlayer.updateLiveInfoSet(newUpdatedLiveInfo);
        }
    }

    private void innerStartVideo(Set<LiveInfo> liveInfos) {
        MLog.info((Object)TAG, (String)"innerStartVideo start", (Object[])new Object[0]);
        boolean hasVideo = LiveInfoUtils.hasVideo(liveInfos);
        AudienceVideoQuality quality = null;
        int lineNum = -1;
        int videoSource = -1;
        if (this.mLivePlayer != null) {
            if (hasVideo) {
                this.setScaleModeIfPlayerCreated(this.mCurrentScaleMode);
                lineNum = AudienceVideoQualityManagerImpl.getInstance().getStreamLineToPlay();
                this.mLivePlayer.setVideoLine(lineNum);
                videoSource = AudienceVideoQualityManagerImpl.getInstance().getVideoSourceToPlay();
                this.mLivePlayer.setVideoSource(videoSource);
                quality = AudienceVideoQualityManagerImpl.getInstance().getVideoQualityToPlay();
                this.setVideoQualityInner(quality);
            }
            MLog.info((Object)TAG, (String)("-----innerStartVideo, live player exist, add live infos to player, hasVideo: %b, VideoQuality: %s, linNum: %d, videoSource: %dliveInfos = [" + liveInfos + "]"), (Object[])new Object[]{hasVideo, quality, lineNum, videoSource});
            this.mLivePlayer.addLiveInfoSet(liveInfos);
        } else {
            this.createLivePlayerIfNeeded(liveInfos);
            this.setScaleModeIfPlayerCreated(this.mCurrentScaleMode);
            if (hasVideo) {
                lineNum = AudienceVideoQualityManagerImpl.getInstance().getStreamLineToPlay();
                this.mLivePlayer.setVideoLine(lineNum);
                videoSource = AudienceVideoQualityManagerImpl.getInstance().getVideoSourceToPlay();
                this.mLivePlayer.setVideoSource(videoSource);
                quality = AudienceVideoQualityManagerImpl.getInstance().getVideoQualityToPlay();
                this.setVideoQualityInner(quality);
            }
            MLog.info((Object)TAG, (String)"-----innerStartVideo, videoId: %s, video quality: %s, isVideoEnable: %b, hasVideo: %b, lineNum: %d, videoSource: %d, scaleMode: %s, this: %s", (Object[])new Object[]{this.mVideoId, quality, this.mIsVideoEnable, hasVideo, lineNum, videoSource, this.mCurrentScaleMode, this});
            ILivePlayer.PlayOption playOption = this.getPlayOption();
            if (playOption != null) {
                this.mLivePlayer.startPlay(playOption, true);
            } else {
                MLog.error((Object)TAG, (String)"innerStartVideo, play option is null, do nothing", (Object[])new Object[0]);
            }
        }
        MLog.info((Object)TAG, (String)"innerStartVideo end", (Object[])new Object[0]);
    }

    private ILivePlayer.PlayOption getPlayOption() {
        boolean needToSubscribeAudio = AudioManagerImpl.getInstance().isNeedToSubscribeAudio();
        Object playOption = this.mIsVideoEnable ? (needToSubscribeAudio ? ILivePlayer.PlayOption.ALL : ILivePlayer.PlayOption.Video) : (needToSubscribeAudio ? ILivePlayer.PlayOption.Audio : null);
        MLog.info((Object)TAG, (String)"getPlayOption: option: %s, needVideo: %b, needAudio: %b, this: %s", (Object[])new Object[]{playOption, this.mIsVideoEnable, needToSubscribeAudio, this});
        return playOption;
    }

    private void createLivePlayerIfNeeded(Set<LiveInfo> liveInfos) {
        if (FP.empty(liveInfos)) {
            ExceptionUtil.throwOrWriteLog(TAG, "[Bug]createLivePlayer with empty liveInfos: %s", liveInfos);
            return;
        }
        if (this.mLivePlayer != null) {
            MLog.info((Object)TAG, (String)"createLivePlayer, mLivePlayer is not null, stop it before create new live player, %s", (Object[])new Object[]{this.mLivePlayer});
            this.innerStopVideo();
            this.mVideoId.addLiveInfos(liveInfos);
        }
        LiveInfo firstLiveInfo = new ArrayList<LiveInfo>(liveInfos).get(0);
        this.mLivePlayer = LivePlayerFactory.getInstance().getLivePlayer(firstLiveInfo);
        if (this.mLivePlayer == null) {
            this.mLivePlayer = LivePlayerFactory.getInstance().createLivePlayer(firstLiveInfo);
            MLog.info((Object)TAG, (String)("-----createLivePlayer called with: liveInfo = [" + firstLiveInfo + "], player: %s, this: %s"), (Object[])new Object[]{this.mLivePlayer, this});
            this.mLivePlayer.addLiveInfoSet(liveInfos);
        } else {
            MLog.info((Object)TAG, (String)("-----get LivePlayer from cache, update liveInfo = [" + firstLiveInfo + "], player: %s, this: %s"), (Object[])new Object[]{this.mLivePlayer, this});
            if (LiveInfoUtils.hasVideo(liveInfos)) {
                this.setVideoQualityInner(AudienceVideoQualityManagerImpl.getInstance().getVideoQualityToPlay());
            }
            this.addOrUpdateLiveInfoToPlayer(liveInfos);
        }
        this.createAndAddVideoViewToContainer();
    }

    private void addOrUpdateLiveInfoToPlayer(Set<LiveInfo> liveInfos) {
        HashSet<LiveInfo> addLiveInfoSet = new HashSet<LiveInfo>();
        HashSet<LiveInfo> updateLiveInfoSet = new HashSet<LiveInfo>();
        for (LiveInfo liveInfo : liveInfos) {
            if (this.mLivePlayer.isContain(liveInfo)) {
                updateLiveInfoSet.add(liveInfo);
                continue;
            }
            addLiveInfoSet.add(liveInfo);
        }
        MLog.info((Object)TAG, (String)("addOrUpdateLiveInfoToPlayer called with: liveInfos = [" + liveInfos + "]addLiveInfoSet: %s, updateLiveInfoSet: %s"), (Object[])new Object[]{addLiveInfoSet, updateLiveInfoSet});
        this.mLivePlayer.addLiveInfoSet(addLiveInfoSet);
        this.mLivePlayer.updateLiveInfoSet(updateLiveInfoSet);
    }

    private void setVideoId(AbsVideoId videoId) {
        MLog.info((Object)TAG, (String)("setVideoId called with: videoId = [" + videoId + "]"), (Object[])new Object[0]);
        this.mVideoId = videoId;
    }

    private void innerStopVideo() {
        MLog.info((Object)TAG, (String)"-----innerStopVideo, this: %s, videoId: %s, player: %s", (Object[])new Object[]{this, this.mVideoId, this.mLivePlayer});
        if (this.mLivePlayer != null) {
            this.mLivePlayer.setVideoEnabled(false);
        }
        this.resetData();
    }

    private void resetData() {
        MLog.info((Object)TAG, (String)"-----resetData, this: %s", (Object[])new Object[]{this});
        this.destroyVideoView();
        this.setHasStarted(false);
        this.mLivePlayer = null;
        if (this.mVideoId != null) {
            this.mVideoId.clearLiveInfos();
        }
    }

    private void destroyVideoView() {
        if (this.mLivePlayer != null) {
            MLog.info((Object)TAG, (String)"-----destroyVideoView called, mVideoView: %s, this: %s", (Object[])new Object[]{this.mVideoView, this});
            this.mLivePlayer.destoryMediaView();
            if (this.mVideoView != null) {
                this.mVideoContainer.removeView(this.mVideoView);
                this.mVideoView = null;
            }
        } else {
            MLog.info((Object)TAG, (String)"destroyVideoView ignored, live player is null", (Object[])new Object[0]);
        }
    }

    private void setScaleModeIfPlayerCreated(VideoScaleMode scaleMode) {
        if (this.mLivePlayer != null && scaleMode != null) {
            this.mLivePlayer.getMediaViewProxy().setScale(scaleMode.toFlowScaleMode());
            MLog.info((Object)TAG, (String)("-----set scale mode called with: scaleMode = [" + (Object)((Object)scaleMode) + "], this: %s"), (Object[])new Object[]{this});
        } else {
            MLog.info((Object)TAG, (String)"set scale mode ignored, invalid argument, player: %s, scaleMode: %s", (Object[])new Object[]{this.mLivePlayer, scaleMode});
        }
    }

    private void createAndAddVideoViewToContainer() {
        MLog.info((Object)TAG, (String)"createAndAddVideoViewToContainer called\uff0c videoId: %s, this: %s", (Object[])new Object[]{this.mVideoId, this});
        try {
            this.mLivePlayer.createMediaView(this.mContext);
            this.addVideoViewToContainer(this.mLivePlayer.getVideoView());
            RxBus.getDefault().post((Object)new AudienceVideoAddViewStartEvent());
        }
        catch (Exception e) {
            ExceptionUtil.throwOrWriteLog(TAG, "[Bug]createAndAddVideoViewToContainer failed, mIsReleased: %b, error: %s", this.mIsReleased, e);
        }
        MLog.info((Object)TAG, (String)"createAndAddVideoViewToContainer end", (Object[])new Object[0]);
    }

    private void addVideoViewToContainer(View videoView) {
        MLog.info((Object)TAG, (String)("try to addVideoViewToContainer called with: videoView = [" + videoView + "], this: %s"), (Object[])new Object[]{this});
        if (videoView != null && videoView != this.mVideoView) {
            if (this.mVideoView != null) {
                MLog.info((Object)TAG, (String)"addVideoViewToContainer, remove pre video view", (Object[])new Object[0]);
                this.mVideoContainer.removeView(this.mVideoView);
            }
            this.mVideoContainer.addView(videoView, -1, -1);
            this.mVideoView = videoView;
            MLog.info((Object)TAG, (String)"----addVideoViewToContainer success, video view count: %d, videoId: %s, this: %s, videoView: %s", (Object[])new Object[]{this.mVideoContainer.getChildCount(), this.mVideoId, this, videoView});
        } else {
            MLog.warn((Object)TAG, (String)"addVideoViewToContainer ignored, same video view, videoView: %s, mVideoView: %s, currentLiveInfo: %s", (Object[])new Object[]{videoView, this.mVideoView, this.mVideoId});
        }
    }

    private void setVideoQualityInner(AudienceVideoQuality quality) {
        MLog.info((Object)TAG, (String)("setVideoQualityInner called with: quality = [" + quality + "]"), (Object[])new Object[0]);
        if (quality != null) {
            this.mLivePlayer.setVideoQuality(quality.toGearInfo());
        } else {
            ExceptionUtil.throwOrWriteLog(TAG, "setVideoQualityInner, video quality is null", new Object[0]);
        }
    }

    private boolean tryToStartVideo(Set<LiveInfo> addedLiveInfos) {
        if (!FP.empty(addedLiveInfos)) {
            MLog.info((Object)TAG, (String)("===found live info to start video, addedLiveInfos = [" + addedLiveInfos + "]"), (Object[])new Object[0]);
            this.mVideoId.addLiveInfos(addedLiveInfos);
            this.innerStartVideo(addedLiveInfos);
            return true;
        }
        MLog.info((Object)TAG, (String)"tryToStartVideo called with empty live info, do nothing", (Object[])new Object[0]);
        return false;
    }

    private void setHasStarted(boolean hasStarted) {
        MLog.info((Object)TAG, (String)("setHasStarted called with: hasStarted = [" + hasStarted + "]"), (Object[])new Object[0]);
        this.mHasStarted = hasStarted;
    }
}

