/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.sdkwrapper.flowmanagement.internal.audience;

import com.medialib.video.MediaVideoMsg;
import com.yy.mobile.RxBus;
import com.yy.mobile.sdkwrapper.flowmanagement.api.anchor.compat.AnchorTransConfigHolder;
import com.yy.mobile.sdkwrapper.flowmanagement.base.entity.TransConfig;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.groupinfo.AudioStreamStatusProxy;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.groupinfo.GroupInfoEntranceImpl;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.liveinfo.LiveInfoEntranceImpl;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.metadata.AudienceMetadataManagerImpl;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.nolive.NoLiveManager;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.player.LivePlayerFactory;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.radioplayer.RadioPlayerManagerImpl;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audio.AudioSpeakersManagerImpl;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.streamcompat.VideoStreamCompatImpl;
import com.yy.mobile.sdkwrapper.yylive.media.event.AudioRenderVolumeInfoEventArgs;
import com.yy.mobile.sdkwrapper.yylive.media.event.ChannelAudioStateInfoEventArgs;
import com.yy.mobile.sdkwrapper.yylive.media.event.MediaLinkInfoEventArgs;
import com.yy.mobile.sdkwrapper.yylive.media.event.MetaDataChangeEventArgs;
import com.yy.mobile.sdkwrapper.yylive.media.event.VideoViewLossNotifyInfoEventArgs;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.log.MLog;
import com.yy.yylivekit.audience.Audience;
import com.yy.yylivekit.audience.AudienceEventHandler;
import com.yy.yylivekit.model.GroupInfo;
import com.yy.yylivekit.model.LiveInfo;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public class AudienceManagerInternal {
    private static final String TAG = "AudienceManager";
    private static final String TAG_SUFFIX = "lic==";
    private Audience mAudience;
    private long mLastUid = 0L;
    private long mLastTime = 0L;
    private static final long TIME_INTERVAL = 500L;
    private AudienceEventHandler mAudienceEventHandler = new AudienceEventHandler(){

        public void onUpdateMetaData(Map<Long, Map<Short, Long>> metaData) {
            MLog.info((Object)AudienceManagerInternal.TAG, (String)"onUpdateMetaData: %s", (Object[])new Object[]{metaData});
            AudienceMetadataManagerImpl.getInstance().updateMetadata(metaData);
            RxBus.getDefault().post((Object)new MetaDataChangeEventArgs());
        }

        public void didAddLiveInfoSet(Set<LiveInfo> freshSet) {
            MLog.info((Object)AudienceManagerInternal.TAG, (String)"=========didAddLiveInfoSet=========, %s   %s", (Object[])new Object[]{freshSet, AudienceManagerInternal.TAG_SUFFIX});
            AudienceManagerInternal.this.notifyAddLiveInfoSet(freshSet);
        }

        public void didRemoveLiveInfoSet(Set<LiveInfo> staleSet) {
            MLog.info((Object)AudienceManagerInternal.TAG, (String)"=========didRemoveLiveInfoSet=========, %s  %s", (Object[])new Object[]{staleSet, AudienceManagerInternal.TAG_SUFFIX});
            AudienceManagerInternal.this.notifyRemoveLiveInfoSet(staleSet);
        }

        public void didUpdateLiveInfoSet(Set<LiveInfo> fromSet, Set<LiveInfo> toSet) {
            MLog.info((Object)AudienceManagerInternal.TAG, (String)("=========didUpdateLiveInfoSet=========: fromSet = [" + fromSet + "], toSet = [" + toSet + "] %s"), (Object[])new Object[]{AudienceManagerInternal.TAG_SUFFIX});
            AudienceManagerInternal.this.notifyUpdateLiveInfoSet(fromSet, toSet);
        }

        public void didAddGroupInfoSet(Set<GroupInfo> freshSet) {
            MLog.info((Object)AudienceManagerInternal.TAG, (String)"=========didAddGroupInfoSet=========, %s %s", (Object[])new Object[]{freshSet, AudienceManagerInternal.TAG_SUFFIX});
            GroupInfoEntranceImpl.getInstance().addGroupInfoSet(freshSet);
        }

        public void didRemoveGroupInfoSet(Set<GroupInfo> staleSet) {
            MLog.info((Object)AudienceManagerInternal.TAG, (String)"=========didRemoveGroupInfoSet=========, %s %s", (Object[])new Object[]{staleSet, AudienceManagerInternal.TAG_SUFFIX});
            GroupInfoEntranceImpl.getInstance().removeGroupInfoSet(staleSet);
        }

        public void onAudioLinkInfoNotify(MediaVideoMsg.MediaLinkInfo audioLinkInfo) {
            MLog.info((Object)AudienceManagerInternal.TAG, (String)("onAudioLinkInfoNotity called with: audioLinkInfo = [" + audioLinkInfo + "]"), (Object[])new Object[0]);
            if (audioLinkInfo != null) {
                RxBus.getDefault().post((Object)new MediaLinkInfoEventArgs(audioLinkInfo.state, audioLinkInfo.ip, audioLinkInfo.port));
            }
        }

        public void onVideoViewerLossNotifyInfo(MediaVideoMsg.VideoViewLossNotifyInfo videoViewLossNotifyInfo) {
            MLog.info((Object)AudienceManagerInternal.TAG, (String)("onVideoViewerLossNotifyInfo called with: videoViewLossNotifyInfo = [" + videoViewLossNotifyInfo + "]"), (Object[])new Object[0]);
            VideoViewLossNotifyInfoEventArgs args = new VideoViewLossNotifyInfoEventArgs(videoViewLossNotifyInfo.uid, videoViewLossNotifyInfo.statMap);
            RxBus.getDefault().post((Object)args);
        }

        public void onFirstFrameSeeNotify(MediaVideoMsg.FirstFrameSeeInfo firstFrameSeeInfo) {
            MLog.info((Object)AudienceManagerInternal.TAG, (String)("onFirstFrameSeeNotify called with: firstFrameSeeInfo = [" + firstFrameSeeInfo + "]"), (Object[])new Object[0]);
        }

        public void onNoLiveInfoNotify() {
            MLog.info((Object)AudienceManagerInternal.TAG, (String)"onNoLiveInfoNotify called", (Object[])new Object[0]);
            NoLiveManager.getInstance().onNoLiveInfoSetNotify();
        }

        public void onAudioRenderVolume(MediaVideoMsg.AudioRenderVolumeInfo audioRenderVolumeInfo) {
            long currentTime = System.currentTimeMillis();
            if (AudienceManagerInternal.this.mLastUid == audioRenderVolumeInfo.uid && currentTime - AudienceManagerInternal.this.mLastTime < 500L) {
                return;
            }
            AudienceManagerInternal.this.mLastUid = audioRenderVolumeInfo.uid;
            AudienceManagerInternal.this.mLastTime = currentTime;
            AudioRenderVolumeInfoEventArgs volumeInfoEventArgs = new AudioRenderVolumeInfoEventArgs(audioRenderVolumeInfo.uid, audioRenderVolumeInfo.volume);
            RxBus.getDefault().post((Object)volumeInfoEventArgs);
        }

        public void onTransConfigNotify(Set<com.yy.yylivekit.model.TransConfig> transConfigs) {
            if (FP.empty(transConfigs)) {
                MLog.info((Object)AudienceManagerInternal.TAG, (String)"onTransConfigNotify: empty transConfigs", (Object[])new Object[0]);
                return;
            }
            HashSet<TransConfig> transConfigSet = new HashSet<TransConfig>();
            for (com.yy.yylivekit.model.TransConfig transConfig : transConfigs) {
                TransConfig config = new TransConfig(transConfig);
                transConfigSet.add(config);
            }
            AnchorTransConfigHolder.getInstance().updateTransConfig(transConfigSet);
        }

        public void onAudioStreamStatusInfo(MediaVideoMsg.LiveAudioStreamStatusInfo info) {
            AudioStreamStatusProxy.getInstance().acceptOriginData(info);
            AudioSpeakersManagerImpl.getInstance().acceptSpeakerData(info);
        }

        public void onChannelAudioStateNotify(MediaVideoMsg.ChannelAudioStateInfo info) {
            RxBus.getDefault().post((Object)new ChannelAudioStateInfoEventArgs(info.sid, info.subSid, info.state));
        }
    };

    public void init() {
        this.mAudience = Audience.instance();
        this.mAudience.addEventHandler(this.mAudienceEventHandler);
        LivePlayerFactory.getInstance().init();
        VideoStreamCompatImpl.getInstance().init();
        RadioPlayerManagerImpl.getInstance().init();
    }

    public void release() {
        this.mAudience.removeEventHandler(this.mAudienceEventHandler);
    }

    public void cancelFastAccess() {
        MLog.info((Object)TAG, (String)"cancelFastAccess called", (Object[])new Object[0]);
        Audience.instance().cancelEnableFastAccess();
    }

    public void setEnableVideoFastAccess(boolean enableVideoFastAccess) {
        MLog.info((Object)TAG, (String)("setEnableVideoFastAccess called with: enableVideoFastAccess = [" + enableVideoFastAccess + "]"), (Object[])new Object[0]);
    }

    public void setEnableVideoLowLatency(boolean enableVideoLowLatency) {
        MLog.info((Object)TAG, (String)("setEnableVideoLowLatency called with: enableVideoLowLatency = [" + enableVideoLowLatency + "]"), (Object[])new Object[0]);
        Audience.instance().enableLowLatency(enableVideoLowLatency);
    }

    public Audience getAudience() {
        return this.mAudience;
    }

    private void notifyAddLiveInfoSet(Set<LiveInfo> addedSet) {
        LiveInfoEntranceImpl.getInstance().addLiveInfoSet(addedSet);
    }

    private void notifyRemoveLiveInfoSet(Set<LiveInfo> removedSet) {
        LiveInfoEntranceImpl.getInstance().removeLiveInfoSet(removedSet);
    }

    private void notifyUpdateLiveInfoSet(Set<LiveInfo> fromSet, Set<LiveInfo> toSet) {
        LiveInfoEntranceImpl.getInstance().updateLiveInfoSet(fromSet, toSet);
    }

    public static AudienceManagerInternal getInstance() {
        return Holder.INSTANCE;
    }

    private AudienceManagerInternal() {
    }

    private static class Holder {
        private static final AudienceManagerInternal INSTANCE = new AudienceManagerInternal();

        private Holder() {
        }
    }
}

