/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.sdkwrapper.flowmanagement.base.entity;

import com.yy.mobile.util.FP;
import com.yy.mobile.util.log.MLog;
import com.yy.yylivekit.model.VideoGearInfo;
import java.util.ArrayList;
import java.util.List;

public class AudienceVideoQuality {
    private static final String TAG = "AudienceVideoQuality";
    public static final AudienceVideoQuality DEFAULT_STANDARD = new AudienceVideoQuality(1, "\u6807\u6e05", true);
    public static final AudienceVideoQuality DEFAULT_HD = new AudienceVideoQuality(2, "\u9ad8\u6e05", true);
    public static final AudienceVideoQuality DEFAULT_SUPER = new AudienceVideoQuality(3, "\u8d85\u6e05", true);
    public static final AudienceVideoQuality DEFAULT_BLUE_RAY = new AudienceVideoQuality(4, "\u84dd\u5149", true);
    private int value;
    private String name;
    private int sequence;
    private int codeRate;
    private boolean isMock = false;

    public static AudienceVideoQuality from(VideoGearInfo gearInfo) {
        return new AudienceVideoQuality(gearInfo.gear, gearInfo.name, gearInfo.seq, gearInfo.codeRate);
    }

    public static List<AudienceVideoQuality> fromList(List<VideoGearInfo> gearInfoList) {
        ArrayList<AudienceVideoQuality> list = new ArrayList<AudienceVideoQuality>();
        for (VideoGearInfo gearInfo : gearInfoList) {
            list.add(AudienceVideoQuality.from(gearInfo));
        }
        return list;
    }

    public VideoGearInfo toGearInfo() {
        return new VideoGearInfo(this.value, this.name, this.sequence, this.codeRate);
    }

    public AudienceVideoQuality(int value, String name, int sequence, int codeRate) {
        this.value = value;
        this.name = name;
        this.sequence = sequence;
        this.codeRate = codeRate;
    }

    public AudienceVideoQuality(int value, String name, boolean isMock) {
        this.value = value;
        this.name = name;
        this.isMock = isMock;
    }

    public int getValue() {
        return this.value;
    }

    public void setValue(int value) {
        this.value = value;
    }

    public String getName() {
        if (FP.size((CharSequence)this.name) > 2) {
            MLog.warn((Object)TAG, (String)"video quality name is longer than 2 chars: %s", (Object[])new Object[]{this.name});
            this.name = this.name.substring(0, 2);
        }
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getSequence() {
        return this.sequence;
    }

    public void setSequence(int sequence) {
        this.sequence = sequence;
    }

    public int getCodeRate() {
        return this.codeRate;
    }

    public void setCodeRate(int codeRate) {
        this.codeRate = codeRate;
    }

    public boolean isMock() {
        return this.isMock;
    }

    public void setMock(boolean mock) {
        this.isMock = mock;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        AudienceVideoQuality that = (AudienceVideoQuality)o;
        return this.value == that.value;
    }

    public int hashCode() {
        return this.value;
    }

    public String toString() {
        return "AudienceVideoQuality{value=" + this.value + ", name='" + this.name + '\'' + ", sequence=" + this.sequence + ", codeRate=" + this.codeRate + ", isMock=" + this.isMock + '}';
    }
}

