/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.sdkwrapper.flowmanagement.base.audience.videostatus;

import com.yy.mobile.sdkwrapper.flowmanagement.base.audience.videostatus.IVideoStatusEventHandler;
import com.yy.mobile.sdkwrapper.flowmanagement.base.audience.videostatus.IVideoStatusListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class VideoStatusEventHandlerImpl
implements IVideoStatusEventHandler {
    private static final String TAG = "VideoStatusEventHandlerImpl";
    private List<IVideoStatusListener> statusListeners = new CopyOnWriteArrayList<IVideoStatusListener>();

    @Override
    public void addVideoStatusListener(IVideoStatusListener videoStatusListener) {
        if (this.statusListeners != null && !this.statusListeners.contains(videoStatusListener)) {
            this.statusListeners.add(videoStatusListener);
        }
    }

    @Override
    public void removeVideoStatusListener(IVideoStatusListener videoStatusListener) {
        if (this.statusListeners != null && this.statusListeners.contains(videoStatusListener)) {
            this.statusListeners.remove(videoStatusListener);
        }
    }

    public void notifyVideoStatusChange(boolean hasVideo) {
        if (this.statusListeners != null && this.statusListeners.size() > 0) {
            for (IVideoStatusListener listener : this.statusListeners) {
                listener.onVideoStatusChange(hasVideo);
            }
        }
    }

    private VideoStatusEventHandlerImpl() {
    }

    public static VideoStatusEventHandlerImpl getInstance() {
        return Holder.INSTANCE;
    }

    private static class Holder {
        private static VideoStatusEventHandlerImpl INSTANCE = new VideoStatusEventHandlerImpl();

        private Holder() {
        }
    }
}

