/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.sdkwrapper.flowmanagement.base.audience.playstatus;

import com.duowan.mobile.utils.FP;
import com.yy.mobile.RxBus;
import com.yy.mobile.sdkwrapper.flowmanagement.api.audience.liveinfo.LiveInfoChangeEventHandler;
import com.yy.mobile.sdkwrapper.flowmanagement.base.audience.liveinfo.SimpleLiveInfoChangeListener;
import com.yy.mobile.sdkwrapper.flowmanagement.base.audience.playstatus.IVideoPlayStatusEventHandler;
import com.yy.mobile.sdkwrapper.flowmanagement.base.audience.playstatus.VideoPlayStatus;
import com.yy.mobile.sdkwrapper.flowmanagement.base.audience.playstatus.VideoPlayStatusListener;
import com.yy.mobile.sdkwrapper.flowmanagement.base.entity.VideoPlayInfo;
import com.yy.mobile.sdkwrapper.flowmanagement.event.audience.playstatus.AudienceVideoPlayStatusEvent;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.liveinfo.LiveInfoUtils;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.playstatus.VideoPlayInfoListHolder;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.sampling.AudienceVideoStatisticsManager;
import com.yy.mobile.util.exception.ExceptionUtil;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.optional.Optional;
import com.yy.yylivekit.ILivePlayer;
import com.yy.yylivekit.audience.LivePlayer;
import com.yy.yylivekit.model.BuzInfo;
import com.yy.yylivekit.model.LiveInfo;
import com.yy.yylivekit.model.MixVideoLayout;
import com.yy.yylivekit.model.StreamInfo;
import com.yy.yylivekit.model.VideoInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public class VideoPlayStatusEventHandlerImpl
implements IVideoPlayStatusEventHandler {
    private static final String TAG = "VideoPlayStatusEventHandlerImpl";
    private List<VideoPlayStatusListener> mVideoPlayStatusListeners = new ArrayList<VideoPlayStatusListener>();
    private Map<Long, VideoPlayStatus> mUidPlayStatusMap = new ConcurrentHashMap<Long, VideoPlayStatus>();
    private Map<Long, Long> mUidStreamIdMap = new HashMap<Long, Long>();

    public static VideoPlayStatusEventHandlerImpl getInstance() {
        return Holder.INSTANCE;
    }

    @Override
    public void addVideoPlayStatusListener(VideoPlayStatusListener listener) {
        MLog.info((Object)TAG, (String)"addVideoPlayStatusListener called with: listener = %s", (Object[])new Object[]{listener});
        this.innerAddListener(-1, listener);
    }

    @Override
    public void addVideoPlayStatusListenerToHead(VideoPlayStatusListener listener) {
        MLog.info((Object)TAG, (String)"addVideoPlayStatusListenerToHead called with: listener = %s", (Object[])new Object[]{listener});
        this.innerAddListener(0, listener);
    }

    private void innerAddListener(int index, VideoPlayStatusListener listener) {
        if (listener == null || this.mVideoPlayStatusListeners.contains(listener)) {
            return;
        }
        if (index >= 0) {
            this.mVideoPlayStatusListeners.add(index, listener);
        } else {
            this.mVideoPlayStatusListeners.add(listener);
        }
        int listenerSize = FP.size(this.mVideoPlayStatusListeners);
        MLog.info((Object)TAG, (String)"innerAddListener called with: index = [%d], listener = [%s], listenerSize: %d", (Object[])new Object[]{index, listener, listenerSize});
    }

    @Override
    public void removeVideoPlayStatusListener(VideoPlayStatusListener listener) {
        this.mVideoPlayStatusListeners.remove(listener);
        int listenerSize = FP.size(this.mVideoPlayStatusListeners);
        MLog.info((Object)TAG, (String)("removeVideoPlayStatusListener called with: listener = [" + listener + "], size: %d"), (Object[])new Object[]{listenerSize});
    }

    @Override
    public VideoPlayStatus getVideoPlayStatus(long uid) {
        VideoPlayStatus statusObj = this.mUidPlayStatusMap.get(uid);
        MLog.info((Object)TAG, (String)("getVideoPlayStatus called with: uid = [" + uid + "], status: %s"), (Object[])new Object[]{statusObj});
        return statusObj == null ? VideoPlayStatus.STOP : statusObj;
    }

    @Override
    public boolean isAllVideoStop() {
        Set<Map.Entry<Long, VideoPlayStatus>> set = this.mUidPlayStatusMap.entrySet();
        for (Map.Entry<Long, VideoPlayStatus> entry : set) {
            if (entry.getValue() == VideoPlayStatus.STOP) continue;
            MLog.info((Object)TAG, (String)"isAllVideoStop called, not all video stopped, uid %d is %s", (Object[])new Object[]{entry.getKey(), entry.getValue()});
            return false;
        }
        MLog.info((Object)TAG, (String)"isAllVideoStop called, all video stopped", (Object[])new Object[0]);
        return true;
    }

    public void clearPlayStatusMap() {
        MLog.info((Object)TAG, (String)"clearPlayStatusMap called", (Object[])new Object[0]);
        try {
            this.mUidPlayStatusMap.clear();
            this.mUidStreamIdMap.clear();
        }
        catch (Exception e) {
            MLog.error((Object)TAG, (String)"clearPlayStatusMap: ", (Throwable)e, (Object[])new Object[0]);
        }
    }

    public void notifyPlayStatusChanged(ILivePlayer player, LiveInfo liveInfo, StreamInfo streamInfo, VideoPlayStatus playStatus) {
        List<VideoPlayInfo> playInfos = this.liveInfoToPlayInfos(player, liveInfo, streamInfo);
        VideoPlayInfoListHolder.getInstance().updatePlayInfo(playStatus, playInfos);
        this.updatePlaySamplingData(playInfos, playStatus);
        if (FP.empty(playInfos)) {
            MLog.error((Object)TAG, (String)("[Bug]notifyPlayStatusChanged called with empty playInfos: liveInfo = [" + liveInfo + "], streamInfo = [" + streamInfo + "], playStatus = [" + (Object)((Object)playStatus) + "]"), (Object[])new Object[0]);
        }
        for (VideoPlayInfo playInfo : playInfos) {
            this.notifyPlayStatusChanged(playInfo, playStatus);
            try {
                if (playStatus != VideoPlayStatus.STOP) continue;
                this.mUidStreamIdMap.remove(playInfo.uid);
            }
            catch (Throwable throwable) {
                MLog.error((Object)TAG, (String)"notifyPlayStatusChanged: ", (Throwable)throwable, (Object[])new Object[0]);
            }
        }
    }

    private void updatePlaySamplingData(List<VideoPlayInfo> playInfos, VideoPlayStatus playStatus) {
        AudienceVideoStatisticsManager.getInstance().updatePlayStatistics(playInfos, playStatus);
    }

    private void notifyPlayStatusChanged(VideoPlayInfo playInfo, VideoPlayStatus playStatus) {
        MLog.info((Object)TAG, (String)("notifyPlayStatusChanged called with: playStatus = [" + (Object)((Object)playStatus) + "], playInfo = [" + playInfo + "]"), (Object[])new Object[0]);
        if ((playInfo.micPos < 0 || playInfo.uid <= 0L) && playInfo.uid == 0L) {
            playInfo.uid = -1L;
        }
        this.updatePlayStatusMap(playInfo.uid, playStatus);
        if (!FP.empty(this.mVideoPlayStatusListeners)) {
            ArrayList<VideoPlayStatusListener> list = new ArrayList<VideoPlayStatusListener>(this.mVideoPlayStatusListeners);
            for (VideoPlayStatusListener listener : list) {
                if (listener == null) {
                    ExceptionUtil.throwOrWriteLog(TAG, "notifyPlayStatusChanged, listener is null, listeners: %s", this.mVideoPlayStatusListeners);
                    continue;
                }
                listener.onPlayStatusChanged(playInfo, playStatus);
            }
        }
        RxBus.getDefault().post((Object)new AudienceVideoPlayStatusEvent(playInfo, playStatus));
    }

    private List<VideoPlayInfo> liveInfoToPlayInfos(ILivePlayer player, LiveInfo liveInfo, StreamInfo streamInfo) {
        long streamId;
        ArrayList<VideoPlayInfo> playInfos = new ArrayList<VideoPlayInfo>();
        long l = streamId = player instanceof LivePlayer ? ((LivePlayer)player).getStreamId() : -1L;
        if (liveInfo.isMix) {
            VideoInfo videoInfo;
            VideoInfo videoInfo2 = videoInfo = streamInfo != null ? streamInfo.video : null;
            if (videoInfo != null && videoInfo.mixLayout != null && !FP.empty((Collection)videoInfo.mixLayout.params)) {
                for (MixVideoLayout.Params param : videoInfo.mixLayout.params) {
                    BuzInfo buzInfo = videoInfo.buzInfo;
                    int videoIndex = buzInfo == null ? -1 : buzInfo.seat;
                    HashMap<String, String> bizInfoMap = buzInfo == null ? new HashMap<String, String>() : new HashMap(buzInfo.extend);
                    long uid = param.uid;
                    streamId = this.updateStreamId(uid, streamId);
                    VideoPlayInfo playInfo = new VideoPlayInfo(videoInfo.appId, uid, true, param.mic, videoIndex, param.w, param.h, streamId, videoInfo.codeRate, videoInfo.fps, bizInfoMap);
                    playInfos.add(playInfo);
                }
            } else {
                MLog.error((Object)TAG, (String)"[Bug]liveInfoToPlayInfos, invalid stream info, liveInfo: %s, streamInfo: %s", (Object[])new Object[]{liveInfo, streamInfo});
            }
        } else {
            int videoIndex = -1;
            VideoInfo videoInfo = streamInfo != null ? streamInfo.video : null;
            int width = videoInfo != null ? videoInfo.width : -1;
            int height = videoInfo != null ? videoInfo.height : -1;
            int appId2 = videoInfo != null ? videoInfo.appId : -1;
            int codeRate = videoInfo != null ? videoInfo.codeRate : -1;
            int frameRate = videoInfo != null ? videoInfo.fps : -1;
            HashMap<String, String> bizInfoMap = new HashMap<String, String>();
            if (videoInfo != null && videoInfo.buzInfo != null) {
                videoIndex = streamInfo.video.buzInfo.seat;
                bizInfoMap.putAll(videoInfo.buzInfo.extend);
            }
            long uid = liveInfo.uid;
            streamId = this.updateStreamId(uid, streamId);
            VideoPlayInfo videoPlayInfo = new VideoPlayInfo(appId2, uid, false, liveInfo.micNo, videoIndex, width, height, streamId, codeRate, frameRate, bizInfoMap);
            playInfos.add(videoPlayInfo);
        }
        return playInfos;
    }

    private long updateStreamId(long uid, long streamId) {
        if (streamId <= 0L) {
            return (Long)Optional.of((Object)this.mUidStreamIdMap.get(uid)).orElse((Object)-1L);
        }
        this.mUidStreamIdMap.put(uid, streamId);
        return streamId;
    }

    private void handleMixLayoutLiveInfoUpdate(List<LiveInfo> fromLiveInfos, List<LiveInfo> toLiveInfos) {
        MLog.info((Object)TAG, (String)("handleMixLayoutLiveInfoUpdate called with: mUidPlayStatusMap: %s, fromLiveInfos = [" + fromLiveInfos + "], toLiveInfos = [" + toLiveInfos + "]"), (Object[])new Object[]{this.mUidPlayStatusMap});
        if (FP.empty(toLiveInfos)) {
            return;
        }
        LiveInfo liveInfo = toLiveInfos.get(0);
        boolean isMix = liveInfo.isMix;
        if (!isMix) {
            return;
        }
        List<VideoPlayInfo> playInfos = LiveInfoUtils.getVideoPlayInfos(toLiveInfos);
        List<VideoPlayInfo> oldPlayInfos = LiveInfoUtils.getVideoPlayInfos(fromLiveInfos);
        boolean hasUidPlaying = false;
        for (Map.Entry<Long, VideoPlayStatus> entry : this.mUidPlayStatusMap.entrySet()) {
            VideoPlayInfo oldPlayInfo;
            Long uid = entry.getKey();
            VideoPlayStatus playStatus = entry.getValue();
            int oldIndex = oldPlayInfos.indexOf(new VideoPlayInfo(uid));
            VideoPlayInfo videoPlayInfo = oldPlayInfo = oldIndex != -1 ? oldPlayInfos.get(oldIndex) : null;
            if (oldPlayInfo != null && !playInfos.contains(oldPlayInfo) && playStatus != VideoPlayStatus.STOP) {
                MLog.info((Object)TAG, (String)"handleMixLayoutLiveInfoUpdate, ====notify play stop, playInfo: %s, prePlayStatus: %s", (Object[])new Object[]{oldPlayInfo, playStatus});
                this.notifyPlayStatusChanged(oldPlayInfo, VideoPlayStatus.STOP);
                continue;
            }
            if (playStatus != VideoPlayStatus.PLAYING) continue;
            hasUidPlaying = true;
        }
        if (hasUidPlaying) {
            for (VideoPlayInfo playInfo : playInfos) {
                long uid = playInfo.uid;
                VideoPlayStatus playStatus = this.mUidPlayStatusMap.get(uid);
                if (playStatus == VideoPlayStatus.PLAYING) continue;
                MLog.info((Object)TAG, (String)"handleMixLayoutLiveInfoUpdate, ====notify playing, playInfo: %s, prePlayStatus: %s:", (Object[])new Object[]{playInfo, playStatus});
                this.notifyPlayStatusChanged(playInfo, VideoPlayStatus.PLAYING);
            }
        }
    }

    private void updatePlayStatusMap(long uid, VideoPlayStatus status) {
        MLog.info((Object)TAG, (String)("updatePlayStatusMap called with: uids = [" + uid + "], status = [" + (Object)((Object)status) + "]"), (Object[])new Object[0]);
        this.mUidPlayStatusMap.put(uid, status);
    }

    private VideoPlayStatusEventHandlerImpl() {
        LiveInfoChangeEventHandler.getInstance().addLiveInfoChangeListener(new SimpleLiveInfoChangeListener(){

            @Override
            public void onUpdateLiveInfos(List<LiveInfo> fromLiveInfos, List<LiveInfo> toLiveInfos) {
                VideoPlayStatusEventHandlerImpl.this.handleMixLayoutLiveInfoUpdate(fromLiveInfos, toLiveInfos);
            }
        });
    }

    private static class Holder {
        private static final VideoPlayStatusEventHandlerImpl INSTANCE = new VideoPlayStatusEventHandlerImpl();

        private Holder() {
        }
    }
}

