/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.sdkwrapper.flowmanagement.base.audience.groupinfo;

import com.yy.mobile.sdkwrapper.flowmanagement.base.audience.groupinfo.IGroupInfoChangeListener;
import com.yy.yylivekit.model.GroupInfo;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class GroupInfoChangeEventHandler {
    private static final String TAG = "GroupInfoChangeEventHandler";
    private List<IGroupInfoChangeListener> listeners = new CopyOnWriteArrayList<IGroupInfoChangeListener>();

    public void addGroupInfoChangeListener(IGroupInfoChangeListener groupInfoChangeListener) {
        if (this.listeners != null && !this.listeners.contains(groupInfoChangeListener)) {
            this.listeners.add(groupInfoChangeListener);
        }
    }

    public void removeGroupInfoChangeListener(IGroupInfoChangeListener groupInfoChangeListener) {
        if (this.listeners != null) {
            this.listeners.remove(groupInfoChangeListener);
        }
    }

    public void notifyAddGroupInfos(List<GroupInfo> listToAdd, List<GroupInfo> finalGroupInfos) {
        if (this.listeners != null) {
            for (IGroupInfoChangeListener listener : this.listeners) {
                listener.onAddGroupInfoList(listToAdd, finalGroupInfos);
            }
        }
    }

    public void notifyRemoveGroupInfos(List<GroupInfo> listToRemove, List<GroupInfo> finalGroupInfos) {
        if (this.listeners != null) {
            for (IGroupInfoChangeListener listener : this.listeners) {
                listener.onRemoveGroupInfoList(listToRemove, finalGroupInfos);
            }
        }
    }

    private GroupInfoChangeEventHandler() {
    }

    public static GroupInfoChangeEventHandler getInstance() {
        return Holder.INSTANCE;
    }

    private static class Holder {
        private static GroupInfoChangeEventHandler INSTANCE = new GroupInfoChangeEventHandler();

        private Holder() {
        }
    }
}

