/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.sdkwrapper.flowmanagement.api.line;

import com.yy.mobile.sdkwrapper.flowmanagement.api.line.StreamLineBrokenListener;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class StreamLineManager {
    private static final String TAG = "StreamLineManager";
    private List<StreamLineBrokenListener> mListeners = new CopyOnWriteArrayList<StreamLineBrokenListener>();

    private StreamLineManager() {
    }

    public static StreamLineManager getInstance() {
        return Holder.INSTANCE;
    }

    public void addLineBrokenListener(StreamLineBrokenListener listener) {
        if (this.mListeners != null && !this.mListeners.contains(listener)) {
            this.mListeners.add(listener);
        }
    }

    public void removeLineBrokenListener(StreamLineBrokenListener listener) {
        if (this.mListeners != null && this.mListeners.contains(listener)) {
            this.mListeners.remove(listener);
        }
    }

    public void notifyStreamLineBroken(int brokenLine) {
        if (this.mListeners != null && this.mListeners.size() > 0) {
            for (StreamLineBrokenListener listener : this.mListeners) {
                listener.onCurrentLineBroken(brokenLine);
            }
        }
    }

    private static class Holder {
        private static StreamLineManager INSTANCE = new StreamLineManager();

        private Holder() {
        }
    }
}

