/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.sdkwrapper.flowmanagement.api.channel;

import android.os.Looper;
import android.os.SystemClock;
import android.util.Printer;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.util.log.MLog;

public class MessageLog {
    private static final String TAG = "MessageLog";
    private boolean started;
    private double thresholdMillis;
    Printer printer = new Printer(){
        long begin;

        public void println(String x) {
            MLog.info((Object)MessageLog.TAG, (String)x, (Object[])new Object[0]);
            if (x.contains(">")) {
                MessageLog.this.started = true;
                this.begin = SystemClock.uptimeMillis();
            } else if (MessageLog.this.started) {
                long runtime = SystemClock.uptimeMillis() - this.begin;
                if ((double)runtime > MessageLog.this.thresholdMillis) {
                    MLog.warn((Object)MessageLog.TAG, (String)"Message ran Long time=%d , %s", (Object[])new Object[]{runtime, x});
                }
                MessageLog.this.started = false;
            }
        }
    };

    private MessageLog() {
    }

    public void start(long thresholdMillis) {
        if (BasicConfig.getInstance().isDebuggable()) {
            this.thresholdMillis = thresholdMillis;
            Looper.getMainLooper().setMessageLogging(this.printer);
        }
    }

    public void stop() {
        this.started = false;
        Looper.getMainLooper().setMessageLogging(null);
    }

    public static MessageLog getInstance() {
        return Holder.INSTANCE;
    }

    private static class Holder {
        private static final MessageLog INSTANCE = new MessageLog();

        private Holder() {
        }
    }
}

