/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.sdkwrapper.flowmanagement.api.channel;

import com.yy.mobile.sdkwrapper.flowmanagement.api.audience.videoenable.AudienceVideoEnableManager;
import com.yy.mobile.sdkwrapper.flowmanagement.base.audience.playstatus.VideoPlayStatusEventHandlerImpl;
import com.yy.mobile.sdkwrapper.flowmanagement.base.channel.FlowChannelState;
import com.yy.mobile.sdkwrapper.flowmanagement.base.channel.FlowChannelStatusObservable;
import com.yy.mobile.sdkwrapper.flowmanagement.base.entity.FlowChannelInfo;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.groupinfo.AudioStreamStatusProxy;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.groupinfo.GroupInfoEntranceImpl;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.liveinfo.LiveInfoEntranceImpl;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.nolive.NoLiveManager;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.player.LivePlayerFactory;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.player.LivePlayerManagerImpl;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.playstatus.VideoPlayInfoListHolder;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.radioplayer.RadioPlayerManagerImpl;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.sampling.AudienceVideoStatisticsManager;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.sampling.ChannelLiveInfoStatisticsManager;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.videoquality.AudienceVideoQualityManagerImpl;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audio.AudioManagerImpl;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audio.AudioSpeakersManagerImpl;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.common.YLKLiveHolder;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.streamcompat.VideoStreamChangedCompatImpl;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.videoinfo.VideoDebugInfoManagerImpl;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.videolayout.videosize.AudienceVideoSizeChangeEventHandlerImpl;
import com.yy.mobile.util.log.MLog;
import com.yy.yylivekit.YLKLive;
import com.yy.yylivekit.model.Channel;
import com.yy.yylivekit.model.LiveEventHandler;
import com.yyproto.utils.FP;

public class LiveKitChannelManager {
    private static final String TAG = "LiveKitChannelManager";
    private YLKLive mLive = YLKLiveHolder.getYLKLive();
    private boolean mHasCalledJoin;
    private FlowChannelInfo mFlowChannelInfo;
    private String mVideoStreamJson;

    public void join(FlowChannelInfo channelInfo) {
        MLog.info((Object)TAG, (String)("join called with: channelInfo = [" + channelInfo + "]"), (Object[])new Object[0]);
        this.innerJoin(channelInfo, null, true);
    }

    public void joinWithVideoStream(FlowChannelInfo channelInfo, String videoStreamJson) {
        MLog.info((Object)TAG, (String)("joinWithVideoStream called with: channelInfo = [" + channelInfo + "], videoStreamJson = [" + videoStreamJson + "]"), (Object[])new Object[0]);
        this.innerJoin(channelInfo, videoStreamJson, true);
    }

    public void joinWithVideoStream(FlowChannelInfo channelInfo, String videoStreamJson, boolean needAudio) {
        MLog.info((Object)TAG, (String)("joinWithVideoStream called with: channelInfo = [" + channelInfo + "], videoStreamJson = [" + videoStreamJson + "], needAudio = [" + needAudio + "]"), (Object[])new Object[0]);
        this.innerJoin(channelInfo, videoStreamJson, needAudio);
    }

    private void innerJoin(FlowChannelInfo channelInfo, String videoStreamJson, boolean needAudio) {
        MLog.info((Object)TAG, (String)("innerJoin called with: channelInfo = [" + channelInfo + "], videoStreamJson = [" + videoStreamJson + "], needAudio = [" + needAudio + "]"), (Object[])new Object[0]);
        if (channelInfo == null) {
            MLog.error((Object)TAG, (String)"innerJoin: null channelInfo", (Object[])new Object[0]);
            return;
        }
        if (FP.eq((Object)channelInfo, (Object)this.mFlowChannelInfo)) {
            MLog.info((Object)TAG, (String)("live kit duplicate join channel, return = [" + channelInfo + "]"), (Object[])new Object[0]);
            AudioManagerImpl.getInstance().setNeedToSubscribeAudio(needAudio);
            return;
        }
        if (this.mFlowChannelInfo != null) {
            MLog.info((Object)TAG, (String)"live kit join channel with diff channel info, leave old channel: old: %s, new: %s", (Object[])new Object[]{this.mFlowChannelInfo, channelInfo});
            this.leave();
        }
        AudioManagerImpl.getInstance().setNeedToSubscribeAudio(needAudio);
        this.setVideoStream(videoStreamJson);
        this.setChannelInfo(channelInfo);
        long topSid = channelInfo.getTopSid();
        long subSid = channelInfo.getSubSid();
        long uid = channelInfo.getUid();
        String paramsStr = "uid = [" + uid + "], topSid = [" + topSid + "], subSid = [" + subSid + "], videoStreamJson: " + videoStreamJson;
        MLog.info((Object)TAG, (String)("live kit join called with: " + paramsStr), (Object[])new Object[0]);
        if (subSid <= 0L) {
            MLog.error((Object)TAG, (String)"invalid channel info, return. info: %s", (Object[])new Object[]{paramsStr});
            return;
        }
        MLog.info((Object)TAG, (String)"======YLKJoin=====, uid: %d, info: %s", (Object[])new Object[]{uid, paramsStr});
        ChannelLiveInfoStatisticsManager.getInstance().onJoinChannel(channelInfo);
        FlowChannelStatusObservable.getInstance().updateState(FlowChannelState.JOINING);
        if (videoStreamJson == null) {
            this.mLive.join(uid, topSid, subSid);
        } else {
            this.mLive.join(uid, topSid, subSid, videoStreamJson);
        }
        VideoStreamChangedCompatImpl.getInstance().init();
        LivePlayerManagerImpl.getInstance().init();
        RadioPlayerManagerImpl.getInstance().play();
        AudioManagerImpl.getInstance().init();
        this.updateHasCalledJion(true);
        NoLiveManager.getInstance().init();
        AudienceVideoSizeChangeEventHandlerImpl.getInstance().init();
    }

    public void leave() {
        if (!this.mHasCalledJoin) {
            MLog.warn((Object)TAG, (String)"did not call join before call leave, do nothing", (Object[])new Object[0]);
            return;
        }
        ChannelLiveInfoStatisticsManager.getInstance().onLeaveChannel();
        MLog.info((Object)TAG, (String)"====YLKLeave====\uff0c channelInfo: %s", (Object[])new Object[]{this.mFlowChannelInfo});
        this.setVideoStream(null);
        this.setChannelInfo(null);
        LiveInfoEntranceImpl.getInstance().removeAllLiveInfoSet();
        this.mLive.leave();
        this.updateHasCalledJion(false);
        VideoPlayStatusEventHandlerImpl.getInstance().clearPlayStatusMap();
        LivePlayerManagerImpl.getInstance().release();
        LivePlayerFactory.getInstance().releaseLivePlayers();
        GroupInfoEntranceImpl.getInstance().clearGroupInfoData();
        RadioPlayerManagerImpl.getInstance().releaseRadioPlayer();
        AudienceVideoEnableManager.getInstance().reset();
        NoLiveManager.getInstance().reset();
        AudioManagerImpl.getInstance().release();
        VideoDebugInfoManagerImpl.getInstance().reset();
        AudienceVideoQualityManagerImpl.getInstance().release();
        AudienceVideoStatisticsManager.getInstance().reset();
        VideoStreamChangedCompatImpl.getInstance().reset();
        VideoPlayInfoListHolder.getInstance().reset();
        AudioStreamStatusProxy.getInstance().release();
        AudioSpeakersManagerImpl.getInstance().release();
    }

    public FlowChannelInfo getChannelInfo() {
        return this.mFlowChannelInfo;
    }

    private void setChannelInfo(FlowChannelInfo flowChannelInfo) {
        MLog.info((Object)TAG, (String)("setChannelInfo called with: flowChannelInfo = [" + flowChannelInfo + "]"), (Object[])new Object[0]);
        this.mFlowChannelInfo = flowChannelInfo;
    }

    private void initLiveKit() {
        this.mLive.addEventHandler(new LiveEventHandler(){

            public void onJoinSuccess(Channel channel) {
                MLog.info((Object)LiveKitChannelManager.TAG, (String)"live kit join success, info: %s", (Object[])new Object[]{channel});
                FlowChannelStatusObservable.getInstance().updateState(FlowChannelState.JOIN_SUCCESS);
            }

            public void onJoinFailed(int statusCode, String message) {
                MLog.error((Object)LiveKitChannelManager.TAG, (String)"live kit join failed, statusCode: %d, message: %s, leave channel", (Object[])new Object[]{statusCode, message});
                LiveKitChannelManager.this.leave();
                FlowChannelStatusObservable.getInstance().updateState(FlowChannelState.JOIN_FAILED);
            }

            public void onLeave() {
                MLog.info((Object)LiveKitChannelManager.TAG, (String)"live kit onLeave called", (Object[])new Object[0]);
                FlowChannelStatusObservable.getInstance().updateState(FlowChannelState.LEAVED);
            }
        });
    }

    private void updateHasCalledJion(boolean hasCalledJoin) {
        MLog.info((Object)TAG, (String)("updateHasCalledJion called with: hasCalledJoin = [" + hasCalledJoin + "]"), (Object[])new Object[0]);
        this.mHasCalledJoin = hasCalledJoin;
    }

    private void setVideoStream(String videoStreamJson) {
        MLog.info((Object)TAG, (String)"setVideoStreamJson, from: %s, to: %s", (Object[])new Object[]{this.mVideoStreamJson, videoStreamJson});
        this.mVideoStreamJson = videoStreamJson;
    }

    public static LiveKitChannelManager getInstance() {
        return Holder.INSTANCE;
    }

    private LiveKitChannelManager() {
        this.initLiveKit();
    }

    private static class Holder {
        private static final LiveKitChannelManager INSTANCE = new LiveKitChannelManager();

        private Holder() {
        }
    }
}

