/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.sdkwrapper.flowmanagement.api.audience.liveinfo;

import com.yy.mobile.sdkwrapper.flowmanagement.base.audience.liveinfo.LiveInfoChangeListener;
import com.yy.mobile.sdkwrapper.flowmanagement.internal.audience.liveinfo.LiveInfoListHolder;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.log.MLog;
import com.yy.yylivekit.model.LiveInfo;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;

public class LiveInfoChangeEventHandler {
    private static final String TAG = "LiveInfoChangeEventHandler";
    private List<LiveInfoChangeListener> mListeners = new CopyOnWriteArrayList<LiveInfoChangeListener>();

    public void addLiveInfoChangeListener(LiveInfoChangeListener listener) {
        MLog.info((Object)TAG, (String)"addLiveInfoChangeListener", (Object[])new Object[0]);
        this.addLiveInfoChangeListener(listener, true);
    }

    public void addLiveInfoChangeListener(LiveInfoChangeListener listener, boolean needInit) {
        List<LiveInfo> liveInfoList;
        MLog.info((Object)TAG, (String)("addLiveInfoChangeListener called with: listener = [" + listener + "], needInit = [" + needInit + "]"), (Object[])new Object[0]);
        if (listener == null) {
            return;
        }
        if (!this.mListeners.contains(listener)) {
            this.mListeners.add(listener);
        }
        if (needInit && !FP.empty(liveInfoList = LiveInfoListHolder.getInstance().getLiveInfoList())) {
            listener.onAddLiveInfos(liveInfoList);
        }
    }

    public void removeLiveInfoChangeListener(LiveInfoChangeListener listener) {
        MLog.info((Object)TAG, (String)("removeLiveInfoChangeListener called with: listener = [" + listener + "]"), (Object[])new Object[0]);
        if (listener != null) {
            this.mListeners.remove(listener);
        }
    }

    public List<LiveInfoChangeListener> getListeners() {
        return this.mListeners;
    }

    public static LiveInfoChangeEventHandler getInstance() {
        return Holder.INSTANCE;
    }

    private LiveInfoChangeEventHandler() {
    }

    private static class Holder {
        private static final LiveInfoChangeEventHandler INSTANCE = new LiveInfoChangeEventHandler();

        private Holder() {
        }
    }
}

