/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.sdkwrapper.flowmanagement.api.anchor.compat;

import com.yy.mobile.sdkwrapper.flowmanagement.base.entity.TransConfig;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.log.MLog;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Set;

public class AnchorTransConfigHolder {
    private static final String TAG = "AnchorTransConfigHolder";
    private Set<TransConfig> mTransConfigSet = new HashSet<TransConfig>();
    private Set<TransConfigUpdateListener> mTransConfigUpdateListenerSet = new HashSet<TransConfigUpdateListener>();

    private AnchorTransConfigHolder() {
    }

    public static AnchorTransConfigHolder getInstance() {
        return Holder.INSTANCE;
    }

    public void addTransConfigUpdateListener(TransConfigUpdateListener listener) {
        if (listener != null) {
            this.mTransConfigUpdateListenerSet.add(listener);
        }
    }

    public void removeTransConfigUpdateListener(TransConfigUpdateListener listener) {
        if (listener != null) {
            this.mTransConfigUpdateListenerSet.remove(listener);
        }
    }

    public void updateTransConfig(Set<TransConfig> transConfigs) {
        MLog.info((Object)TAG, (String)("updateTransConfig() called with: transConfigs = [" + transConfigs + "]"), (Object[])new Object[0]);
        if (FP.empty(transConfigs)) {
            return;
        }
        this.mTransConfigSet.clear();
        this.mTransConfigSet.addAll(transConfigs);
        this.notifyTransConfigUpdate();
    }

    public Set<TransConfig> getTransConfigSet() {
        return new HashSet<TransConfig>(this.mTransConfigSet);
    }

    private void notifyTransConfigUpdate() {
        if (FP.empty(this.mTransConfigUpdateListenerSet)) {
            return;
        }
        ArrayList<TransConfigUpdateListener> listeners = new ArrayList<TransConfigUpdateListener>(this.mTransConfigUpdateListenerSet);
        for (TransConfigUpdateListener listener : listeners) {
            listener.onTransConfigUpdate(this.getTransConfigSet());
        }
    }

    public static interface TransConfigUpdateListener {
        public void onTransConfigUpdate(Set<TransConfig> var1);
    }

    private static class Holder {
        private static final AnchorTransConfigHolder INSTANCE = new AnchorTransConfigHolder();

        private Holder() {
        }
    }
}

