/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.sdkwrapper.flowmanagement.api;

import android.support.annotation.NonNull;
import com.unionyy.mobile.spdt.Spdt;
import com.yy.mobile.sdkwrapper.flowmanagement.api.YLKEngineAppIdsApi;
import com.yy.mobile.util.log.MLog;
import com.yy.yylivekit.YLKEngine;

public final class FlowEnv {
    private static final String TAG = "FlowEnv";
    private static int mOrigSceneId;
    private static int mAppId;
    private static int mSwitchCount;
    private static YLKEngineAppIdsApi api;

    @NonNull
    private static YLKEngineAppIdsApi api() {
        if (api == null) {
            api = (YLKEngineAppIdsApi)Spdt.of(YLKEngineAppIdsApi.class);
        }
        return api;
    }

    public static boolean switchAppid(int appid, int sceneId) {
        int oldAppId = YLKEngine.getCurAppId();
        int oldSceneId = YLKEngine.getSceneId();
        MLog.info((Object)TAG, (String)"switchAppid: oldAppId:%d, oldSceneId:%d, appId:%d, sceneId:%d", (Object[])new Object[]{oldAppId, oldSceneId, appid, sceneId});
        if (oldAppId == appid && oldSceneId == sceneId) {
            return false;
        }
        return FlowEnv.api().setAppIds(appid, sceneId) == 0;
    }

    public static boolean switchSceneId(int sceneId) {
        boolean success;
        mAppId = YLKEngine.getCurAppId();
        int sceneIdTemp = YLKEngine.getSceneId();
        int res = 1;
        if (mAppId != 0 && sceneId != 0 && mSwitchCount == 0) {
            res = FlowEnv.api().setAppIds(mAppId, sceneId);
        }
        boolean bl = success = res == 0;
        if (success) {
            ++mSwitchCount;
            mOrigSceneId = sceneIdTemp;
        }
        MLog.info((Object)TAG, (String)"switchSceneId: appId:%d, sceneId:%d, mOrigSceneId:%d, mSwitchCount:%d, success:%b", (Object[])new Object[]{mAppId, sceneId, mOrigSceneId, mSwitchCount, success});
        return success;
    }

    public static boolean restoreSceneId() {
        boolean success;
        int res = -1;
        if (mAppId != 0 && mOrigSceneId != 0 && mSwitchCount == 1) {
            res = FlowEnv.api().setAppIds(mAppId, mOrigSceneId);
        }
        boolean bl = success = res != -1;
        if (success) {
            --mSwitchCount;
        }
        MLog.info((Object)TAG, (String)"restoreSceneId: appId:%d, sceneId:%d, mSwitchCount:%d, success:%b", (Object[])new Object[]{mAppId, mOrigSceneId, mSwitchCount, success});
        return success;
    }
}

