/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.plugin;

import android.os.Handler;
import android.os.Looper;
import com.yy.android.small.Small;
import com.yy.android.small.plugin.Plugin;
import com.yy.android.small.plugin.PluginManager;
import com.yy.mobile.util.FP;
import com.yy.small.pluginmanager.OnPluginUpdateFinishListener;
import java.lang.ref.WeakReference;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;

public enum HpInitManager {
    INSTANCE;

    private static final String TAG = "HpInitManager";
    private static final int STATUS_INITIAL = 0;
    private static final int STATUS_LOADING = 1;
    private static final int STATUS_FINISHED = 2;
    private Handler mHandler = new Handler(Looper.getMainLooper());
    private WeakReference<IDelayInitPluginHost> mDelayInitPluginHost;
    private AtomicInteger mStatus = new AtomicInteger(0);
    private Runnable mCurClickTask;
    private boolean isEnterChannelAction;
    private boolean isFinishRan = false;

    public void startAsyncInit(IDelayInitPluginHost host) {
        if (this.isFinishRan) {
            host.onPluginInitFinish();
            return;
        }
        this.mDelayInitPluginHost = new WeakReference<IDelayInitPluginHost>(host);
        if (this.mStatus.get() == 0) {
            this.mStatus.set(1);
            this.startAutoloadPlugins();
        }
    }

    private void startAutoloadPlugins() {
        int autoLoadMode = 4;
        Small.addUpdatePluginsRequest(Arrays.asList(autoLoadMode), (OnPluginUpdateFinishListener)new OnPluginUpdateFinishListener(){

            public void onFinish(boolean success) {
                List pluginList = Small.geShouldRunPluginList();
                if (FP.size((Collection)pluginList) <= 0) {
                    return;
                }
                for (Plugin plugin : pluginList) {
                    if (!plugin.matchLaunchMode(4)) continue;
                    PluginManager.INSTANCE.addLoadPluginRequest(plugin.id(), null);
                }
            }
        });
    }

    public void removeEnterChannelAction() {
        if (this.isEnterChannelAction) {
            this.mCurClickTask = null;
        }
    }

    private void markInitFinish() {
        if (this.mCurClickTask != null) {
            this.mCurClickTask.run();
            this.mCurClickTask = null;
        }
    }

    public boolean isFinishRan() {
        return this.isFinishRan;
    }

    public static interface IDelayInitPluginHost {
        public void onPluginInitFinish();

        public void showPluginLoading(boolean var1);

        public void hidePluginLoading(boolean var1);
    }
}

