/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.plugin;

import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import com.yy.android.small.Small;
import com.yy.android.small.plugin.PluginManager;
import com.yy.mobile.RxBus;
import com.yy.mobile.plugin.PluginActiveEvent;
import com.yy.mobile.plugin.PluginDownloadEvent;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.log.MLog;
import com.yy.small.pluginmanager.OnPluginUpdateFinishListener;
import com.yy.small.pluginmanager.PluginService;
import io.reactivex.BackpressureStrategy;
import io.reactivex.Flowable;
import io.reactivex.FlowableEmitter;
import io.reactivex.FlowableOnSubscribe;
import io.reactivex.android.schedulers.AndroidSchedulers;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import io.reactivex.schedulers.Schedulers;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.annotation.Nonnull;

public enum CustomPluginManager {
    INSTANCE;

    private static final String TAG = "CustomPluginManager";
    private Map<String, Disposable> mActiveDisposables;
    private Map<String, Object> mActivePluginReqs;
    private Map<String, Small.OnSetupListener> mPluginActiveListeners;
    private Map<String, Disposable> mDownloadDisposables;
    private Map<String, Object> mDownloadPluginReqs;
    private Map<String, OnPluginUpdateFinishListener> mPluginDownloadListeners;

    private String getListenerTag(@Nonnull String pluginId, @Nonnull String tag) {
        return pluginId + "_" + tag;
    }

    public boolean checkPluginIsActive(String pluginId, boolean withActive, boolean withDownload) {
        MLog.info((Object)TAG, (String)("checkPluginIsActive-> pluginId:" + pluginId + ",withActive:" + withActive + ",withload:" + withDownload), (Object[])new Object[0]);
        if (TextUtils.isEmpty((CharSequence)pluginId)) {
            return true;
        }
        PluginManager pluginManager = PluginManager.INSTANCE;
        if (pluginManager.isPluginActive(pluginId)) {
            MLog.info((Object)TAG, (String)"checkPluginIsActive plugin has been actived", (Object[])new Object[0]);
            return true;
        }
        if (!this.isPluginDownloaded(pluginId)) {
            MLog.info((Object)TAG, (String)("checkPluginIsActive plugin " + pluginId + " not download"), (Object[])new Object[0]);
            if (withDownload) {
                this.startDownloadPlugin(pluginId, withActive);
            }
            return false;
        }
        MLog.info((Object)TAG, (String)("checkPluginIsActive plugin " + pluginId + " has download"), (Object[])new Object[0]);
        if (withActive) {
            this.startActivePlugin(pluginId);
        }
        return false;
    }

    public void startDownloadPlugin(final String pluginId, final boolean withActive) {
        MLog.info((Object)TAG, (String)("startDownloadPlugin->pluginId:" + pluginId + ",withActive:" + withActive), (Object[])new Object[0]);
        if (this.hasSyncDownloadPluginTask(pluginId)) {
            MLog.info((Object)TAG, (String)("startDownloadPlugin->pluginId:" + pluginId + " download task has benn started"), (Object[])new Object[0]);
            return;
        }
        this.addDownloadDisposable(pluginId, this.downloadPlugin(pluginId, TAG, false).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).doFinally(new Action(){

            public void run() throws Exception {
                MLog.info((Object)CustomPluginManager.TAG, (String)("startDownloadPlugin doFinally->pluginId:" + pluginId), (Object[])new Object[0]);
                CustomPluginManager.this.removeDownloadDisposable(pluginId);
            }
        }).subscribe((Consumer)new Consumer<Boolean>(){

            public void accept(Boolean success) throws Exception {
                MLog.info((Object)CustomPluginManager.TAG, (String)("startDownloadPlugin complete->pluginId:" + pluginId + ",withActive:" + withActive + ",result:" + success), (Object[])new Object[0]);
                RxBus.getDefault().post((Object)new PluginDownloadEvent(pluginId, success));
                if (withActive) {
                    if (success.booleanValue()) {
                        CustomPluginManager.this.startActivePlugin(pluginId);
                    } else {
                        RxBus.getDefault().post((Object)new PluginActiveEvent(pluginId, false));
                    }
                }
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) throws Exception {
                MLog.error((Object)CustomPluginManager.TAG, (Throwable)throwable);
                RxBus.getDefault().post((Object)new PluginDownloadEvent(pluginId, false));
                if (withActive) {
                    RxBus.getDefault().post((Object)new PluginActiveEvent(pluginId, false));
                }
            }
        }));
    }

    private boolean hasSyncDownloadPluginTask(String pluginId) {
        return null != this.mDownloadDisposables && this.mDownloadDisposables.containsKey(pluginId);
    }

    private void addDownloadDisposable(String pluginId, Disposable disposable) {
        if (null == this.mDownloadDisposables) {
            this.mDownloadDisposables = new ConcurrentHashMap<String, Disposable>();
        }
        this.mDownloadDisposables.put(pluginId, disposable);
    }

    private void removeDownloadDisposable(String pluginId) {
        if (null == this.mDownloadDisposables) {
            return;
        }
        this.mDownloadDisposables.remove(pluginId);
    }

    public void startActivePlugin(final String pluginId) {
        MLog.info((Object)TAG, (String)("startActivePlugin->pluginId:" + pluginId), (Object[])new Object[0]);
        if (this.hasSyncActivingPluginTask(pluginId)) {
            return;
        }
        Disposable disposable = this.activePlugin(pluginId, TAG, false).subscribeOn(Schedulers.io()).observeOn(AndroidSchedulers.mainThread()).doFinally(new Action(){

            public void run() throws Exception {
                MLog.info((Object)CustomPluginManager.TAG, (String)("startActivePlugin doFinally->pluginId:" + pluginId), (Object[])new Object[0]);
                CustomPluginManager.this.removeActiveDisposable(pluginId);
            }
        }).subscribe((Consumer)new Consumer<Boolean>(){

            public void accept(Boolean aBoolean) throws Exception {
                RxBus.getDefault().post((Object)new PluginActiveEvent(pluginId, aBoolean));
            }
        }, (Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) throws Exception {
                MLog.error((Object)CustomPluginManager.TAG, (Throwable)throwable);
                RxBus.getDefault().post((Object)new PluginActiveEvent(pluginId, false));
            }
        });
        this.addActiveDisposable(pluginId, disposable);
    }

    private boolean hasSyncActivingPluginTask(String pluginId) {
        return null != this.mActiveDisposables && this.mActiveDisposables.containsKey(pluginId);
    }

    private void addActiveDisposable(@Nonnull String pluginId, Disposable disposable) {
        if (null == this.mActiveDisposables) {
            this.mActiveDisposables = new ConcurrentHashMap<String, Disposable>();
        }
        this.mActiveDisposables.put(pluginId, disposable);
    }

    private void removeActiveDisposable(@Nonnull String pluginId) {
        if (null == this.mActiveDisposables) {
            return;
        }
        this.mActiveDisposables.remove(pluginId);
    }

    public Flowable<Boolean> downloadPlugin(String pluginId, @Nonnull String tag, boolean removeDownloadWithCancel) {
        return this.downloadPlugin(pluginId, 1, tag, removeDownloadWithCancel);
    }

    public Flowable<Boolean> downloadPlugin(final String pluginId, final int loadMode, final @Nonnull String tag, final boolean removeDownloadWithCancel) {
        MLog.info((Object)TAG, (String)("downloadPlugin->pluginId:" + pluginId + ",tag:" + tag + ",removeDownloadWithCancel:" + removeDownloadWithCancel), (Object[])new Object[0]);
        return Flowable.create((FlowableOnSubscribe)new FlowableOnSubscribe<Boolean>(){

            public void subscribe(FlowableEmitter<Boolean> e) throws Exception {
                CustomPluginManager.this.downloadPluginWithEmitter(pluginId, loadMode, tag, (FlowableEmitter<Boolean>)e);
            }
        }, (BackpressureStrategy)BackpressureStrategy.LATEST).doOnError((Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) throws Exception {
                MLog.error((Object)CustomPluginManager.TAG, (Throwable)throwable);
                if (removeDownloadWithCancel) {
                    CustomPluginManager.this.cancelDownloadPlugin(pluginId);
                } else {
                    CustomPluginManager.this.removeDownloadListener(pluginId, tag);
                }
            }
        }).doOnCancel(new Action(){

            public void run() throws Exception {
                MLog.info((Object)CustomPluginManager.TAG, (String)("downloadPlugin doOnCancel->pluginId:" + pluginId), (Object[])new Object[0]);
                if (removeDownloadWithCancel) {
                    CustomPluginManager.this.cancelDownloadPlugin(pluginId);
                } else {
                    CustomPluginManager.this.removeDownloadListener(pluginId, tag);
                }
            }
        });
    }

    private void downloadPluginWithEmitter(String pluginId, int loadMode, @Nonnull String tag, final FlowableEmitter<Boolean> e) throws Exception {
        if (null == e || e.isCancelled()) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)pluginId)) {
            throw new Exception("pluginId must be nonNull");
        }
        if (this.isPluginDownloaded(pluginId)) {
            MLog.info((Object)TAG, (String)"plugin has download", (Object[])new Object[0]);
            e.onNext((Object)true);
            e.onComplete();
            return;
        }
        if (TextUtils.isEmpty((CharSequence)tag)) {
            throw new Exception("tag must be nonNull");
        }
        if (this.hasDownloadListener(pluginId, tag)) {
            MLog.info((Object)TAG, (String)"same tag download task has been started", (Object[])new Object[0]);
            e.onNext((Object)false);
            e.onComplete();
            return;
        }
        this.addDownloadListener(pluginId, tag, new OnPluginUpdateFinishListener(){

            public void onFinish(boolean result) {
                if (null == e || e.isCancelled()) {
                    return;
                }
                e.onNext((Object)result);
                e.onComplete();
            }
        });
        if (!this.isPluginDownloading(pluginId)) {
            this.downloadPluginInner(pluginId, loadMode);
        }
    }

    public boolean isPluginDownloaded(String pluginId) {
        if (!Small.isPluginShouldRun((String)pluginId)) {
            return false;
        }
        boolean isInUpdate = PluginService.isInUpdate((String)pluginId);
        MLog.debug((Object)TAG, (String)("checkPluginHasDownload->isDownloaded:true, isInUpdate:" + isInUpdate), (Object[])new Object[0]);
        return !isInUpdate;
    }

    public boolean isPluginDownloading(String pluginId) {
        return null != this.mDownloadPluginReqs && this.mDownloadPluginReqs.containsKey(pluginId);
    }

    public boolean hasDownloadListener(String pluginId, String tag) {
        return null != this.mPluginDownloadListeners && this.mPluginDownloadListeners.containsKey(this.getListenerTag(pluginId, tag));
    }

    private boolean downloadPluginInner(final String pluginId, int loadMode) {
        MLog.info((Object)TAG, (String)("downloadPluginInner->pluginId:" + pluginId), (Object[])new Object[0]);
        if (TextUtils.isEmpty((CharSequence)pluginId)) {
            return false;
        }
        ArrayList<String> pluginList = new ArrayList<String>();
        pluginList.add(pluginId);
        PluginManager pluginManager = PluginManager.INSTANCE;
        Object downloadReq = pluginManager.addUpdatePluginsRequest(Arrays.asList(loadMode), pluginList, new OnPluginUpdateFinishListener(){

            public void onFinish(final boolean result) {
                MLog.info((Object)CustomPluginManager.TAG, (String)("downloadPluginInner complete->pluginId:" + pluginId + ",result:" + result), (Object[])new Object[0]);
                new Handler(Looper.getMainLooper()).post(new Runnable(){

                    @Override
                    public void run() {
                        CustomPluginManager.this.onDownloadComplete(pluginId, result);
                    }
                });
            }
        });
        if (null == downloadReq) {
            MLog.info((Object)TAG, (String)("downloadPluginInner->pluginId:" + pluginId + " downloadReq is null"), (Object[])new Object[0]);
            return false;
        }
        this.addDownloadReq(pluginId, downloadReq);
        return true;
    }

    private boolean downloadPluginInner(String pluginId) {
        return this.downloadPluginInner(pluginId, 1);
    }

    private void addDownloadListener(String plugin, String tag, OnPluginUpdateFinishListener listener) {
        String trueTag;
        if (null == this.mPluginDownloadListeners) {
            this.mPluginDownloadListeners = new ConcurrentHashMap<String, OnPluginUpdateFinishListener>();
        }
        if (!this.mPluginDownloadListeners.containsKey(trueTag = this.getListenerTag(plugin, tag))) {
            this.mPluginDownloadListeners.put(trueTag, listener);
        }
    }

    private void removeDownloadListener(String plugin, String tag) {
        MLog.info((Object)TAG, (String)("removeDownloadListener-> pluginId:" + plugin + ",tag:" + tag), (Object[])new Object[0]);
        if (null == this.mPluginDownloadListeners) {
            return;
        }
        this.mPluginDownloadListeners.remove(this.getListenerTag(plugin, tag));
    }

    private void onDownloadComplete(String pluginId, boolean result) {
        MLog.info((Object)TAG, (String)("onDownloadComplete->pluginId:" + pluginId + ",result:" + result), (Object[])new Object[0]);
        this.removeDownloadReq(pluginId);
        if (FP.empty(this.mPluginDownloadListeners)) {
            return;
        }
        Iterator<String> iterator = this.mPluginDownloadListeners.keySet().iterator();
        while (iterator.hasNext()) {
            String key = iterator.next();
            if (!key.startsWith(pluginId + "_")) continue;
            OnPluginUpdateFinishListener listener = this.mPluginDownloadListeners.get(key);
            if (null != listener) {
                listener.onFinish(result);
            }
            iterator.remove();
        }
    }

    private void addDownloadReq(String pluginId, Object req) {
        if (null == this.mDownloadPluginReqs) {
            this.mDownloadPluginReqs = new ConcurrentHashMap<String, Object>();
        }
        this.mDownloadPluginReqs.put(pluginId, req);
    }

    private void removeDownloadReq(String pluginId) {
        MLog.info((Object)TAG, (String)("removeDownloadReq->pluginId:" + pluginId), (Object[])new Object[0]);
        if (null == this.mDownloadPluginReqs) {
            return;
        }
        this.mDownloadPluginReqs.remove(pluginId);
    }

    public boolean cancelDownloadPlugin(String pluginId) {
        MLog.info((Object)TAG, (String)("cancelDownloadPlugin->pluginId:" + pluginId), (Object[])new Object[0]);
        if (null == this.mDownloadPluginReqs) {
            return false;
        }
        boolean result = false;
        Object req = this.mDownloadPluginReqs.get(pluginId);
        if (null != req) {
            result = PluginManager.INSTANCE.removeUpdatePluginsRequest(req);
        }
        this.mDownloadPluginReqs.remove(pluginId);
        this.onDownloadComplete(pluginId, false);
        return result;
    }

    public Flowable<Boolean> activePluginWithDownload(final String pluginId, final int loadMode, final String tag, final boolean cancelWhenDispose) {
        MLog.info((Object)TAG, (String)("activePluginWithDownload->pluginId:" + pluginId + ",tag:" + tag + ",cancelWhenDispose:" + cancelWhenDispose), (Object[])new Object[0]);
        return Flowable.create((FlowableOnSubscribe)new FlowableOnSubscribe<Boolean>(){

            public void subscribe(FlowableEmitter<Boolean> e) throws Exception {
                if (TextUtils.isEmpty((CharSequence)pluginId)) {
                    throw new Exception("pluginId must be nonNull");
                }
                if (CustomPluginManager.this.isPluginDownloaded(pluginId)) {
                    CustomPluginManager.this.activePluginWithEmitter(pluginId, tag, (FlowableEmitter<Boolean>)e);
                } else {
                    CustomPluginManager.this.downloadAndActiveWithEmitter(pluginId, loadMode, tag, e);
                }
            }
        }, (BackpressureStrategy)BackpressureStrategy.LATEST).doOnCancel(new Action(){

            public void run() throws Exception {
                MLog.info((Object)CustomPluginManager.TAG, (String)("activePluginWithDownload doOnCancel->pluginId:" + pluginId + ",tag:" + tag + ",cancelWhenDispose:" + cancelWhenDispose), (Object[])new Object[0]);
                CustomPluginManager.this.onDownloadAndActiveFinishWithException(pluginId, tag, cancelWhenDispose);
            }
        }).doOnError((Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) throws Exception {
                MLog.error((Object)CustomPluginManager.TAG, (Throwable)throwable);
                CustomPluginManager.this.onDownloadAndActiveFinishWithException(pluginId, tag, cancelWhenDispose);
            }
        });
    }

    public Flowable<Boolean> activePluginWithDownload(String pluginId, String tag, boolean cancelWhenDispose) {
        return this.activePluginWithDownload(pluginId, 1, tag, cancelWhenDispose);
    }

    private void onDownloadAndActiveFinishWithException(String pluginId, String tag, boolean cancelTask) {
        if (cancelTask) {
            this.cancelDownloadPlugin(pluginId);
            this.cancelActivePlugin(pluginId);
        } else {
            this.removeDownloadListener(pluginId, tag);
            this.removeActiveListener(pluginId, tag);
        }
    }

    private void downloadAndActiveWithEmitter(final @Nonnull String pluginId, int loadMode, final String tag, final FlowableEmitter e) throws Exception {
        MLog.info((Object)TAG, (String)("downloadAndActiveWithEmitter->pluginId:" + pluginId + ",tag:" + tag), (Object[])new Object[0]);
        if (TextUtils.isEmpty((CharSequence)tag)) {
            throw new Exception("tag must be nonNull");
        }
        if (this.hasDownloadListener(pluginId, tag)) {
            MLog.info((Object)TAG, (String)("downloadAndActiveWithEmitter " + tag + " downloadtask has been started"), (Object[])new Object[0]);
            e.onNext((Object)false);
            e.onComplete();
            return;
        }
        this.addDownloadListener(pluginId, tag, new OnPluginUpdateFinishListener(){

            public void onFinish(boolean success) {
                if (null == e || e.isCancelled()) {
                    return;
                }
                if (!success) {
                    e.onNext((Object)false);
                    e.onComplete();
                    return;
                }
                try {
                    CustomPluginManager.this.activePluginWithEmitter(pluginId, tag, (FlowableEmitter<Boolean>)e);
                }
                catch (Exception e1) {
                    MLog.error((Object)CustomPluginManager.TAG, (Throwable)e1);
                    e.onNext((Object)false);
                    e.onComplete();
                }
            }
        });
        if (!this.isPluginDownloading(pluginId)) {
            this.downloadPluginInner(pluginId, loadMode);
        }
    }

    public Flowable<Boolean> activePlugin(final String pluginId, final String tag, final boolean cancelActiveWhenDispose) {
        return Flowable.create((FlowableOnSubscribe)new FlowableOnSubscribe<Boolean>(){

            public void subscribe(FlowableEmitter<Boolean> e) throws Exception {
                CustomPluginManager.this.activePluginWithEmitter(pluginId, tag, (FlowableEmitter<Boolean>)e);
            }
        }, (BackpressureStrategy)BackpressureStrategy.LATEST).subscribeOn(AndroidSchedulers.mainThread()).doOnError((Consumer)new Consumer<Throwable>(){

            public void accept(Throwable throwable) throws Exception {
                MLog.error((Object)CustomPluginManager.TAG, (Throwable)throwable);
                if (cancelActiveWhenDispose) {
                    CustomPluginManager.this.cancelActivePlugin(pluginId);
                } else {
                    CustomPluginManager.this.removeActiveListener(pluginId, tag);
                }
            }
        }).doOnCancel(new Action(){

            public void run() throws Exception {
                MLog.info((Object)CustomPluginManager.TAG, (String)("activePlugin doFinnally->pluginId:" + pluginId + ",tag:" + tag), (Object[])new Object[0]);
                if (cancelActiveWhenDispose) {
                    CustomPluginManager.this.cancelActivePlugin(pluginId);
                } else {
                    CustomPluginManager.this.removeActiveListener(pluginId, tag);
                }
            }
        });
    }

    private void activePluginWithEmitter(String pluginId, String tag, final FlowableEmitter<Boolean> e) throws Exception {
        MLog.info((Object)TAG, (String)("activePluginWithEmitter->pluginId:" + pluginId + ",tag:" + tag), (Object[])new Object[0]);
        if (null == e || e.isCancelled()) {
            return;
        }
        if (TextUtils.isEmpty((CharSequence)pluginId)) {
            throw new Exception("pluginId must be nonNull");
        }
        if (this.isPluginActive(pluginId)) {
            MLog.info((Object)TAG, (String)("activePluginWithEmitter->pluginId:" + pluginId + ",plugin has been active"), (Object[])new Object[0]);
            e.onNext((Object)true);
            e.onComplete();
            return;
        }
        if (TextUtils.isEmpty((CharSequence)tag)) {
            throw new Exception("tag must be nonNull");
        }
        if (this.hasActiveListener(pluginId, tag)) {
            MLog.info((Object)TAG, (String)("activePluginWithEmitter->pluginId:" + pluginId + ",tag:" + tag + ",this tag task has started"), (Object[])new Object[0]);
            e.onNext((Object)false);
            e.onComplete();
            return;
        }
        this.addActiveListener(pluginId, tag, new Small.OnSetupListener(){

            public void onSetup(Small.SetupResult result) {
                if (null == e || e.isCancelled()) {
                    return;
                }
                e.onNext((Object)(Small.SetupResult.PluginSetupSuccess == result ? 1 : 0));
                e.onComplete();
            }
        });
        if (!this.isPluginActiving(pluginId)) {
            this.activePluginInner(pluginId);
        }
    }

    private boolean activePluginInner(final String pluginId) {
        MLog.info((Object)TAG, (String)("activePluginInner->pluginId:" + pluginId), (Object[])new Object[0]);
        if (TextUtils.isEmpty((CharSequence)pluginId)) {
            return false;
        }
        ArrayList<String> pluginList = new ArrayList<String>();
        pluginList.add(pluginId);
        PluginManager pluginManager = PluginManager.INSTANCE;
        Object activeReq = pluginManager.addLoadPluginRequest(pluginId, new Small.OnSetupListener(){

            public void onSetup(Small.SetupResult result) {
                MLog.info((Object)CustomPluginManager.TAG, (String)("activePluginInner->pluginId:" + pluginId + ",result:" + (Small.SetupResult.PluginSetupSuccess == result)), (Object[])new Object[0]);
                CustomPluginManager.this.onActiveComplete(pluginId, result);
            }
        });
        if (null == activeReq) {
            MLog.info((Object)TAG, (String)("activePluginInner->pluginId:" + pluginId + " activeReq is null"), (Object[])new Object[0]);
            return false;
        }
        this.addActiveReq(pluginId, activeReq);
        return true;
    }

    public boolean isPluginActive(String pluginId) {
        return PluginManager.INSTANCE.isPluginActive(pluginId);
    }

    public boolean isPluginActiving(String pluginId) {
        return null != this.mActivePluginReqs && this.mActivePluginReqs.containsKey(pluginId);
    }

    private boolean hasActiveListener(String pluginId, String key) {
        return null != this.mPluginActiveListeners && this.mPluginActiveListeners.containsKey(this.getListenerTag(pluginId, key));
    }

    private void addActiveReq(String pluginId, Object req) {
        if (null == this.mActivePluginReqs) {
            this.mActivePluginReqs = new ConcurrentHashMap<String, Object>();
        }
        this.mActivePluginReqs.put(pluginId, req);
    }

    private void removeActiveReq(String pluginId) {
        MLog.info((Object)TAG, (String)("removeActiveReq->pluginId:" + pluginId), (Object[])new Object[0]);
        if (null == this.mActivePluginReqs) {
            return;
        }
        this.mActivePluginReqs.remove(pluginId);
    }

    private void addActiveListener(String pluginId, String key, Small.OnSetupListener listener) {
        if (null == this.mPluginActiveListeners) {
            this.mPluginActiveListeners = new ConcurrentHashMap<String, Small.OnSetupListener>();
        }
        this.mPluginActiveListeners.put(this.getListenerTag(pluginId, key), listener);
    }

    private void removeActiveListener(String pluginId, String key) {
        MLog.info((Object)TAG, (String)("removeActiveListener->pluginId:" + pluginId + ",key:" + key), (Object[])new Object[0]);
        if (null == this.mPluginActiveListeners) {
            return;
        }
        this.mPluginActiveListeners.remove(this.getListenerTag(pluginId, key));
    }

    private void onActiveComplete(String pluginId, Small.SetupResult result) {
        MLog.info((Object)TAG, (String)("onActiveComplete->pluginId:" + pluginId), (Object[])new Object[0]);
        this.removeActiveReq(pluginId);
        if (FP.empty(this.mPluginActiveListeners)) {
            return;
        }
        Iterator<String> iterator = this.mPluginActiveListeners.keySet().iterator();
        while (iterator.hasNext()) {
            String key = iterator.next();
            if (!key.startsWith(pluginId + "_")) continue;
            Small.OnSetupListener listener = this.mPluginActiveListeners.get(key);
            if (null != listener) {
                listener.onSetup(result);
            }
            iterator.remove();
        }
    }

    public boolean cancelActivePlugin(String pluginId) {
        MLog.info((Object)TAG, (String)("cancelActivePlugin->pluginId:" + pluginId), (Object[])new Object[0]);
        if (null == this.mActivePluginReqs) {
            return false;
        }
        boolean result = false;
        Object req = this.mActivePluginReqs.get(pluginId);
        if (null != req) {
            result = PluginManager.INSTANCE.removeLoadPluginRequest(req);
        }
        this.mActivePluginReqs.remove(pluginId);
        this.onActiveComplete(pluginId, Small.SetupResult.PluginSetupFail);
        return result;
    }
}

