/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.channeltokenutil;

import android.net.Uri;
import android.text.TextUtils;
import com.yy.mobile.util.log.MLog;
import java.util.UUID;

public class JoinChannelTokenUtil {
    private static final String TAG = "JoinChannelTokenUtil";
    private static String mJoinChannelToken;

    public static String createOrSetJoinChannelToken(String token) {
        try {
            MLog.info((Object)TAG, (String)("createJoinChannelToken token: " + token), (Object[])new Object[0]);
            if (TextUtils.isEmpty((CharSequence)token)) {
                token = UUID.randomUUID().toString().replace('-', 'g') + "andh";
                MLog.info((Object)TAG, (String)("createJoinChannelToken randomUUID token: " + token), (Object[])new Object[0]);
            }
            mJoinChannelToken = token;
        }
        catch (Throwable throwable) {
            MLog.error((Object)TAG, (Throwable)throwable);
        }
        return token;
    }

    public static String addOrReplaceChannelUrlToken(String url) {
        if (TextUtils.isEmpty((CharSequence)url)) {
            return url;
        }
        try {
            Uri uri;
            if (url.contains("yymobile://Channel") && (uri = Uri.parse((String)url)) != null) {
                String query = uri.getQuery();
                if (TextUtils.isEmpty((CharSequence)query)) {
                    String token = JoinChannelTokenUtil.createOrSetJoinChannelToken(null);
                    url = url + "?token=" + token;
                } else if (!query.contains("token")) {
                    String token = JoinChannelTokenUtil.createOrSetJoinChannelToken(null);
                    url = url + "&token=" + token;
                } else {
                    mJoinChannelToken = uri.getQueryParameter("token");
                }
            }
        }
        catch (Throwable throwable) {
            MLog.info((Object)TAG, (String)("url = " + url), (Object[])new Object[0]);
            MLog.error((Object)TAG, (Throwable)throwable);
        }
        return url;
    }

    public static Uri addOrReplaceChannelUrlToken(Uri uri) {
        if (uri == null) {
            return null;
        }
        return Uri.parse((String)JoinChannelTokenUtil.addOrReplaceChannelUrlToken(uri.toString()));
    }

    public static String getJoinChannelToken() {
        return mJoinChannelToken;
    }

    public static void cleanJoinChannelToken() {
        mJoinChannelToken = null;
    }
}

