/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.bizmodel.login;

import android.content.Context;
import android.support.annotation.Nullable;
import com.unionyy.mobile.magnet.core.repo.SelfInfo;
import com.unionyy.mobile.magnet.core.repo.ThirdPartyInfo;
import com.unionyy.mobile.magnet.core.state.AnonymousState;
import com.unionyy.mobile.magnet.core.state.LoginState;
import com.unionyy.mobile.magnet.core.state.State;
import com.unionyy.mobile.magnet.southpole.Magnet;
import com.unionyy.mobile.spdt.Spdt;
import com.yy.mobile.bizmodel.accesstoken.OauthToken;
import com.yy.mobile.bizmodel.login.Account;
import com.yy.mobile.bizmodel.login.LoginType;
import com.yy.mobile.bizmodel.login.ThirdType;
import com.yy.mobile.bizmodel.login.union.UnionLoginUtil;
import com.yy.mobile.util.log.MLog;
import io.reactivex.Single;

public class LoginUtil {
    private static final String TAG = "LoginUtil";
    @Nullable
    private static UnionLoginUtil impl;

    public static long getUid() {
        return Magnet.INSTANCE.getUid();
    }

    public static boolean isLogined() {
        return Magnet.INSTANCE.isLogin();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Nullable
    private static UnionLoginUtil getDelegate() {
        if (impl != null) return impl;
        Class<LoginUtil> clazz = LoginUtil.class;
        synchronized (LoginUtil.class) {
            if (impl != null) return impl;
            impl = (UnionLoginUtil)Spdt.ofOrNull(UnionLoginUtil.class);
            MLog.info((Object)TAG, (String)("create instance of " + impl), (Object[])new Object[0]);
            // ** MonitorExit[var0] (shouldn't be in output)
            return impl;
        }
    }

    @Deprecated
    public static boolean isAnoymousLogined() {
        return !LoginUtil.isLogined();
    }

    public static long getAnoymousUid() {
        State s = Magnet.INSTANCE.getCurrentState();
        if (s instanceof AnonymousState) {
            return ((AnonymousState)s).getAnonymousUid();
        }
        return 0L;
    }

    @Nullable
    public static String getAccountName() {
        State s = Magnet.INSTANCE.getCurrentState();
        if (s instanceof LoginState) {
            SelfInfo info = ((LoginState)s).getSelfInfo();
            ThirdPartyInfo thirdInfo = ((LoginState)s).getThirdPartyInfo();
            String nick = info.getNickName();
            return nick.length() != 0 ? nick : (thirdInfo != null ? thirdInfo.getNickName() : null);
        }
        return null;
    }

    @Deprecated
    public static ThirdType getThirdPartyLoginType() {
        return ThirdType.None;
    }

    @Nullable
    public static Account getCurrentAccount() {
        State s = Magnet.INSTANCE.getCurrentState();
        if (s instanceof LoginState) {
            SelfInfo info = ((LoginState)s).getSelfInfo();
            ThirdPartyInfo thirdInfo = ((LoginState)s).getThirdPartyInfo();
            Account.Builder builder = new Account.Builder().setUserId(info.getUid()).setIsNewUser(((LoginState)s).isNewUser()).setName(info.getNickName()).setPassport(info.getPassport()).setLoginType(LoginType.None);
            if (thirdInfo != null) {
                builder.setIconUrl(thirdInfo.getAvatar()).setName(thirdInfo.getNickName()).setLoginType(LoginType.ThirParty);
            }
            return builder.build();
        }
        return null;
    }

    public static Single<OauthToken> getUnionToken() {
        UnionLoginUtil delegate = LoginUtil.getDelegate();
        if (delegate != null) {
            return delegate.getUnionToken();
        }
        return Single.error((Throwable)new RuntimeException("Could not find the implementation of UnionLoginUtil."));
    }

    public static void synchronizeUnionLoginState() {
        UnionLoginUtil delegate = LoginUtil.getDelegate();
        if (delegate != null) {
            delegate.synchronizeUnionLoginState(null);
        } else {
            MLog.error((Object)TAG, (String)"No UnionLoginUtil found for synchronizeUnionLoginState", (Object[])new Object[0]);
        }
    }

    @Nullable
    public static String getUnionOpenId() {
        UnionLoginUtil delegate = LoginUtil.getDelegate();
        if (delegate != null) {
            return delegate.getUnionOpenId();
        }
        MLog.error((Object)TAG, (String)"No UnionLoginUtil found for getUnionOpenId", (Object[])new Object[0]);
        return null;
    }

    public static void refreshToken() {
        UnionLoginUtil delegate = LoginUtil.getDelegate();
        if (delegate != null) {
            delegate.refreshToken();
        } else {
            MLog.error((Object)TAG, (String)"No UnionLoginUtil found for refreshToken", (Object[])new Object[0]);
        }
    }

    public static void showLoginDialog(@Nullable Context context) {
        UnionLoginUtil delegate = LoginUtil.getDelegate();
        if (delegate != null) {
            delegate.showLoginDialog(context);
        } else {
            MLog.error((Object)TAG, (String)"No UnionLoginUtil found for showLoginDialog", (Object[])new Object[0]);
        }
    }

    public static boolean checkLoginStatus(Context context) {
        if (!LoginUtil.isLogined()) {
            LoginUtil.showLoginDialog(context);
            return false;
        }
        return true;
    }
}

