/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.bizmodel.login;

import android.support.annotation.NonNull;
import com.yy.mobile.bizmodel.login.LoginType;
import com.yy.mobile.bizmodel.login.OnlineState;
import com.yy.mobile.bizmodel.login.ThirdType;
import com.yy.mobile.model.store.State;

public final class Account
extends State {
    public final long userId;
    public final String name;
    public final String encryptedPassword;
    public final String passport;
    public final LoginType loginType;
    public final long loginTime;
    public final OnlineState onlineState;
    public final String iconUrl;
    public final String reserve1;
    public final String reserve2;
    public final String thirdPartyToken;
    public final ThirdType thirdPartyType;
    public final boolean isNewUser;

    private Account(Builder builder) {
        super((State.Builder)builder);
        this.userId = builder.userId;
        this.name = builder.name;
        this.encryptedPassword = builder.encryptedPassword;
        this.passport = builder.passport;
        this.loginTime = builder.loginTime;
        this.loginType = builder.loginType != null ? builder.loginType : LoginType.None;
        this.onlineState = builder.onlineState;
        this.iconUrl = builder.iconUrl;
        this.reserve1 = builder.reserve1;
        this.reserve2 = builder.reserve2;
        this.thirdPartyToken = builder.thirdPartyToken;
        this.thirdPartyType = builder.thirdPartyType != null ? builder.thirdPartyType : ThirdType.None;
        this.isNewUser = builder.isNewUser;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || ((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        Account account = (Account)((Object)o);
        if (this.userId != account.userId) {
            return false;
        }
        if (this.loginTime != account.loginTime) {
            return false;
        }
        if (this.isNewUser != account.isNewUser) {
            return false;
        }
        if (this.name != null ? !this.name.equals(account.name) : account.name != null) {
            return false;
        }
        if (this.encryptedPassword != null ? !this.encryptedPassword.equals(account.encryptedPassword) : account.encryptedPassword != null) {
            return false;
        }
        if (this.passport != null ? !this.passport.equals(account.passport) : account.passport != null) {
            return false;
        }
        if (this.loginType != account.loginType) {
            return false;
        }
        if (this.onlineState != account.onlineState) {
            return false;
        }
        if (this.iconUrl != null ? !this.iconUrl.equals(account.iconUrl) : account.iconUrl != null) {
            return false;
        }
        if (this.reserve1 != null ? !this.reserve1.equals(account.reserve1) : account.reserve1 != null) {
            return false;
        }
        if (this.reserve2 != null ? !this.reserve2.equals(account.reserve2) : account.reserve2 != null) {
            return false;
        }
        if (this.thirdPartyToken != null ? !this.thirdPartyToken.equals(account.thirdPartyToken) : account.thirdPartyToken != null) {
            return false;
        }
        return this.thirdPartyType == account.thirdPartyType;
    }

    public int hashCode() {
        int result = (int)(this.userId ^ this.userId >>> 32);
        result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
        result = 31 * result + (this.encryptedPassword != null ? this.encryptedPassword.hashCode() : 0);
        result = 31 * result + (this.passport != null ? this.passport.hashCode() : 0);
        result = 31 * result + (this.loginType != null ? this.loginType.hashCode() : 0);
        result = 31 * result + (int)(this.loginTime ^ this.loginTime >>> 32);
        result = 31 * result + (this.onlineState != null ? this.onlineState.hashCode() : 0);
        result = 31 * result + (this.iconUrl != null ? this.iconUrl.hashCode() : 0);
        result = 31 * result + (this.reserve1 != null ? this.reserve1.hashCode() : 0);
        result = 31 * result + (this.reserve2 != null ? this.reserve2.hashCode() : 0);
        result = 31 * result + (this.thirdPartyToken != null ? this.thirdPartyToken.hashCode() : 0);
        result = 31 * result + (this.thirdPartyType != null ? this.thirdPartyType.hashCode() : 0);
        result = 31 * result + (this.isNewUser ? 1 : 0);
        return result;
    }

    public String toString() {
        return "Account{userId=" + this.userId + ", name='" + this.name + '\'' + ", passport='" + this.passport + '\'' + ", loginType=" + (Object)((Object)this.loginType) + ", loginTime=" + this.loginTime + ", onlineState=" + (Object)((Object)this.onlineState) + ", iconUrl='" + this.iconUrl + '\'' + ", reserve1='" + this.reserve1 + '\'' + ", reserve2='" + this.reserve2 + '\'' + ", thirdPartyToken='" + this.thirdPartyToken + '\'' + ", thirdPartyType=" + this.thirdPartyType + ", isNewUser=" + this.isNewUser + '}';
    }

    public static class Builder
    extends State.Builder<Account> {
        private long userId;
        private String name;
        private String encryptedPassword;
        private String passport;
        private LoginType loginType;
        private long loginTime;
        private OnlineState onlineState;
        private String iconUrl;
        private String reserve1;
        private String reserve2;
        private String thirdPartyToken;
        private ThirdType thirdPartyType;
        private boolean isNewUser;

        public Builder() {
            this(null);
        }

        public Builder(Account original) {
            if (original == null) {
                this.onlineState = OnlineState.Online;
                this.loginType = LoginType.None;
                this.thirdPartyType = ThirdType.None;
                this.isNewUser = false;
                return;
            }
            this.userId = original.userId;
            this.name = original.name;
            this.encryptedPassword = original.encryptedPassword;
            this.passport = original.passport;
            this.loginTime = original.loginTime;
            this.loginType = original.loginType;
            this.onlineState = original.onlineState;
            this.iconUrl = original.iconUrl;
            this.reserve1 = original.reserve1;
            this.reserve2 = original.reserve2;
            this.thirdPartyToken = original.thirdPartyToken;
            this.thirdPartyType = original.thirdPartyType;
            this.isNewUser = original.isNewUser;
        }

        public Builder setUserId(long userId) {
            this.userId = userId;
            return this;
        }

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setEncryptedPassword(String encryptedPassword) {
            this.encryptedPassword = encryptedPassword;
            return this;
        }

        public Builder setPassport(String passport) {
            this.passport = passport;
            return this;
        }

        public Builder setLoginType(@NonNull LoginType loginType) {
            this.loginType = loginType;
            return this;
        }

        public Builder setLoginTime(long loginTime) {
            this.loginTime = loginTime;
            return this;
        }

        public Builder setOnlineState(OnlineState onlineState) {
            this.onlineState = onlineState;
            return this;
        }

        public Builder setIconUrl(String iconUrl) {
            this.iconUrl = iconUrl;
            return this;
        }

        public Builder setReserve1(String reserve1) {
            this.reserve1 = reserve1;
            return this;
        }

        public Builder setReserve2(String reserve2) {
            this.reserve2 = reserve2;
            return this;
        }

        public Builder setThirdPartyToken(String thirdPartyToken) {
            this.thirdPartyToken = thirdPartyToken;
            return this;
        }

        public Builder setThirdPartyType(@NonNull ThirdType thirdPartyType) {
            this.thirdPartyType = thirdPartyType;
            return this;
        }

        public Builder setIsNewUser(boolean isNewUser) {
            this.isNewUser = isNewUser;
            return this;
        }

        @NonNull
        public Account build() {
            return new Account(this);
        }
    }
}

