/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.bizmodel.live;

import android.util.SparseArray;
import android.util.SparseIntArray;
import com.yy.mobile.bizmodel.live.SubChannelRole;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.ArrayList;
import java.util.List;

public class ChannelUserStruct {
    public static final int UINFO_UID = 1;
    public static final int UINFO_YYID = 2;
    public static final int UINFO_SEX = 3;
    public static final int UINFO_TOPSID = 4;
    public static final int UINFO_SUBSID = 5;
    public static final int UINFO_NICK = 100;
    public static final int UINFO_SIGN = 101;
    public static final int UINFO_UDB = 102;
    public static final int UINFO_COOKIE = 103;
    public static final int UINFO_PASSPORT = 104;
    public static final int UINFO_EXT = 105;
    public static final int UINFO_ROLE = 106;
    public static final int UINFO_VIP = 107;
    public static final int UINFO_INVALID_VALUE = -1;
    public static final String UINFO_INVALID_STR = "";
    private final SparseIntArray sparseIntArray;
    private final SparseArray<byte[]> strVal;

    public ChannelUserStruct(SparseIntArray intArray, SparseArray<byte[]> strVal) {
        this.sparseIntArray = intArray != null ? intArray : new SparseIntArray();
        this.strVal = strVal != null ? strVal : new SparseArray();
    }

    public int getIntVal(int key) {
        return this.sparseIntArray.get(key, -1);
    }

    public byte[] getStrVal(int key) {
        return (byte[])this.strVal.get(key, (Object)UINFO_INVALID_STR.getBytes());
    }

    public long getUid() {
        return ChannelUserStruct.getUnsignedInt(this.getIntVal(1));
    }

    public long getTopSid() {
        return ChannelUserStruct.getUnsignedInt(this.getIntVal(4));
    }

    public long getSubSid() {
        return ChannelUserStruct.getUnsignedInt(this.getIntVal(5));
    }

    public List<SubChannelRole> getRole() {
        ArrayList<SubChannelRole> rolers = new ArrayList<SubChannelRole>();
        byte[] buf = this.getStrVal(106);
        if (buf == null || buf.length < 4) {
            return rolers;
        }
        ByteBuffer buffer = ByteBuffer.wrap(buf);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        int len = buffer.getInt();
        for (int i = 0; i < len; ++i) {
            rolers.add(new SubChannelRole(ChannelUserStruct.getUnsignedInt(buffer.getInt()), buffer.getShort()));
        }
        return rolers;
    }

    public SparseIntArray getIntArray() {
        return this.sparseIntArray;
    }

    public SparseArray<byte[]> getStringArray() {
        return this.strVal;
    }

    private static long getUnsignedInt(int data) {
        return (long)data & 0xFFFFFFFFL;
    }
}

