/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.plugin.pluginunionpersonalcenter.profile.anchor;

import android.content.Context;
import android.graphics.Rect;
import android.os.Bundle;
import android.support.annotation.NonNull;
import android.support.v4.app.FragmentActivity;
import android.support.v7.widget.RecyclerView;
import android.support.v7.widget.StaggeredGridLayoutManager;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.RelativeLayout;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.android.arouter.facade.annotation.Autowired;
import com.yy.mobile.plugin.main.events.IAnchorWorksClient_onGetAnchorWorks_EventArgs;
import com.yy.mobile.plugin.main.events.IAnchorWorksClient_onGetNoData_EventArgs;
import com.yy.mobile.plugin.main.events.IMobileLiveClient_onDeleteMobileLiveReplaySuccess_EventArgs;
import com.yy.mobile.plugin.pluginunionpersonalcenter.R;
import com.yy.mobile.plugin.pluginunionpersonalcenter.profile.anchor.AnchorWorksAdapter;
import com.yy.mobile.plugin.pluginunionpersonalcenter.profile.anchor.AnchorWorksFragment$$EventBinder;
import com.yy.mobile.smartrefresh.layout.SmartRefreshLayout;
import com.yy.mobile.smartrefresh.layout.api.RefreshLayout;
import com.yy.mobile.smartrefresh.layout.listener.OnLoadmoreListener;
import com.yy.mobile.ui.utils.DensityUtil;
import com.yy.mobile.util.OnVisibleChangeFragment;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreManager;
import com.yymobile.core.onepiece.ScrollableContainer;
import com.yymobile.core.profile.IAnchorWorksCore;
import com.yymobile.core.profile.NoMoreWorksInfo;
import com.yymobile.core.profile.RePlayWorksInfo;
import com.yymobile.core.profile.WorksInfo;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public class AnchorWorksFragment
extends OnVisibleChangeFragment
implements ScrollableContainer {
    public static final String BUNDLE_ANCHOR_UID = "extra_anchor_uid";
    private static final String TAG = "AnchorWorksFragment";
    @Autowired(name="extra_anchor_uid")
    long anchorUid = 0L;
    @Autowired(name="IsShopPagerPopupComponent")
    boolean isShopPagerPopupComponent = false;
    RecyclerView mRecyclerView;
    RelativeLayout mAnchorworksBg;
    SmartRefreshLayout mRefreshLayout;
    private boolean mIsLastPage = false;
    private AnchorWorksAdapter mAdapter;
    private EventBinder mAnchorWorksFragmentSniperEventBinder;

    public static AnchorWorksFragment newInstance(long anchorId) {
        AnchorWorksFragment fragment = new AnchorWorksFragment();
        Bundle bundle = new Bundle();
        bundle.putLong(BUNDLE_ANCHOR_UID, anchorId);
        fragment.setArguments(bundle);
        return fragment;
    }

    private void initView(View view) {
        this.mRecyclerView = (RecyclerView)view.findViewById(R.id.anchorworksList);
        this.mAnchorworksBg = (RelativeLayout)view.findViewById(R.id.anchorworks_bg);
        this.mRefreshLayout = (SmartRefreshLayout)view.findViewById(R.id.anchorworksRefreshLayout);
    }

    public void onResume() {
        super.onResume();
        if (this.mAdapter != null && this.mAdapter.getData().size() <= 0) {
            this.showNoData(this.anchorUid);
        }
    }

    public void onPause() {
        super.onPause();
        MLog.info((Object)TAG, (String)"onPause", (Object[])new Object[0]);
    }

    public void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setParentFragmentVisible(true);
    }

    @android.support.annotation.Nullable
    public View onCreateView(@NonNull LayoutInflater inflater, @android.support.annotation.Nullable ViewGroup container, @android.support.annotation.Nullable Bundle savedInstanceState) {
        View view = View.inflate((Context)this.getContext(), (int)R.layout.fragment_anchorworks_stagger_list, null);
        this.initView(view);
        return view;
    }

    public void onViewCreated(View view, @android.support.annotation.Nullable Bundle savedInstanceState) {
        if (this.mAnchorWorksFragmentSniperEventBinder == null) {
            this.mAnchorWorksFragmentSniperEventBinder = new AnchorWorksFragment$$EventBinder();
        }
        this.mAnchorWorksFragmentSniperEventBinder.bindEvent((Object)this);
        super.onViewCreated(view, savedInstanceState);
        this.initRefreshLayout();
        ((IAnchorWorksCore)CoreManager.getCore(IAnchorWorksCore.class)).requestAnchorWorks(this.anchorUid);
    }

    private void initRefreshLayout() {
        MLog.info((Object)TAG, (String)"initRefreshLayout", (Object[])new Object[0]);
        FragmentActivity context = this.getActivity();
        if (context != null) {
            this.mAdapter = new AnchorWorksAdapter((Context)context, this.anchorUid, false, this.isShopPagerPopupComponent);
            this.mRefreshLayout.setEnableRefresh(false);
            this.mRefreshLayout.setOnLoadmoreListener(new OnLoadmoreListener(){

                public void onLoadmore(RefreshLayout refreshlayout) {
                    ((IAnchorWorksCore)CoreManager.getCore(IAnchorWorksCore.class)).requestAnchorWorksNextPage(AnchorWorksFragment.this.anchorUid);
                }
            });
            this.mRecyclerView.setAdapter((RecyclerView.Adapter)this.mAdapter);
            this.mRecyclerView.setLayoutManager((RecyclerView.LayoutManager)new StaggeredGridLayoutManager(2, 1));
            this.mRecyclerView.addItemDecoration((RecyclerView.ItemDecoration)new WorkItemDecoration((Context)context));
        }
    }

    @BusEvent(busType=1, busName="plugin_pluginunionmain")
    public void onGetAnchorWorks(IAnchorWorksClient_onGetAnchorWorks_EventArgs busEventArgs) {
        MLog.info((Object)TAG, (String)("onGetAnchorWorks mIsLastPage:" + this.mIsLastPage), (Object[])new Object[0]);
        long anchorId = busEventArgs.getAnchorId();
        if (!this.mIsLastPage && anchorId == this.anchorUid) {
            List works = busEventArgs.getWorks();
            Iterator iterator = works.iterator();
            while (iterator.hasNext()) {
                WorksInfo info = (WorksInfo)iterator.next();
                if (!(info instanceof RePlayWorksInfo)) continue;
                RePlayWorksInfo worksInfo = (RePlayWorksInfo)info;
                if (worksInfo.storeReason == null) continue;
                Integer storeReason = Integer.valueOf(worksInfo.storeReason);
                if (worksInfo.storeReason != null && (0x100 & storeReason) == 256) {
                    iterator.remove();
                    continue;
                }
                if (worksInfo.storeReason == null || (0x400 & storeReason) != 1024) continue;
                iterator.remove();
            }
            this.mRefreshLayout.finishLoadmore();
            int endFlag = busEventArgs.getEndflag();
            MLog.info((Object)TAG, (String)("onGetAnchorWorks endFlag:" + endFlag), (Object[])new Object[0]);
            MLog.error((Object)TAG, (String)("works\u7684\u503c\u4e3a\uff1a" + works.size()), (Object[])new Object[0]);
            if (works.size() > 0) {
                this.mAnchorworksBg.setVisibility(8);
                this.mIsLastPage = endFlag == 1;
                this.mRefreshLayout.setEnableLoadmore(!this.mIsLastPage);
                this.mAdapter.addData(works);
                if (this.mIsLastPage) {
                    this.mAdapter.addData((WorksInfo)NoMoreWorksInfo.INSTANCE);
                }
                this.mAdapter.notifyDataSetChanged();
            }
        }
    }

    @BusEvent(busType=1, busName="plugin_pluginunionmain")
    public void onGetNoData(IAnchorWorksClient_onGetNoData_EventArgs busEventArgs) {
        long anchorId = busEventArgs.getAnchorId();
        this.showNoData(anchorId);
    }

    public void showNoData(long anchorId) {
        if (anchorId == this.anchorUid) {
            this.mAnchorworksBg.setVisibility(0);
            this.mRefreshLayout.setEnableLoadmore(false);
            this.mAdapter.clearData();
            this.mAdapter.notifyDataSetChanged();
        }
    }

    @BusEvent(sync=true)
    public void onDeleteMobileLiveReplaySuccess(IMobileLiveClient_onDeleteMobileLiveReplaySuccess_EventArgs busEventArgs) {
        String progamId = busEventArgs.getProgamId();
        if (progamId != null && !progamId.isEmpty() && this.mAdapter != null) {
            List<WorksInfo> replayVideoEntityList = this.mAdapter.getData();
            Iterator<WorksInfo> it = replayVideoEntityList.iterator();
            while (it.hasNext()) {
                WorksInfo bean = it.next();
                if (!bean.worksType.equals("0") || !(bean instanceof RePlayWorksInfo)) continue;
                RePlayWorksInfo rePlayWorksInfo = (RePlayWorksInfo)bean;
                if (!progamId.equals(rePlayWorksInfo.liveId)) continue;
                it.remove();
                break;
            }
            this.mAdapter.notifyDataSetChanged();
        }
    }

    public View getScrollableView() {
        return this.mRecyclerView;
    }

    public void onFragmentFirstVisible() {
    }

    protected void onDestroyView() {
        super.onDestroyView();
        if (this.mAnchorWorksFragmentSniperEventBinder != null) {
            this.mAnchorWorksFragmentSniperEventBinder.unBindEvent();
        }
    }

    private static class WorkItemDecoration
    extends RecyclerView.ItemDecoration {
        private final int dp3;
        private final int dp1point5;

        private WorkItemDecoration(@NonNull Context context) {
            this.dp3 = DensityUtil.dip2px((Context)context, (float)3.0f);
            this.dp1point5 = this.dp3 / 2;
        }

        public void getItemOffsets(Rect outRect, View view, RecyclerView parent, RecyclerView.State state) {
            int pos = parent.getChildAdapterPosition(view);
            if (pos % 2 == 0) {
                outRect.set(this.dp3, 0, this.dp1point5, this.dp3);
            } else {
                outRect.set(this.dp1point5, 0, this.dp3, this.dp3);
            }
        }
    }
}

