/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.plugin.pluginunionpersonalcenter.subscribe;

import android.annotation.SuppressLint;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import com.yy.hiidostatis.defs.obj.Property;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.image.CircleImageView;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.plugin.pluginunionpersonalcenter.R;
import com.yy.mobile.plugin.pluginunionpersonalcenter.subscribe.UniversalCallback;
import com.yy.mobile.ui.home.FaceHelperFactory;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import com.yymobile.core.subscribe.SubscribeInfo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class SubscribeAdapter
extends BaseAdapter {
    private static final String TAG = "SubscribeAdapter";
    private Context mContext;
    private List<SubscribeInfo> mSubscribeList = new ArrayList<SubscribeInfo>();
    private boolean mIsEditMode = false;
    private long mFromUid;
    private boolean mIsMyself;
    private UniversalCallback<Integer> onDataClearCallback;
    private Set<Integer> alreadyReportPosition = new HashSet<Integer>();

    public void setOnUniversalCallback(UniversalCallback<Integer> onDataClearCallback) {
        this.onDataClearCallback = onDataClearCallback;
    }

    public SubscribeAdapter(Context context, long fromUid) {
        this.mContext = context;
        this.mFromUid = fromUid;
        this.mIsMyself = fromUid == LoginUtil.getUid();
    }

    public void setData(List<SubscribeInfo> list) {
        this.mSubscribeList = list;
    }

    public List<SubscribeInfo> getData() {
        return this.mSubscribeList;
    }

    public void setEditMode(boolean isEditMode) {
        this.mIsEditMode = isEditMode;
    }

    public boolean isEditMode() {
        return this.mIsEditMode;
    }

    @SuppressLint(value={"WrongConstant"})
    public View getView(final int position, View convertView, ViewGroup parent) {
        ViewHolder holder;
        if (convertView == null) {
            holder = new ViewHolder();
            convertView = LayoutInflater.from((Context)this.mContext).inflate(R.layout.layout_subscribe_item, parent, false);
            holder.deleteIv = (ImageView)convertView.findViewById(R.id.iv_delete);
            holder.portraitIv = (CircleImageView)convertView.findViewById(R.id.iv_portrait_headIcon);
            holder.authVIcon = (CircleImageView)convertView.findViewById(R.id.iv_portrait_authVIcon);
            holder.nameTv = (TextView)convertView.findViewById(R.id.tv_name);
            holder.fansCountTv = (TextView)convertView.findViewById(R.id.tv_fans_count);
            holder.onLiveIv = (ImageView)convertView.findViewById(R.id.iv_on_live);
            holder.moreIv = (ImageView)convertView.findViewById(R.id.iv_more);
            holder.ivLove = (ImageView)convertView.findViewById(R.id.iv_love);
            convertView.setTag((Object)holder);
        } else {
            holder = (ViewHolder)convertView.getTag();
        }
        SubscribeInfo item = this.getItem(position);
        FaceHelperFactory.loadFace((String)item.portraitUrl, (int)item.portraitIndex, (FaceHelperFactory.FaceType)FaceHelperFactory.FaceType.FriendFace, (RecycleImageView)holder.portraitIv, (ImageConfig)ImageConfig.defaultImageConfig(), (int)R.drawable.default_portrait);
        if (item.anchorAuthV == 0) {
            holder.authVIcon.setVisibility(8);
        } else if (item.anchorAuthV == 1) {
            holder.authVIcon.setBackgroundResource(R.drawable.me_icon_vip);
            holder.authVIcon.setVisibility(0);
        } else if (item.anchorAuthV == 2) {
            holder.authVIcon.setBackgroundResource(R.drawable.common_portrait_auth_v_10);
            holder.authVIcon.setVisibility(0);
        } else {
            holder.authVIcon.setVisibility(8);
        }
        holder.nameTv.setText((CharSequence)item.name);
        holder.fansCountTv.setText((CharSequence)("" + item.fansCount));
        holder.moreIv.setVisibility(this.mIsMyself ? 0 : 8);
        holder.moreIv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                MLog.info((Object)SubscribeAdapter.TAG, (String)"moreIv onclick", (Object[])new Object[0]);
                SubscribeInfo subscribeInfo = SubscribeAdapter.this.getItem(position);
                SubscribeAdapter.this.onDataClearCallback.onCallback(2, subscribeInfo);
            }
        });
        if (item.isLiving) {
            holder.onLiveIv.setVisibility(0);
        } else {
            holder.onLiveIv.setVisibility(4);
        }
        holder.ivLove.setVisibility(item.isLove ? 0 : 8);
        if (!this.alreadyReportPosition.contains(position)) {
            this.alreadyReportPosition.add(position);
            Property property = new Property();
            property.putString("key1", item.topCid + "_" + item.uid + "_" + (position + 1) + "_" + item.token);
            ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "50202", "0010");
        }
        return convertView;
    }

    public long getItemId(int position) {
        return 0L;
    }

    public SubscribeInfo getItem(int position) {
        return this.mSubscribeList.get(position);
    }

    public int getCount() {
        return this.mSubscribeList.size();
    }

    public void onUnSubscribe(long anchorUid) {
        Iterator<SubscribeInfo> iterator = this.mSubscribeList.iterator();
        while (iterator.hasNext()) {
            SubscribeInfo info = iterator.next();
            if (info.uid != anchorUid) continue;
            iterator.remove();
            MLog.info((Object)TAG, (String)"onUnSubscribe remove data", (Object[])new Object[0]);
            if (this.onDataClearCallback == null) break;
            this.onDataClearCallback.onCallback(1, null);
            break;
        }
        this.notifyDataSetChanged();
        if (this.getCount() == 0 && this.onDataClearCallback != null) {
            this.onDataClearCallback.onCallback(0, null);
        }
    }

    private static class ViewHolder {
        ImageView deleteIv;
        CircleImageView portraitIv;
        CircleImageView authVIcon;
        TextView nameTv;
        TextView fansCountTv;
        ImageView onLiveIv;
        ImageView moreIv;
        ImageView ivLove;

        private ViewHolder() {
        }
    }
}

