/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.plugin.pluginunionpersonalcenter.fans;

import android.app.Activity;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.request.RequestOptions;
import com.yy.mobile.image.CircleImageView;
import com.yy.mobile.plugin.pluginunionpersonalcenter.R;
import com.yy.mobile.plugin.pluginunionpersonalcenter.fans.FansUserInfo;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;

public class UserFansListAdapter
extends BaseAdapter {
    private Activity context;
    private List<FansUserInfo> mData = new ArrayList<FansUserInfo>();

    public UserFansListAdapter(Activity context) {
        this.context = context;
    }

    public void addData(List<FansUserInfo> data) {
        if (data != null && data.size() > 0) {
            this.mData.addAll(data);
            this.notifyDataSetChanged();
        }
    }

    public void setData(List<FansUserInfo> data) {
        this.mData.clear();
        if (data != null && data.size() > 0) {
            this.mData.addAll(data);
        }
        this.notifyDataSetChanged();
    }

    public List<FansUserInfo> getData() {
        return this.mData;
    }

    public int getCount() {
        return this.mData.size();
    }

    public FansUserInfo getItem(int position) {
        return this.mData.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder holder;
        if (convertView == null) {
            holder = new ViewHolder();
            convertView = LayoutInflater.from((Context)this.context).inflate(R.layout.personalcenter_layout_user_fanslist_item, parent, false);
            holder.portraitIv = (CircleImageView)convertView.findViewById(R.id.iv_portrait_headIcon);
            holder.portraitAuthVIv = (CircleImageView)convertView.findViewById(R.id.iv_portrait_authVIcon);
            holder.nameTv = (TextView)convertView.findViewById(R.id.tv_name);
            holder.fansNumTv = (TextView)convertView.findViewById(R.id.fans_num_txt);
            holder.anchorFlag = (TextView)convertView.findViewById(R.id.anchor_flag);
            convertView.setTag((Object)holder);
        } else {
            holder = (ViewHolder)convertView.getTag();
        }
        FansUserInfo info = this.getItem(position);
        if (info != null) {
            holder.nameTv.setText((CharSequence)info.getNick());
            Glide.with((Activity)this.context).load(info.getAvatar()).apply(RequestOptions.placeholderOf((int)R.drawable.default_portrait)).into((ImageView)holder.portraitIv);
            holder.anchorFlag.setVisibility(info.isAnchor() ? 0 : 8);
            holder.fansNumTv.setText((CharSequence)String.format(Locale.CHINA, "\u7c89\u4e1d\u6570\uff1a%d", info.getFansNum()));
            int anchorV = info.getAnchorV();
            if (anchorV == 1) {
                holder.portraitAuthVIv.setBackgroundResource(R.drawable.me_icon_vip);
                holder.portraitAuthVIv.setVisibility(0);
            } else if (anchorV == 2) {
                holder.portraitAuthVIv.setBackgroundResource(R.drawable.common_portrait_auth_v_10);
                holder.portraitAuthVIv.setVisibility(0);
            } else {
                holder.portraitAuthVIv.setVisibility(8);
            }
        }
        return convertView;
    }

    private static class ViewHolder {
        CircleImageView portraitIv;
        CircleImageView portraitAuthVIv;
        TextView anchorFlag;
        TextView nameTv;
        TextView fansNumTv;

        private ViewHolder() {
        }
    }
}

