/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.plugin.pluginunionpersonalcenter.profile.edit.text;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.Editable;
import android.text.InputFilter;
import android.text.Selection;
import android.text.Spannable;
import android.text.TextWatcher;
import android.view.View;
import android.widget.EditText;
import android.widget.TextView;
import com.alibaba.android.arouter.facade.annotation.Route;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.RxBus;
import com.yy.mobile.baseapi.model.store.YYStore;
import com.yy.mobile.model.ReqAction;
import com.yy.mobile.plugin.main.events.IArtistNameClient_onSetUserArtistPropRsp_EventArgs;
import com.yy.mobile.plugin.pluginunionpersonalcenter.R;
import com.yy.mobile.plugin.pluginunionpersonalcenter.profile.artist.ArtistNameProtocol;
import com.yy.mobile.plugin.pluginunionpersonalcenter.profile.artist.IArtistNameCore;
import com.yy.mobile.plugin.pluginunionpersonalcenter.profile.edit.text.InputTextActivity$$EventBinder;
import com.yy.mobile.ui.BaseActivity;
import com.yy.mobile.ui.utils.dialog.BaseDialog;
import com.yy.mobile.ui.utils.dialog.DialogLinkManager;
import com.yy.mobile.ui.utils.dialog.ProgressDialog;
import com.yy.mobile.ui.widget.SimpleTitleBar;
import com.yy.mobile.ui.widget.toast.Toast;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.NetworkUtils;
import com.yy.mobile.util.RxUtils;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.valid.BlankUtil;
import com.yy.mobile.yyprotocol.core.Uint32;
import com.yymobile.core.CoreManager;
import com.yymobile.core.im.event.UpdateBuddyRemarkInfoEventArgs;
import com.yymobile.core.im.request.UpdateUserRemarkAction;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

@Route(path="/User/InputText", name="\u586b\u5199\u63cf\u8ff0/\u7b7e\u540d")
public class InputTextActivity
extends BaseActivity {
    private static final String TAG = "InputTextActivity";
    public static final String KEY_SET_TITLE = "key_set_title";
    public static final String KEY_SET_SINGLE_LINE = "key_set_single_line";
    public static final String KEY_SET_MAX_TEXT_NUM = "key_set_max_text_num";
    public static final String KEY_SET_TEXT = "key_set_text";
    public static final String KEY_SET_LINES = "key_set_lines";
    public static final String KEY_SET_ONLY_SIGN = "key_set_only_sign";
    public static final String RESULT_INPUT_TEXT = "result_input_text";
    public static final String KEY_TIPS_TEXT = "key_tips_text";
    public static final String KEY_ARTIST_UID = "key_artist_uid";
    public static final String KEY_ARTIST_NAME = "key_artist_name";
    public static final String KEY_ARTIST_NAME_DATA = "key_artist_name_date";
    public static final String KEY_SET_HINT = "key_set_hint";
    public static final String KEY_ANCHOR_UID = "key_anchor_uid";
    public static final int RESULT_CODE = 2;
    public static final int RESYLT_ADD_CODE = 4;
    public static final int RESULT_REMARKS_CODE = 5;
    public static final int RESULT_DESCRIPTION_CODE = 6;
    private DialogLinkManager mDialogLinkManager;
    private EditText mEtInputText;
    private String onlySign = "";
    private String cacheInputText;
    private int artistNameDate;
    private TextView tipsText;
    private boolean isArtistName = false;
    public static int MAX_COUNT = 20;
    public String strUid = "";
    public String artistName = "";
    public long anchorUid;
    private int maxTextNum = 20;
    List<Disposable> mEventDisposable = new ArrayList<Disposable>();
    private TextWatcher mTextWatcher = new TextWatcher(){
        private int editStart;
        private int editEnd;
        String tips = "\u8fd8\u53ef\u4ee5\u8f93\u5165";

        public void beforeTextChanged(CharSequence s, int arg1, int arg2, int arg3) {
        }

        public void onTextChanged(CharSequence s, int arg1, int arg2, int arg3) {
        }

        public void afterTextChanged(Editable s) {
            if (s.length() != 0) {
                InputTextActivity.this.tipsText.setText((CharSequence)(this.tips + ((long)MAX_COUNT - InputTextActivity.this.calculateLength(s.toString())) + "\u5b57"));
                InputTextActivity.this.tipsText.setVisibility(0);
            } else {
                InputTextActivity.this.tipsText.setVisibility(8);
            }
            if (InputTextActivity.this.calculateLength(s.toString()) > (long)MAX_COUNT) {
                int selEndIndex = Selection.getSelectionEnd((CharSequence)s);
                String newStr = s.toString();
                while (InputTextActivity.this.calculateLength(newStr) > (long)MAX_COUNT) {
                    newStr = newStr.substring(0, newStr.length() - 1);
                }
                InputTextActivity.this.mEtInputText.setText((CharSequence)newStr);
                s = InputTextActivity.this.mEtInputText.getText();
                int newLen = s.length();
                if (selEndIndex > newLen) {
                    selEndIndex = newLen;
                }
                Selection.setSelection((Spannable)s, (int)selEndIndex);
            }
        }
    };
    private EventBinder mInputTextActivitySniperEventBinder;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.registerEvent();
        this.setContentView(R.layout.layout_input_text_activity);
        Intent i = this.getIntent();
        String title = this.getString(R.string.str_input_text_activity_title);
        boolean isSingleLine = false;
        int lines = 100;
        String text = "";
        String hint = "";
        if (i != null) {
            this.anchorUid = i.getLongExtra(KEY_ANCHOR_UID, 0L);
            this.strUid = i.getStringExtra(KEY_ARTIST_UID);
            title = i.getStringExtra(KEY_SET_TITLE);
            hint = i.getStringExtra(KEY_SET_HINT);
            this.onlySign = i.getStringExtra(KEY_SET_ONLY_SIGN);
            this.isArtistName = i.getBooleanExtra(KEY_ARTIST_NAME, false);
            isSingleLine = i.getBooleanExtra(KEY_SET_SINGLE_LINE, false);
            MAX_COUNT = this.maxTextNum = i.getIntExtra(KEY_SET_MAX_TEXT_NUM, 20);
            lines = i.getIntExtra(KEY_SET_LINES, 100);
            if (!StringUtils.isEmptyString((String)i.getStringExtra(KEY_SET_TEXT))) {
                this.artistName = text = i.getStringExtra(KEY_SET_TEXT);
            }
            if (i.getIntExtra(KEY_ARTIST_NAME_DATA, 0) != 0) {
                this.artistNameDate = i.getIntExtra(KEY_ARTIST_NAME_DATA, 0);
            }
        }
        SimpleTitleBar titleBar = (SimpleTitleBar)this.findViewById(R.id.title_bar);
        titleBar.setTitlte(title);
        titleBar.setLeftBtn(R.drawable.icon_nav_back, new View.OnClickListener(){

            public void onClick(View v) {
                InputTextActivity.this.finish();
            }
        });
        View rootTitleView = this.getLayoutInflater().inflate(R.layout.layout_titlebar_right_text_extra, null);
        TextView rightView = (TextView)rootTitleView.findViewById(R.id.tv_right_button);
        rightView.setText((CharSequence)"\u4fdd\u5b58");
        rightView.setOnClickListener(new View.OnClickListener(){

            public void onClick(View view) {
                if (!InputTextActivity.this.onlySign.equals("SIGNATURE") && !InputTextActivity.this.onlySign.equals("DESCRIPTION")) {
                    InputTextActivity.this.mEtInputText.setText((CharSequence)InputTextActivity.this.mEtInputText.getText().toString().replaceAll("\n", ""));
                }
                InputTextActivity.this.resultNewIntent();
            }
        });
        titleBar.setRightView(rootTitleView);
        this.tipsText = (TextView)this.findViewById(R.id.tips_text);
        if (this.onlySign.equals("ARTIST")) {
            this.tipsText.setVisibility(0);
            this.tipsText.setText((CharSequence)"\u6e29\u99a8\u63d0\u793a\uff1a\u6bcf\u4e2a\u6708\u4ec5\u53ef\u4fee\u6539\u4e00\u6b21\uff0c\u4ec5\u652f\u6301\u4e2d\u6587\u3001\u82f1\u6587\u3001\u6570\u5b57\u548c\u4e0b\u5212\u7ebf(\u6700\u591a5\u4e2a\u6c49\u5b57)");
        }
        this.mEtInputText = (EditText)this.findViewById(R.id.edt_input_text);
        if (!FP.empty((CharSequence)hint)) {
            this.mEtInputText.setHint((CharSequence)hint);
        }
        if (this.onlySign != null && (this.onlySign.equals("SIGNATURE") || this.onlySign.equals("DESCRIPTION"))) {
            this.mEtInputText.addTextChangedListener(this.mTextWatcher);
        } else {
            this.mEtInputText.setFilters(new InputFilter[]{new InputFilter.LengthFilter(this.maxTextNum)});
        }
        this.mEtInputText.setLines(lines);
        this.mEtInputText.setSingleLine(isSingleLine);
        this.mEtInputText.setText((CharSequence)text);
        this.mEtInputText.setSelection(this.mEtInputText.length());
        this.getWindow().setSoftInputMode(16);
        if (this.isArtistName && this.artistNameDate == 1) {
            rightView.setVisibility(8);
            this.mEtInputText.setEnabled(false);
        }
        Object var12_11 = null;
        if (this.mInputTextActivitySniperEventBinder == null) {
            this.mInputTextActivitySniperEventBinder = new InputTextActivity$$EventBinder();
        }
        this.mInputTextActivitySniperEventBinder.bindEvent((Object)this);
    }

    private void registerEvent() {
        Disposable disposable = RxBus.getDefault().register(UpdateBuddyRemarkInfoEventArgs.class, (Object)this).subscribe((Consumer)new Consumer<UpdateBuddyRemarkInfoEventArgs>(){

            public void accept(@NonNull UpdateBuddyRemarkInfoEventArgs eventArgs) throws Exception {
                Intent i = new Intent();
                i.putExtra(InputTextActivity.RESULT_INPUT_TEXT, eventArgs.getRemark());
                InputTextActivity.this.setResult(5, i);
                InputTextActivity.this.finish();
            }
        }, RxUtils.errorConsumer((String)TAG));
        this.mEventDisposable.add(disposable);
    }

    private void unregisterEvent() {
        if (this.mEventDisposable != null) {
            for (Disposable disposable : this.mEventDisposable) {
                if (disposable == null || disposable.isDisposed()) continue;
                disposable.dispose();
            }
            this.mEventDisposable.clear();
        }
    }

    private long calculateLength(CharSequence c) {
        double len = 0.0;
        for (int i = 0; i < c.length(); ++i) {
            char tmp = c.charAt(i);
            if (tmp > '\u0000' && tmp < '\u007f') {
                len += 0.5;
                continue;
            }
            len += 1.0;
        }
        return Math.round(len);
    }

    public void resultNewIntent() {
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)TAG, (String)("ly--resultNewIntent=" + this.onlySign), (Object[])new Object[0]);
        }
        if (this.onlySign != null) {
            if (this.onlySign.equals("SIGNATURE")) {
                String txt = this.mEtInputText.getText().toString().trim();
                if (MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)TAG, (String)("zs-- resultNewIntent " + txt), (Object[])new Object[0]);
                }
                Intent i = new Intent();
                i.putExtra(RESULT_INPUT_TEXT, txt);
                this.setResult(4, i);
                this.finish();
            } else if (this.onlySign.equals("DESCRIPTION")) {
                String txt = this.mEtInputText.getText().toString().trim();
                if (MLog.isLogLevelAboveDebug()) {
                    MLog.debug((Object)TAG, (String)("zs-- resultNewIntent " + txt), (Object[])new Object[0]);
                }
                Intent i = new Intent();
                i.putExtra(RESULT_INPUT_TEXT, txt);
                this.setResult(6, i);
                this.finish();
            } else if (this.onlySign.equals("NICKNAME")) {
                String txt = this.mEtInputText.getText().toString().trim();
                if (BlankUtil.isBlank((String)txt)) {
                    Toast.makeText((Context)this, (CharSequence)"\u6635\u79f0\u4e0d\u80fd\u4e3a\u7a7a", (int)0).show();
                    return;
                }
                Intent i = new Intent();
                i.putExtra(RESULT_INPUT_TEXT, txt);
                this.setResult(2, i);
                this.finish();
            } else if (this.onlySign.equals("ARTIST")) {
                if (!this.checkNetToast()) {
                    return;
                }
                String txt = this.mEtInputText.getText().toString().trim();
                if (BlankUtil.isBlank((String)txt)) {
                    Toast.makeText((Context)this, (CharSequence)"\u827a\u540d\u4e0d\u80fd\u4e3a\u7a7a", (int)0).show();
                    return;
                }
                if (txt.equals(this.artistName)) {
                    Toast.makeText((Context)this, (CharSequence)"\u827a\u540d\u6ca1\u6709\u4fee\u6539", (int)0).show();
                    return;
                }
                if (!InputTextActivity.validateUserName(txt)) {
                    MLog.info((Object)"isArtistName validateUserName", (String)txt, (Object[])new Object[0]);
                    Toast.makeText((Context)this, (CharSequence)"\u827a\u540d\u4e0d\u80fd\u5305\u542b\u975e\u6cd5\u5b57\u7b26", (int)0).show();
                    return;
                }
                if (!this.characterCheck("\u827a\u540d", 10, txt)) {
                    return;
                }
                this.artistName = txt;
                if (this.mDialogLinkManager == null) {
                    this.mDialogLinkManager = this.getDialogLinkManager();
                }
                if (!this.mDialogLinkManager.isDialogShowing()) {
                    this.mDialogLinkManager.showDialog((BaseDialog)new ProgressDialog("\u6b63\u5728\u4fdd\u5b58", false, true, 0, null));
                }
                this.saveArtistNameFile(this.artistName);
            } else if (this.onlySign.equals("ADDREMARKS")) {
                String remark = this.mEtInputText.getText().toString().trim();
                if (remark.length() > this.maxTextNum) {
                    Toast.makeText((Context)this, (CharSequence)"\u4fee\u6539\u5907\u6ce8\u4e0d\u80fd\u8d85\u8fc7%d\u4e2a\u5b57", (int)0).show();
                    return;
                }
                if (!NetworkUtils.isNetworkAvailable((Context)this.getContext())) {
                    Toast.makeText((Context)this, (CharSequence)this.getString(R.string.str_network_not_capable), (int)0).show();
                    return;
                }
                if (this.anchorUid > 0L) {
                    MLog.info((Object)((Object)this), (String)("feng --  updateRemark  Uid = " + this.anchorUid + ", remark=" + remark), (Object[])new Object[0]);
                    YYStore.INSTANCE.dispatch((ReqAction)new UpdateUserRemarkAction(this.anchorUid, remark));
                }
            }
        } else {
            String txt = this.mEtInputText.getText().toString().trim();
            Intent i = new Intent();
            i.putExtra(RESULT_INPUT_TEXT, txt);
            this.setResult(2, i);
            this.finish();
        }
    }

    private boolean characterCheck(String txt, int maxNum, String chkTxt) {
        if (InputTextActivity.getCharacterNum(chkTxt) > maxNum) {
            Toast.makeText((Context)this, (CharSequence)String.format("\u4fee\u6539%s\u4e0d\u80fd\u8d85\u8fc7%d\u4e2a\u5b57\u7b26\uff0c\u4e00\u4e2a\u4e2d\u6587\u7b49\u4e8e\u4e24\u4e2a\u5b57\u7b26", txt, maxNum), (int)0).show();
            return false;
        }
        return true;
    }

    public static boolean validateUserName(String userName) {
        String validateStr = "^[\\w\\-\uff0d\uff3f[0-9]\u4e00-\u9fbb\uff21-\uff3a\uff41-\uff5a]+$";
        return InputTextActivity.matcher(validateStr, userName);
    }

    private static boolean matcher(String reg, String string2) {
        Pattern pattern = Pattern.compile(reg);
        Matcher matcher = pattern.matcher(string2);
        return matcher.matches();
    }

    private void saveArtistNameFile(String artistName) {
        HashMap<Uint32, String> artistProp = new HashMap<Uint32, String>();
        HashMap<String, String> extendInfo = new HashMap<String, String>();
        if (!StringUtils.isEmptyString((String)artistName) && !StringUtils.isEmptyString((String)this.strUid)) {
            extendInfo.put("uid", this.strUid);
            extendInfo.put("artistName", artistName);
            artistProp.put(ArtistNameProtocol.PSetUserArtistPropReq.ARTISTNAME_KEY_NAME, artistName);
        }
        ((IArtistNameCore)CoreManager.getCore(IArtistNameCore.class)).setUserArtistPropReq(artistProp, extendInfo);
    }

    @BusEvent(sync=true)
    public void onSetUserArtistPropRsp(IArtistNameClient_onSetUserArtistPropRsp_EventArgs busEventArgs) {
        long result = busEventArgs.getResult();
        Map extendInfo = busEventArgs.getExtendInfo();
        if (this.mDialogLinkManager != null && this.mDialogLinkManager.isDialogShowing()) {
            this.mDialogLinkManager.hideProgressDialog();
            this.mDialogLinkManager.dismissDialog();
        }
        if (!this.isResume()) {
            return;
        }
        if (result == 0L) {
            Intent i = new Intent();
            i.putExtra(RESULT_INPUT_TEXT, this.artistName);
            this.setResult(2, i);
            this.finish();
        } else {
            this.showArtistFailToast((int)result);
        }
    }

    private void showArtistFailToast(int result) {
        MLog.info((Object)TAG, (String)"showArtistFailToast result:%s", (Object[])new Object[]{result});
        switch (result) {
            case 1: {
                Toast.makeText((Context)this, (CharSequence)this.getString(R.string.arist_fail1_tips), (int)0).show();
                break;
            }
            case 2: {
                Toast.makeText((Context)this, (CharSequence)this.getString(R.string.arist_fail2_tips), (int)0).show();
                break;
            }
            case 3: {
                Toast.makeText((Context)this, (CharSequence)this.getString(R.string.arist_fail3_tips), (int)0).show();
                break;
            }
            case 4: {
                Toast.makeText((Context)this, (CharSequence)this.getString(R.string.arist_fail4_tips), (int)0).show();
                break;
            }
            case 5: {
                Toast.makeText((Context)this, (CharSequence)this.getString(R.string.arist_fail5_tips), (int)0).show();
                break;
            }
            case 6: {
                Toast.makeText((Context)this, (CharSequence)this.getString(R.string.arist_fail6_tips), (int)0).show();
                break;
            }
            case 7: {
                Toast.makeText((Context)this, (CharSequence)this.getString(R.string.arist_fail7_tips), (int)0).show();
                break;
            }
            case 8: {
                Toast.makeText((Context)this, (CharSequence)this.getString(R.string.arist_fail8_tips), (int)0).show();
                break;
            }
            default: {
                Toast.makeText((Context)this, (CharSequence)this.getString(R.string.arist_fail_default_tips), (int)0).show();
            }
        }
    }

    public static int getCharacterNum(String content) {
        if (null == content || "".equals(content)) {
            return 0;
        }
        return content.length() + InputTextActivity.getChineseNum(content);
    }

    public static int getChineseNum(String s) {
        int num = 0;
        char[] myChar = s.toCharArray();
        for (int i = 0; i < myChar.length; ++i) {
            if ((char)myChar[i] == myChar[i]) continue;
            ++num;
        }
        return num;
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.mDialogLinkManager != null && this.mDialogLinkManager.isDialogShowing()) {
            this.mDialogLinkManager.hideProgressDialog();
            this.mDialogLinkManager.dismissDialog();
        }
        this.mDialogLinkManager = null;
        this.unregisterEvent();
        Object var2_1 = null;
        if (this.mInputTextActivitySniperEventBinder != null) {
            this.mInputTextActivitySniperEventBinder.unBindEvent();
        }
    }
}

