/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.plugin.pluginunionpersonalcenter.subscribe;

import android.app.Activity;
import android.content.Context;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.ImageView;
import android.widget.TextView;
import com.yy.hiidostatis.defs.obj.Property;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.image.CircleImageView;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.plugin.pluginunionpersonalcenter.R;
import com.yy.mobile.plugin.pluginunionpersonalcenter.subscribe.UniversalCallback;
import com.yy.mobile.ui.home.FaceHelperFactory;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.statistic.IHiidoStatisticCore;
import com.yymobile.core.subscribe.AttentionFriendInfo;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class SubscribeYFriendAdapter
extends BaseAdapter {
    private static final String TAG = "SubscribeYFriendAdapter";
    private Activity context;
    private long uid;
    private boolean mode;
    private List<AttentionFriendInfo> mSubscribeList = new ArrayList<AttentionFriendInfo>();
    private boolean isMySelf = false;
    private UniversalCallback<Integer> onDataClearCallback;
    private Set<Integer> alreadyReportPosition = new HashSet<Integer>();

    public void setOnUniversalCallback(UniversalCallback<Integer> onDataClearCallback) {
        this.onDataClearCallback = onDataClearCallback;
    }

    public SubscribeYFriendAdapter(Activity context, long uid) {
        this.context = context;
        this.uid = uid;
    }

    public void setIsMySelf(boolean isMySelf) {
        this.isMySelf = isMySelf;
    }

    public void setData(List<AttentionFriendInfo> data) {
        this.mSubscribeList.clear();
        if (data != null && data.size() > 0) {
            this.mSubscribeList.addAll(data);
        }
        this.notifyDataSetChanged();
    }

    public void addData(List<AttentionFriendInfo> data) {
        if (data != null && data.size() > 0) {
            this.mSubscribeList.addAll(data);
        }
        this.notifyDataSetChanged();
    }

    public List<AttentionFriendInfo> getData() {
        return this.mSubscribeList;
    }

    public int getCount() {
        return this.mSubscribeList.size();
    }

    public Object getItem(int position) {
        if (position < this.mSubscribeList.size()) {
            return this.mSubscribeList.get(position);
        }
        return null;
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(final int position, View convertView, ViewGroup parent) {
        ViewHolder holder;
        if (convertView == null) {
            holder = new ViewHolder();
            convertView = LayoutInflater.from((Context)this.context).inflate(R.layout.personalcenter_layout_subscribe_yfriend_item, parent, false);
            holder.portraitIv = (CircleImageView)convertView.findViewById(R.id.iv_portrait);
            holder.nameTv = (TextView)convertView.findViewById(R.id.tv_name);
            holder.moreIv = (ImageView)convertView.findViewById(R.id.iv_more);
            holder.onLiveIv = (ImageView)convertView.findViewById(R.id.iv_on_live);
            holder.moreIv.setVisibility(this.isMySelf ? 0 : 8);
            convertView.setTag((Object)holder);
        } else {
            holder = (ViewHolder)convertView.getTag();
        }
        AttentionFriendInfo item = (AttentionFriendInfo)this.getItem(position);
        holder.moreIv.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (SubscribeYFriendAdapter.this.mSubscribeList != null && position < SubscribeYFriendAdapter.this.mSubscribeList.size()) {
                    AttentionFriendInfo attentionFriendInfo = (AttentionFriendInfo)SubscribeYFriendAdapter.this.mSubscribeList.get(position);
                    SubscribeYFriendAdapter.this.onDataClearCallback.onCallback(1, attentionFriendInfo);
                }
            }
        });
        try {
            if (item != null) {
                FaceHelperFactory.loadFace((String)item.portraitUrl, (int)item.portraitIndex, (FaceHelperFactory.FaceType)FaceHelperFactory.FaceType.FriendFace, (RecycleImageView)holder.portraitIv, (ImageConfig)ImageConfig.defaultImageConfig(), (int)R.drawable.default_portrait);
                holder.nameTv.setText((CharSequence)item.name);
                holder.onLiveIv.setVisibility(item.isLiving ? 0 : 8);
            }
        }
        catch (Throwable throwable) {
            MLog.error((Object)TAG, (Throwable)throwable);
        }
        if (!this.alreadyReportPosition.contains(position)) {
            this.alreadyReportPosition.add(position);
            Property property = new Property();
            property.putString("key1", item.topCid + "_" + item.uid + "_" + (position + 1) + "_" + item.token);
            ((IHiidoStatisticCore)CoreFactory.getCore(IHiidoStatisticCore.class)).sendEventStatistic(LoginUtil.getUid(), "50202", "0010");
        }
        return convertView;
    }

    public void onUnSubscribe(long anchorUid) {
        Iterator<AttentionFriendInfo> iterator = this.mSubscribeList.iterator();
        while (iterator.hasNext()) {
            AttentionFriendInfo info = iterator.next();
            if (info.uid != anchorUid) continue;
            iterator.remove();
            break;
        }
        this.notifyDataSetChanged();
        if (this.getCount() == 0) {
            this.onDataClearCallback.onCallback(0, null);
        }
    }

    private static class ViewHolder {
        CircleImageView portraitIv;
        TextView nameTv;
        ImageView moreIv;
        ImageView onLiveIv;

        private ViewHolder() {
        }
    }

    public static interface UnSubscribeBtnClickAction {
        public void onUnsubscribe(long var1);
    }
}

