/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.plugin.pluginunionpersonalcenter.fans;

import android.app.Activity;
import android.content.Context;
import android.support.v4.util.LongSparseArray;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.BaseAdapter;
import android.widget.TextView;
import com.yy.mobile.image.CircleImageView;
import com.yy.mobile.image.ImageConfig;
import com.yy.mobile.image.RecycleImageView;
import com.yy.mobile.plugin.pluginunionpersonalcenter.R;
import com.yy.mobile.ui.home.FaceHelperFactory;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.yyprotocol.core.Uint32;
import com.yymobile.core.user.UserInfo;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;

public class UserFansListAdapter
extends BaseAdapter {
    private Activity context;
    private List<UserInfo> mData = new ArrayList<UserInfo>();
    public Map<Long, Integer> isAnchorMap = new HashMap<Long, Integer>();
    public LongSparseArray<Uint32> fansNums = new LongSparseArray();
    public Map<Long, Uint32> authVMap = new HashMap<Long, Uint32>();

    public UserFansListAdapter(Activity context) {
        this.context = context;
    }

    public void addData(List<UserInfo> data) {
        if (data != null && data.size() > 0) {
            this.mData.addAll(data);
        }
        this.notifyDataSetChanged();
    }

    public void setData(List<UserInfo> data) {
        this.mData.clear();
        if (data != null && data.size() > 0) {
            this.mData.addAll(data);
        }
        this.notifyDataSetChanged();
    }

    public boolean isAnchor(long userId) {
        return this.isAnchorMap.get(userId) != null && this.isAnchorMap.get(userId) == 1;
    }

    public List<UserInfo> getData() {
        return this.mData;
    }

    public int getCount() {
        return this.mData.size();
    }

    public UserInfo getItem(int position) {
        return this.mData.get(position);
    }

    public long getItemId(int position) {
        return position;
    }

    public View getView(int position, View convertView, ViewGroup parent) {
        ViewHolder holder;
        if (convertView == null) {
            holder = new ViewHolder();
            convertView = LayoutInflater.from((Context)this.context).inflate(R.layout.personalcenter_layout_user_fanslist_item, parent, false);
            holder.portraitIv = (CircleImageView)convertView.findViewById(R.id.iv_portrait_headIcon);
            holder.portraitAuthVIv = (CircleImageView)convertView.findViewById(R.id.iv_portrait_authVIcon);
            holder.nameTv = (TextView)convertView.findViewById(R.id.tv_name);
            holder.fansNumTv = (TextView)convertView.findViewById(R.id.fans_num_txt);
            holder.anchorFlag = (TextView)convertView.findViewById(R.id.anchor_flag);
            convertView.setTag((Object)holder);
        } else {
            holder = (ViewHolder)convertView.getTag();
        }
        UserInfo info = this.getItem(position);
        if (info != null) {
            if (!StringUtils.isEmpty((String)info.nickName).booleanValue()) {
                holder.nameTv.setText((CharSequence)info.nickName);
            }
            FaceHelperFactory.loadFace((String)info.iconUrl, (int)info.iconIndex, (FaceHelperFactory.FaceType)FaceHelperFactory.FaceType.FriendFace, (RecycleImageView)holder.portraitIv, (ImageConfig)ImageConfig.defaultImageConfig(), (int)R.drawable.default_portrait);
            if (this.isAnchorMap.get(info.userId) != null && this.isAnchorMap.get(info.userId) == 1) {
                holder.anchorFlag.setVisibility(0);
            } else {
                holder.anchorFlag.setVisibility(8);
            }
            Uint32 fansNum = (Uint32)this.fansNums.get(info.userId);
            long fansNumValue = fansNum != null ? fansNum.longValue() : 0L;
            holder.fansNumTv.setText((CharSequence)String.format(Locale.CHINA, "\u7c89\u4e1d\u6570\uff1a%d", fansNumValue));
            Uint32 anchorV = this.authVMap.get(info.userId);
            if (anchorV != null) {
                if (anchorV.intValue() == 0) {
                    holder.portraitAuthVIv.setVisibility(8);
                } else if (anchorV.intValue() == 1) {
                    holder.portraitAuthVIv.setBackgroundResource(R.drawable.me_icon_vip);
                    holder.portraitAuthVIv.setVisibility(0);
                } else if (anchorV.intValue() == 2) {
                    holder.portraitAuthVIv.setBackgroundResource(R.drawable.common_portrait_auth_v_10);
                    holder.portraitAuthVIv.setVisibility(0);
                }
            } else {
                holder.portraitAuthVIv.setVisibility(8);
            }
        }
        return convertView;
    }

    public void updateFansNums(Map<Uint32, Uint32> fansNumsMap) {
        if (fansNumsMap != null && !fansNumsMap.isEmpty()) {
            for (Map.Entry<Uint32, Uint32> entry : fansNumsMap.entrySet()) {
                long uid = entry.getKey().longValue();
                Uint32 fansNum = entry.getValue();
                this.fansNums.put(uid, (Object)fansNum);
            }
            this.notifyDataSetChanged();
        }
    }

    private static class ViewHolder {
        CircleImageView portraitIv;
        CircleImageView portraitAuthVIv;
        TextView anchorFlag;
        TextView nameTv;
        TextView fansNumTv;

        private ViewHolder() {
        }
    }
}

