/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.utils;

import android.app.Activity;
import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Rect;
import android.os.Environment;
import android.view.View;
import com.yy.mobile.util.ResolutionUtils;
import com.yy.mobile.util.log.MLog;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.OutputStream;
import java.util.HashMap;
import java.util.Map;

public class ScreenShotUtils {
    private int screenWidth;
    private Bitmap bitmap1;
    private Bitmap bitmap2;
    private Bitmap combineBitmap;

    public Map<String, Bitmap> combineView(Activity activity, int height, View view) {
        this.bitmap1 = this.takeScreenShot(activity, height);
        this.bitmap2 = this.convertViewToBitmap(view);
        this.combineBitmap = this.combineBitmap(this.bitmap1, this.bitmap2);
        HashMap<String, Bitmap> bitmapMap = new HashMap<String, Bitmap>();
        bitmapMap.put("gallery_combine_photo_first", this.bitmap1);
        bitmapMap.put("gallery_combine_photo_final", this.combineBitmap);
        return bitmapMap;
    }

    public Bitmap combineView(View view1, View view2) {
        this.bitmap1 = this.convertViewToBitmap(view1);
        this.bitmap2 = this.convertViewToBitmap(view2);
        this.combineBitmap = this.combineBitmap(this.bitmap1, this.bitmap2);
        return this.combineBitmap;
    }

    public byte[] bitmap2Bytes(Bitmap bm) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        bm.compress(Bitmap.CompressFormat.PNG, 100, (OutputStream)baos);
        byte[] bytes = baos.toByteArray();
        try {
            baos.close();
        }
        catch (Throwable throwable) {
            MLog.error((Object)"zy", (String)"bitmap2Bytes IO EXCEPTION", (Object[])new Object[0]);
        }
        return bytes;
    }

    private Bitmap takeScreenShot(Activity activity, int viewHeight) {
        View view = activity.getWindow().getDecorView();
        view.setDrawingCacheEnabled(true);
        view.buildDrawingCache();
        Bitmap b1 = view.getDrawingCache();
        Rect frame = new Rect();
        activity.getWindow().getDecorView().getWindowVisibleDisplayFrame(frame);
        int statusBarHeight = frame.top;
        this.screenWidth = ResolutionUtils.getScreenWidth((Context)activity);
        Bitmap b = Bitmap.createBitmap((Bitmap)b1, (int)0, (int)statusBarHeight, (int)this.screenWidth, (int)viewHeight);
        if (!b.equals(b1)) {
            b1.recycle();
        }
        view.destroyDrawingCache();
        return b;
    }

    private Bitmap combineBitmap(Bitmap bitmap1, Bitmap bitmap2) {
        if (bitmap1 == null) {
            return null;
        }
        int bit1Width = bitmap1.getWidth();
        int bit1Height = bitmap1.getHeight();
        int bit2Width = bitmap2.getWidth();
        int bit2Height = bitmap2.getHeight();
        Bitmap newbmp = Bitmap.createBitmap((int)bit2Width, (int)(bit1Height + bit2Height), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        Canvas cv = new Canvas(newbmp);
        cv.drawBitmap(bitmap1, 0.0f, 0.0f, null);
        cv.drawBitmap(bitmap2, 0.0f, (float)bit1Height, null);
        cv.save();
        cv.restore();
        return newbmp;
    }

    public Bitmap convertViewToBitmap(View view) {
        view.setDrawingCacheEnabled(true);
        view.buildDrawingCache();
        Bitmap bitmap = view.getDrawingCache();
        return bitmap;
    }

    public Bitmap screenTwoViewToBitmap(View view1, View view2) {
        boolean hasSDCard = Environment.getExternalStorageState().equals("mounted");
        if (hasSDCard) {
            String filePath = Environment.getExternalStorageDirectory().toString() + File.separator + String.valueOf(System.currentTimeMillis()) + ".png";
        } else {
            String filePath = Environment.getDownloadCacheDirectory().toString() + File.separator + String.valueOf(System.currentTimeMillis()) + ".png";
        }
        Bitmap bitmap1 = this.convertViewToBitmap(view1);
        Bitmap bitmap2 = this.convertViewToBitmap(view2);
        Bitmap combineBitmap = this.combineBitmap(bitmap1, bitmap2);
        return combineBitmap;
    }

    public Bitmap combineTwoBitmap(Bitmap bitmap1, Bitmap bitmap2) {
        boolean hasSDCard = Environment.getExternalStorageState().equals("mounted");
        if (hasSDCard) {
            String filePath = Environment.getExternalStorageDirectory().toString() + File.separator + String.valueOf(System.currentTimeMillis()) + ".png";
        } else {
            String filePath = Environment.getDownloadCacheDirectory().toString() + File.separator + String.valueOf(System.currentTimeMillis()) + ".png";
        }
        Bitmap combineBitmap = this.combineBitmap(bitmap1, bitmap2);
        return combineBitmap;
    }

    public Bitmap simpleConvertViewToBitmap(View view) {
        view.buildDrawingCache();
        Bitmap bitmap = view.getDrawingCache();
        return bitmap;
    }

    public Bitmap convertViewToBitmap(View view, int bitmapWidth, int bitmapHeight) {
        Bitmap bitmap = Bitmap.createBitmap((int)bitmapWidth, (int)bitmapHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        view.draw(new Canvas(bitmap));
        return bitmap;
    }
}

