/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.channel;

import android.content.Context;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import com.yy.mobile.plugin.pluginunionmain.R;
import com.yy.mobile.ui.channel.CommonAdapter;
import java.io.Serializable;

public class DayOfMonthGridAdapter
extends CommonAdapter<SignDayInfo> {
    public static final int DISPLAY_TYPE_EMPTY = 0;
    public static final int DISPLAY_TYPE_NORMAL = 1;

    public DayOfMonthGridAdapter(Context context) {
        super(context);
    }

    @Override
    public View createConverView(ViewGroup parent) {
        ViewHolder viewHolder = new ViewHolder();
        View view = this.mInflater.inflate(R.layout.item_sign_day_of_month, parent, false);
        viewHolder.mTextDay = (TextView)view.findViewById(R.id.text_day_of_month);
        viewHolder.mImgSign = (ImageView)view.findViewById(R.id.img_sign);
        view.setTag((Object)viewHolder);
        return view;
    }

    @Override
    public void setItem(int position, View convertView, ViewGroup parent) {
        SignDayInfo item = (SignDayInfo)this.mData.get(position);
        ViewHolder viewHolder = (ViewHolder)convertView.getTag();
        switch (item.displayType) {
            case 0: {
                viewHolder.mTextDay.setText((CharSequence)"");
                break;
            }
            case 1: {
                viewHolder.mTextDay.setText((CharSequence)item.dayOfMonth);
                break;
            }
        }
        if (item.isSign) {
            viewHolder.mImgSign.setVisibility(0);
            viewHolder.mTextDay.setTextColor(this.mContext.getResources().getColor(R.color.sign_day_text_color));
        } else {
            viewHolder.mImgSign.setVisibility(8);
            viewHolder.mTextDay.setTextColor(this.mContext.getResources().getColor(R.color.unsign_day_text_color));
        }
    }

    public SignDayInfo getEmptyInfo() {
        SignDayInfo info = new SignDayInfo();
        info.displayType = 0;
        info.isSign = false;
        return info;
    }

    static class ViewHolder {
        TextView mTextDay;
        ImageView mImgSign;

        ViewHolder() {
        }
    }

    static class SignDayInfo
    implements Serializable {
        public int displayType;
        public String dayOfMonth;
        public boolean isSign;

        SignDayInfo() {
        }
    }
}

