/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.utils.js.v2.v2ApiModule;

import android.content.Context;
import android.text.TextUtils;
import com.yy.mobile.RxBus;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.plugin.main.events.IAuthClient_onKickOff_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_leaveCurrentChannel_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_onCurrentMultiKick_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_onJoinChannelSuccess_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_onRequestJoinChannelError_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_onRequestJoinChannelExist_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_updateCurrentChannelInfo_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelLinkClient_updateCurrentChannelMicQueue_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelMicStateClient_channelMicStateControlMic_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelMicStateClient_channelMicStateDisable_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelMicStateClient_channelMicStateMicTurn_EventArgs;
import com.yy.mobile.plugin.main.events.IChannelMicStateClient_channelMicaddMicOperaFailed_EventArgs;
import com.yy.mobile.plugin.main.events.IWebViewClient_requestFinishActivity_EventArgs;
import com.yy.mobile.sdkwrapper.yylive.LiveProtocol;
import com.yy.mobile.sdkwrapper.yylive.event.JoinTimeoutEventArgs;
import com.yy.mobile.sdkwrapper.yylive.event.KickOffnotifyEventArgs;
import com.yy.mobile.sdkwrapper.yylive.event.MicStatusChangeEventArgs;
import com.yy.mobile.sdkwrapper.yylive.event.MicStatusChangeEventArgsWrapper;
import com.yy.mobile.sdkwrapper.yylive.event.MicStatusOperFailedEventArgs;
import com.yy.mobile.sdkwrapper.yylive.event.MicStatusTimeoutEventArgs;
import com.yy.mobile.sdkwrapper.yylive.event.MultiKickOffNotifyEventArgs;
import com.yy.mobile.sdkwrapper.yylive.event.MultiKickOffResEventArgs;
import com.yy.mobile.ui.utils.js.v2.v2ApiModule.BaseApiModule;
import com.yy.mobile.ui.webactivity.webviewbussiness.IAlertDialogCallBack;
import com.yy.mobile.util.RxUtils;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.javascript.apiModule.IApiModule;
import com.yy.mobile.util.json.JsonParser;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.CoreError;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.basechannel.IChannelLinkCore;
import com.yymobile.core.basechannel.SessMultiKick;
import com.yymobile.core.channel.ChannelInfo;
import com.yymobile.core.media.IMediaCore;
import io.reactivex.disposables.CompositeDisposable;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import io.reactivex.functions.Predicate;
import java.util.List;
import java.util.Locale;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ChannelModule
extends BaseApiModule {
    public IDataCallback mCallback;
    private CompositeDisposable mCompositeDisposable;
    public boolean isMute = false;
    public ChannelInfo mCurrentChannelInfo;
    private long mCurrentChannelTopSid = 0L;
    private static RxBus rxBus = RxBus.create((int)128, (String)"JavascriptAPI");
    public IApiModule.IApiMethod switchVoice = new IApiModule.IApiMethod(){

        public String methodName() {
            return "switchVoice";
        }

        public String invoke(String param, IApiModule.IJSCallback callback, Context activity) {
            if (MLog.isLogLevelAboveDebug()) {
                MLog.debug((Object)"ChannelModule", (String)("switchVoice param = " + param), (Object[])new Object[0]);
            }
            if (param != null) {
                try {
                    JSONObject jsonObject = new JSONObject(param);
                    String enable = jsonObject.optString("enable");
                    if (!TextUtils.isEmpty((CharSequence)enable)) {
                        IMediaCore mediaCore = ICoreManagerBase.getMediaCore();
                        if (mediaCore != null) {
                            mediaCore.switchVoice(!enable.equals("0"));
                        }
                        return JsonParser.toJson((Object)"ok");
                    }
                    return JsonParser.toJson((Object)"param error");
                }
                catch (Throwable e) {
                    MLog.error((Object)"ChannelModule", (String)("switchVoice error=" + e), (Object[])new Object[0]);
                    return JsonParser.toJson((Object)"error");
                }
            }
            if (callback != null) {
                callback.invokeCallback("'" + JsonParser.toJson((Object)"error") + "'");
            }
            return JsonParser.toJson((Object)"error");
        }
    };
    public IApiModule.IApiMethod getChannelInfo = new IApiModule.IApiMethod(){

        public String methodName() {
            return "getChannelInfo";
        }

        public String invoke(String param, IApiModule.IJSCallback callback, Context activity) {
            ChannelInfo channel = ICoreManagerBase.getChannelLinkCore().getCurrentChannelInfo();
            String ret = String.format(Locale.CHINA, "'{\"subsid\":\"%s\"}'", channel.subSid);
            callback.invokeCallback(ret);
            return ret;
        }
    };
    public IApiModule.IApiMethod joinMaixu = new IApiModule.IApiMethod(){

        public String methodName() {
            return "joinMaixu";
        }

        public String invoke(String param, IApiModule.IJSCallback callback, Context activity) {
            if (ChannelModule.this.mCurrentChannelInfo != null && ChannelModule.this.mCurrentChannelInfo.isDisableMic) {
                ChannelModule.this.doJSCallback("errorInfo", ChannelModule.this.newJSErrorObject(2, "\u5f53\u524d\u6a21\u5f0f\u4e0d\u80fd\u8bf4\u8bdd"));
            }
            ICoreManagerBase.getChannelLinkCore().sessMicJoinReq();
            callback.invokeCallback(ChannelModule.this.newJSResponseString(0, ""));
            return null;
        }
    };
    public IApiModule.IApiMethod openMic = new IApiModule.IApiMethod(){

        public String methodName() {
            return "openMic";
        }

        public String invoke(String param, IApiModule.IJSCallback callback, Context activity) {
            ChannelModule.this.doOpenMic();
            callback.invokeCallback(ChannelModule.this.newJSResponseString(0, ""));
            return null;
        }
    };
    public IApiModule.IApiMethod closeMic = new IApiModule.IApiMethod(){

        public String methodName() {
            return "closeMic";
        }

        public String invoke(String param, IApiModule.IJSCallback callback, Context activity) {
            ChannelModule.this.doCloseMic();
            callback.invokeCallback(ChannelModule.this.newJSResponseString(0, ""));
            return null;
        }
    };
    public IApiModule.IApiMethod getMicStateTime = new IApiModule.IApiMethod(){

        public String methodName() {
            return "getMicStateTime";
        }

        public String invoke(String param, IApiModule.IJSCallback callback, Context activity) {
            ChannelModule.this.onMicStateChanged();
            return null;
        }
    };
    public IApiModule.IApiMethod joinChannel = new IApiModule.IApiMethod(){

        public String methodName() {
            return "joinChannel";
        }

        public String invoke(String param, IApiModule.IJSCallback callback, Context activity) {
            MLog.debug((Object)"ChannelModule", (String)"method=%s,param=%s", (Object[])new Object[]{"joinChannel", param});
            if (!TextUtils.isEmpty((CharSequence)param)) {
                try {
                    JSONObject obj = new JSONObject(param);
                    ChannelModule.this.doJoinChannel(StringUtils.string2long((String)obj.optString("sid"), (long)0L), StringUtils.string2long((String)obj.optString("subsid"), (long)0L));
                }
                catch (JSONException e) {
                    MLog.debug((Object)"ChannelModule", (String)"%s", (Object[])new Object[]{e.getMessage()});
                }
            }
            return null;
        }
    };
    public IApiModule.IApiMethod leaveChannel = new IApiModule.IApiMethod(){

        public String methodName() {
            return "leaveChannel";
        }

        public String invoke(String param, IApiModule.IJSCallback callback, Context activity) {
            ChannelModule.this.doLeaveChannel();
            callback.invokeCallback(ChannelModule.this.newJSResponseString(0, ""));
            return null;
        }
    };

    public ChannelModule() {
    }

    public ChannelModule(IDataCallback callback) {
        this.mCallback = callback;
    }

    @Override
    public void onEventBind() {
    }

    @Override
    public void onEventUnBind() {
        this.unSubscribeChannelEvents();
        this.autoLeaveChannel();
    }

    @Override
    public String moduleName() {
        return "channel";
    }

    @Override
    public Context getContext() {
        return null;
    }

    public JSONObject newJSErrorObject(int code, String message) {
        JSONObject error = new JSONObject();
        try {
            error.put("code", code);
            error.put("message", (Object)message);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return error;
    }

    public void autoLeaveChannel() {
        if (this.mCurrentChannelTopSid > 0L) {
            LiveProtocol.Factory.get().release();
            ChannelInfo info = ICoreManagerBase.getChannelLinkCore().getCurrentChannelInfo();
            if (info != null && info.topSid == this.mCurrentChannelTopSid) {
                this.doLeaveChannel();
            }
        }
    }

    public String newJSResponseString(int code, String message) {
        return String.format("'%s'", this.newJSErrorObject(code, message).toString());
    }

    private void subscribeChannelEvents(final long topSid, final long subSid) {
        LiveProtocol.Factory.get().initEventHandler(rxBus);
        this.mCurrentChannelTopSid = topSid;
        if (this.mCompositeDisposable != null) {
            this.mCompositeDisposable.clear();
        }
        this.mCompositeDisposable = new CompositeDisposable();
        this.mCompositeDisposable.addAll(new Disposable[]{RxBus.getDefault().register(IWebViewClient_requestFinishActivity_EventArgs.class).subscribe((Consumer)new Consumer<IWebViewClient_requestFinishActivity_EventArgs>(){

            public void accept(IWebViewClient_requestFinishActivity_EventArgs args) throws Exception {
                ChannelModule.this.autoLeaveChannel();
            }
        }, RxUtils.errorConsumer((String)"ChannelModule")), RxBus.getDefault().register(IChannelLinkClient_onJoinChannelSuccess_EventArgs.class).filter((Predicate)new Predicate<IChannelLinkClient_onJoinChannelSuccess_EventArgs>(){

            public boolean test(IChannelLinkClient_onJoinChannelSuccess_EventArgs args) throws Exception {
                ChannelInfo info = args.getInfo();
                return info != null && info.topSid == topSid;
            }
        }).subscribe((Consumer)new Consumer<IChannelLinkClient_onJoinChannelSuccess_EventArgs>(){

            public void accept(IChannelLinkClient_onJoinChannelSuccess_EventArgs args) throws Exception {
                ChannelInfo info = args.getInfo();
                if (ChannelModule.this.mCallback != null && info != null) {
                    JSONObject params = new JSONObject();
                    params.put("sid", (Object)String.valueOf(info.topSid));
                    params.put("subsid", (Object)String.valueOf(info.subSid));
                    ChannelModule.this.mCallback.invokeJSCallback("subChannelChanged", params);
                }
            }
        }, RxUtils.errorConsumer((String)"ChannelModule")), RxBus.getDefault().register(IChannelLinkClient_leaveCurrentChannel_EventArgs.class).subscribe((Consumer)new Consumer<IChannelLinkClient_leaveCurrentChannel_EventArgs>(){

            public void accept(IChannelLinkClient_leaveCurrentChannel_EventArgs args) throws Exception {
                ChannelInfo info = args.getInfo();
                if (info != null && info.topSid == topSid) {
                    ChannelModule.this.onMicStateChanged();
                }
            }
        }, RxUtils.errorConsumer((String)"ChannelModule")), RxBus.getDefault().register(IChannelLinkClient_onRequestJoinChannelExist_EventArgs.class).filter((Predicate)new Predicate<IChannelLinkClient_onRequestJoinChannelExist_EventArgs>(){

            public boolean test(IChannelLinkClient_onRequestJoinChannelExist_EventArgs args) throws Exception {
                ChannelInfo info = args.getChannelInfo();
                return info != null && info.topSid == topSid;
            }
        }).subscribe((Consumer)new Consumer<IChannelLinkClient_onRequestJoinChannelExist_EventArgs>(){

            public void accept(IChannelLinkClient_onRequestJoinChannelExist_EventArgs args) throws Exception {
                if (args.getError() != null && ChannelModule.this.mCallback != null) {
                    CoreError error = args.getError();
                    ChannelModule.this.mCallback.invokeJSCallback("errorInfo", ChannelModule.this.newJSErrorObject(1, error.message));
                }
            }
        }, RxUtils.errorConsumer((String)"ChannelModule")), RxBus.getDefault().register(IChannelLinkClient_onRequestJoinChannelError_EventArgs.class).subscribe((Consumer)new Consumer<IChannelLinkClient_onRequestJoinChannelError_EventArgs>(){

            public void accept(IChannelLinkClient_onRequestJoinChannelError_EventArgs args) throws Exception {
                CoreError error = args.getError();
                if (error != null && error.code != 19) {
                    ChannelModule.this.doJSCallback("errorInfo", ChannelModule.this.newJSErrorObject(1, error.message));
                }
            }
        }, RxUtils.errorConsumer((String)"ChannelModule")), RxBus.getDefault().register(IChannelLinkClient_updateCurrentChannelMicQueue_EventArgs.class).subscribe((Consumer)new Consumer<IChannelLinkClient_updateCurrentChannelMicQueue_EventArgs>(){

            public void accept(IChannelLinkClient_updateCurrentChannelMicQueue_EventArgs args) throws Exception {
                List uids;
                if (ChannelModule.this.mCallback != null && (uids = args.getMicList()) != null) {
                    JSONArray list = new JSONArray();
                    for (Long uid : uids) {
                        JSONObject item = new JSONObject();
                        item.put("uid", (Object)String.valueOf(uid));
                        list.put((Object)item);
                    }
                    JSONObject params = new JSONObject();
                    params.put("uidlist", (Object)list);
                    ChannelModule.this.mCallback.invokeJSCallback("maiXuChanged", params);
                }
            }
        }, RxUtils.errorConsumer((String)"ChannelModule")), RxBus.getDefault().register(IChannelLinkClient_updateCurrentChannelInfo_EventArgs.class).subscribe((Consumer)new Consumer<IChannelLinkClient_updateCurrentChannelInfo_EventArgs>(){

            public void accept(IChannelLinkClient_updateCurrentChannelInfo_EventArgs args) throws Exception {
                ChannelInfo info = args.getChannelInfo();
                if (info != null) {
                    ChannelModule.this.mCurrentChannelInfo = info;
                    if (info.topSid == topSid && info.subSid != subSid) {
                        JSONObject params = new JSONObject();
                        params.put("sid", (Object)String.valueOf(info.topSid));
                        params.put("subsid", (Object)String.valueOf(info.subSid));
                        ChannelModule.this.doJSCallback("subChannelChanged", params);
                    } else if (info.topSid != topSid) {
                        ChannelModule.this.doJSCallback("errorInfo", ChannelModule.this.newJSErrorObject(4, "\u8fdb\u5165\u4e86\u5176\u4ed6\u9891\u9053"));
                    }
                }
            }
        }, RxUtils.errorConsumer((String)"ChannelModule")), RxBus.getDefault().register(IChannelMicStateClient_channelMicStateControlMic_EventArgs.class).subscribe((Consumer)new Consumer<IChannelMicStateClient_channelMicStateControlMic_EventArgs>(){

            public void accept(IChannelMicStateClient_channelMicStateControlMic_EventArgs args) throws Exception {
                ChannelInfo info = args.getChannelInfo();
                if (info != null && info.topSid == topSid) {
                    ChannelModule.this.isMute = args.getIsControlMicMic();
                    ChannelModule.this.onMicStateChanged(args.getTime());
                }
            }
        }, RxUtils.errorConsumer((String)"ChannelModule")), RxBus.getDefault().register(IChannelMicStateClient_channelMicStateDisable_EventArgs.class).subscribe((Consumer)new Consumer<IChannelMicStateClient_channelMicStateDisable_EventArgs>(){

            public void accept(IChannelMicStateClient_channelMicStateDisable_EventArgs args) throws Exception {
                ChannelInfo info = args.getChannelInfo();
                if (info != null && info.topSid == topSid) {
                    ChannelModule.this.mCurrentChannelInfo = info;
                }
            }
        }, RxUtils.errorConsumer((String)"ChannelModule")), RxBus.getDefault().register(IChannelMicStateClient_channelMicaddMicOperaFailed_EventArgs.class).filter((Predicate)new Predicate<IChannelMicStateClient_channelMicaddMicOperaFailed_EventArgs>(){

            public boolean test(IChannelMicStateClient_channelMicaddMicOperaFailed_EventArgs args) throws Exception {
                return args.getChannelInfo() != null && args.getChannelInfo().topSid == topSid;
            }
        }).subscribe((Consumer)new Consumer<IChannelMicStateClient_channelMicaddMicOperaFailed_EventArgs>(){

            public void accept(IChannelMicStateClient_channelMicaddMicOperaFailed_EventArgs args) throws Exception {
                if (ChannelModule.this.mCallback != null) {
                    ChannelModule.this.mCallback.invokeJSCallback("errorInfo", ChannelModule.this.newJSErrorObject(2, "\u52a0\u5165\u9ea6\u5e8f\u5931\u8d25"));
                }
            }
        }, RxUtils.errorConsumer((String)"ChannelModule")), RxBus.getDefault().register(IChannelMicStateClient_channelMicStateMicTurn_EventArgs.class).subscribe((Consumer)new Consumer<IChannelMicStateClient_channelMicStateMicTurn_EventArgs>(){

            public void accept(IChannelMicStateClient_channelMicStateMicTurn_EventArgs args) throws Exception {
                ChannelInfo info = args.getChannelInfo();
                if (info != null && info.topSid == topSid) {
                    ChannelModule.this.onMicStateChanged(args.getTime());
                }
            }
        }, RxUtils.errorConsumer((String)"ChannelModule")), RxBus.getDefault().register(IAuthClient_onKickOff_EventArgs.class).subscribe((Consumer)new Consumer<IAuthClient_onKickOff_EventArgs>(){

            public void accept(IAuthClient_onKickOff_EventArgs args) throws Exception {
                ChannelModule.this.doJSCallback("errorInfo", ChannelModule.this.newJSErrorObject(6, "\u5728\u53e6\u4e00\u53f0\u7ec8\u7aef\u767b\u5f55"));
            }
        }, RxUtils.errorConsumer((String)"ChannelModule")), RxBus.getDefault().register(IChannelLinkClient_onCurrentMultiKick_EventArgs.class).subscribe((Consumer)new Consumer<IChannelLinkClient_onCurrentMultiKick_EventArgs>(){

            public void accept(IChannelLinkClient_onCurrentMultiKick_EventArgs args) throws Exception {
                if (ChannelModule.this.mCallback != null) {
                    final SessMultiKick kick = args.getKick();
                    ChannelModule.this.mCallback.showDialog("\u4f60\u5728\u5176\u4ed6\u8bbe\u5907\u4e0a\u5df2\u767b\u5f55\u9891\u9053\uff0c\u662f\u5426\u786e\u8ba4\u624b\u673a\u7aef\u8fdb\u5165\u9891\u9053\uff0c\u5e76\u5c06\u5176\u4ed6\u8bbe\u5907\u8e22\u51fa\u9891\u9053\uff1f", new IAlertDialogCallBack(){

                        @Override
                        public void onPositiveButtonClicked() {
                            MLog.info((Object)"ChannelModule", (String)"onCurrentMultiKick onOk et.sid = ", (Object[])new Object[0]);
                            ICoreManagerBase.getChannelLinkCore().joinChannelByKickMulti(kick.getTopSid(), 0L, kick, "3", null);
                        }

                        @Override
                        public void onMiddleButtonClicked() {
                        }

                        @Override
                        public void onNegativeButtonClicked() {
                            MLog.debug((Object)"ChannelModule", (String)"onNegativeButtonClicked", (Object[])new Object[0]);
                            ChannelModule.this.doLeaveChannel();
                        }
                    });
                }
            }
        }, RxUtils.errorConsumer((String)"ChannelModule")), rxBus.register(MicStatusOperFailedEventArgs.class).subscribe((Consumer)new Consumer<MicStatusOperFailedEventArgs>(){

            public void accept(MicStatusOperFailedEventArgs args) throws Exception {
                ChannelModule.this.doJSCallback("errorInfo", ChannelModule.this.newJSErrorObject(3, ""));
            }
        }, RxUtils.errorConsumer((String)"ChannelModule")), rxBus.register(JoinTimeoutEventArgs.class).subscribe((Consumer)new Consumer<JoinTimeoutEventArgs>(){

            public void accept(JoinTimeoutEventArgs args) throws Exception {
                ChannelModule.this.doJSCallback("errorInfo", ChannelModule.this.newJSErrorObject(1, ""));
            }
        }, RxUtils.errorConsumer((String)"ChannelModule")), rxBus.register(MultiKickOffNotifyEventArgs.class).subscribe((Consumer)new Consumer<MultiKickOffNotifyEventArgs>(){

            public void accept(MultiKickOffNotifyEventArgs args) throws Exception {
                if (args.getTopSid() == topSid) {
                    ChannelModule.this.doJSCallback("errorInfo", ChannelModule.this.newJSErrorObject(5, "\u88ab\u5176\u4ed6\u9891\u9053\u6324\u51fa"));
                }
            }
        }, RxUtils.errorConsumer((String)"ChannelModule")), rxBus.register(MultiKickOffResEventArgs.class).subscribe((Consumer)new Consumer<MultiKickOffResEventArgs>(){

            public void accept(MultiKickOffResEventArgs args) throws Exception {
                ChannelModule.this.doJSCallback("errorInfo", ChannelModule.this.newJSErrorObject(7, "\u5df2\u7ecf\u8fdb\u5165\u4e86\u5176\u4ed6\u9891\u9053"));
            }
        }, RxUtils.errorConsumer((String)"ChannelModule")), rxBus.register(KickOffnotifyEventArgs.class).subscribe((Consumer)new Consumer<KickOffnotifyEventArgs>(){

            public void accept(KickOffnotifyEventArgs args) throws Exception {
                ChannelModule.this.doJSCallback("errorInfo", ChannelModule.this.newJSErrorObject(5, "\u5df2\u7ecf\u88ab\u8e22\u51fa\u9891\u9053"));
            }
        }, RxUtils.errorConsumer((String)"ChannelModule")), rxBus.register(MicStatusChangeEventArgsWrapper.class).subscribe((Consumer)new Consumer<MicStatusChangeEventArgsWrapper>(){

            public void accept(MicStatusChangeEventArgsWrapper args) throws Exception {
                MicStatusTimeoutEventArgs data;
                MicStatusChangeEventArgs event = args.getArgs();
                if (event.getmMicEvtType() == 9 && (data = (MicStatusTimeoutEventArgs)event).getUid() == LoginUtil.getUid()) {
                    ChannelModule.this.onMicStateChanged(0L);
                }
            }
        }, RxUtils.errorConsumer((String)"ChannelModule"))});
    }

    private void unSubscribeChannelEvents() {
        if (this.mCompositeDisposable != null) {
            this.mCompositeDisposable.clear();
            this.mCompositeDisposable = null;
        }
    }

    public void doLeaveChannel() {
        ((IChannelLinkCore)ICoreManagerBase.getCore(IChannelLinkCore.class)).leaveChannel();
    }

    public void doJoinChannel(long topSid, long subSid) {
        this.subscribeChannelEvents(topSid, subSid);
        ChannelInfo info = ICoreManagerBase.getChannelLinkCore().getCurrentChannelInfo();
        if (info == null || info.topSid != topSid || info.subSid != subSid) {
            ICoreManagerBase.getChannelLinkCore().joinChannel(topSid, subSid, "", null);
        }
    }

    public void doOpenMic() {
    }

    public void doCloseMic() {
    }

    public void doJSCallback(String fn, JSONObject params) {
        if (this.mCallback != null) {
            this.mCallback.invokeJSCallback(fn, params);
        }
    }

    public void onMicStateChanged() {
        this.onMicStateChanged(ICoreManagerBase.getChannelLinkCore().getTopMicIntervall());
    }

    public void onMicStateChanged(long time) {
        long uid = LoginUtil.getUid();
        long topMicId = ICoreManagerBase.getChannelLinkCore().getCurrentTopMicId();
        boolean isMicQueueEmpty = topMicId == 0L;
        int isMicFree = this.isMute ? 0 : 1;
        JSONObject params = new JSONObject();
        try {
            params.put("maixuState", isMicFree);
            params.put("maixuTime", isMicQueueEmpty ? 0L : time);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        this.doJSCallback("micStateChanged", params);
        if (isMicFree == 1 && topMicId == uid && !ICoreManagerBase.getChannelLinkCore().isOpenMic()) {
            this.doOpenMic();
        } else {
            this.doCloseMic();
        }
    }

    public static interface IDataCallback {
        public void invokeJSCallback(String var1, JSONObject var2);

        public void showDialog(String var1, IAlertDialogCallBack var2);
    }

    public static interface JSCallbacks {
    }

    public static interface Methods {
    }
}

