/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.utils.js.bridge;

import android.annotation.SuppressLint;
import android.annotation.TargetApi;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.AssetManager;
import android.graphics.Bitmap;
import android.net.Uri;
import android.net.http.SslError;
import android.os.Build;
import android.text.TextUtils;
import android.view.View;
import android.webkit.ConsoleMessage;
import android.webkit.MimeTypeMap;
import android.webkit.SslErrorHandler;
import android.webkit.ValueCallback;
import android.webkit.WebChromeClient;
import android.webkit.WebView;
import android.webkit.WebViewClient;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.model.store.HostState;
import com.yy.mobile.model.store.HostStore;
import com.yy.mobile.ui.activity.GlobalActivityManager;
import com.yy.mobile.ui.utils.dialog.BaseDialog;
import com.yy.mobile.ui.utils.dialog.DialogLinkManager;
import com.yy.mobile.ui.utils.dialog.OkCancelDialog;
import com.yy.mobile.ui.utils.dialog.OkCancelDialogListener;
import com.yy.mobile.ui.utils.js.bridge.IBridgeClient;
import com.yy.mobile.ui.utils.js.bridge.IJavascriptCallback;
import com.yy.mobile.ui.utils.js.bridge.INativeHandler;
import com.yy.mobile.ui.utils.js.bridge.JSBridge;
import com.yy.mobile.ui.utils.js.bridge.UploadMessage;
import com.yy.mobile.util.AssetsUtils;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.VersionUtil;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.taskexecutor.YYTaskExecutor;
import java.lang.ref.WeakReference;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import org.json.JSONArray;
import org.json.JSONObject;

@SuppressLint(value={"SetJavaScriptEnabled"})
public class WVJSBridgeClient
extends WebViewClient
implements IBridgeClient {
    private WeakReference<WebView> mWebViewHolder;
    private String mCurrentURLString = "";
    private long uniqueId = 1L;
    private HashMap<String, IJavascriptCallback> mResponseCallbacks = new HashMap();
    private HashMap<String, INativeHandler> mMessageHandlers = new HashMap();
    private ArrayList<JSONObject> mStartupMessageQueue = null;
    private boolean mInsertJS = false;
    public boolean ignoreSslError = false;
    private static String JSBridgeScript = AssetsUtils.getStringFromFile((AssetManager)BasicConfig.getInstance().getAppContext().getAssets(), (String)"WebViewJavascriptBridge.js", (String)"UTF-8");

    public static String defaultUserAgentString() {
        return "Mozilla/5.0 (Linux; Android 4.4; Nexus 4 Build/KRT16H) AppleWebKit/537.36 (KHTML, like Gecko) Version/4.0 Chrome/30.0.0.0 Mobile Safari/537.36";
    }

    public static String sharedVersionString() {
        VersionUtil.Ver ver = VersionUtil.getLocalVer((Context)BasicConfig.getInstance().getAppContext());
        String edition = "yymand";
        if (HostStore.INSTANCE != null && HostStore.INSTANCE.getState() != null) {
            edition = ((HostState)HostStore.INSTANCE.getState()).getAppId();
        }
        return " YY(ClientVersion:" + ver.getVersionNameWithoutSnapshot() + ",ClientVerCode:" + ver.toString() + "\uff0cClientEdition:" + edition + ")";
    }

    public WVJSBridgeClient(WebView webView, String url) {
        if (webView != null) {
            this.mWebViewHolder = new WeakReference<WebView>(webView);
            JSBridge bridge = new JSBridge(this);
            webView.addJavascriptInterface((Object)bridge, "wvJSBridgeObject");
            if (!MLog.isLogLevelAboveVerbose()) {
                MLog.verbose((Object)"WVJSBridgeClient", (String)("WVJSBridgeClient addJavascriptInterface wvJSBridgeObject, webView=" + webView + ",----bridge=" + bridge + ",----url=" + url), (Object[])new Object[0]);
            }
        } else {
            MLog.error((Object)"WVJSBridgeClient", (String)"WVJSBridgeClient must create with a webview not nullable.", (Object[])new Object[0]);
        }
    }

    public void send(Object message) {
        this.send(message, null);
    }

    public void send(Object message, IJavascriptCallback callback) {
        this.sendData(message, callback, null);
    }

    public void registerHandler(String handlerName, INativeHandler handler) {
        this.mMessageHandlers.put(handlerName, handler);
    }

    public void unregisterhndler(String handlerName) {
        this.mMessageHandlers.remove(handlerName);
    }

    public void destory() {
        WebView view = (WebView)this.mWebViewHolder.get();
        if (view != null) {
            if (!MLog.isLogLevelAboveVerbose()) {
                MLog.verbose((Object)"WVJSBridgeClient", (String)("WVJSBridgeClient removeJavascriptInterface. view=" + view), (Object[])new Object[0]);
            }
            WVJSBridgeClient.removeJavascriptInterface(view, "wvJSBridgeObject");
            this.mWebViewHolder.clear();
        }
        this.mMessageHandlers.clear();
        this.mResponseCallbacks.clear();
        if (this.mStartupMessageQueue != null) {
            this.mStartupMessageQueue.clear();
        }
    }

    public void jsHandlerNotFound(String callbackId, String handlerName) {
        if (!MLog.isLogLevelAboveVerbose()) {
            MLog.verbose((Object)"WVJSBridgeClient", (String)("xuwakao, jsHandlerNotFound callbackId =  " + callbackId + ", handlerName = " + handlerName), (Object[])new Object[0]);
        }
        if (this.mResponseCallbacks.containsKey(callbackId)) {
            IJavascriptCallback callback = this.mResponseCallbacks.get(callbackId);
            callback.onJsHandlerNotFound(callbackId, handlerName);
        }
    }

    public void callHandler(String handlerName) {
        this.callHandler(handlerName, null);
    }

    public void callHandler(String handlerName, Object data) {
        this.callHandler(handlerName, data, null);
    }

    public void callHandler(String handlerName, Object data, IJavascriptCallback callback) {
        this.sendData(data, callback, handlerName);
    }

    public void reset() {
        if (this.mStartupMessageQueue != null) {
            this.mStartupMessageQueue.clear();
        }
        this.mStartupMessageQueue = new ArrayList();
        this.mResponseCallbacks.clear();
        this.uniqueId = 1L;
    }

    public void returnValueFromJavaScript(String msgs) {
        String[] messageJsons;
        if (TextUtils.isEmpty((CharSequence)msgs)) {
            return;
        }
        if (!MLog.isLogLevelAboveVerbose()) {
            MLog.verbose((Object)"WVJSBridgeClient", (String)("xuwakao, returnValueFromJavaScript msgs = " + msgs), (Object[])new Object[0]);
        }
        for (String msgJson : messageJsons = msgs.split("__WVJB_MESSAGE_SEPERATOR__")) {
            try {
                INativeHandler handler;
                IJavascriptCallback callback;
                JSONObject msg = new JSONObject(msgJson);
                String responseId = msg.optString("responseId");
                if (!FP.empty((CharSequence)responseId)) {
                    callback = this.mResponseCallbacks.get(responseId);
                    if (callback == null) {
                        return;
                    }
                    callback.callback(msg.get("responseData"));
                    this.mResponseCallbacks.remove(responseId);
                    continue;
                }
                callback = null;
                final String callbackID = msg.optString("callbackId");
                callback = callbackID != null && !callbackID.equals("") ? new IJavascriptCallback(){

                    public void callback(Object data) {
                        try {
                            JSONObject responseData = new JSONObject();
                            responseData.put("responseId", (Object)callbackID);
                            responseData.put("responseData", data);
                            WVJSBridgeClient.this.queueMessage(responseData);
                        }
                        catch (Throwable throwable) {
                            MLog.error((Object)"WVJSBridgeClient", (Throwable)throwable);
                        }
                    }

                    public void onJsHandlerNotFound(String callbackId, String handlerName) {
                    }
                } : new IJavascriptCallback(){

                    public void callback(Object data) {
                    }

                    public void onJsHandlerNotFound(String callbackId, String handlerName) {
                    }
                };
                String handlerName = msg.optString("handlerName");
                if (handlerName != null && !handlerName.equals("")) {
                    handler = this.mMessageHandlers.get(handlerName);
                    if (handler == null) {
                        MLog.error((Object)"WVJSBridgeClient returnValueFromJavaScript", (String)("no such handler " + handlerName), (Object[])new Object[0]);
                        this.tryDispatchUnSupportAPIEvent(handlerName);
                        return;
                    }
                } else {
                    return;
                }
                try {
                    String dataString = msg.optString("data");
                    if (dataString.startsWith("{")) {
                        handler.call((Object)new JSONObject(dataString), callback);
                        continue;
                    }
                    if (dataString.startsWith("[")) {
                        handler.call((Object)new JSONArray(dataString), callback);
                        continue;
                    }
                    dataString = dataString.equals("") ? null : dataString;
                    handler.call((Object)dataString, callback);
                }
                catch (Throwable throwable) {
                    MLog.error((Object)"WVJSBridgeClient", (Throwable)throwable);
                }
            }
            catch (Throwable throwable) {
                MLog.error((Object)"WVJSBridgeClient", (Throwable)throwable);
            }
        }
    }

    public void queueMessage(JSONObject msg) {
        if (this.mStartupMessageQueue != null) {
            this.mStartupMessageQueue.add(msg);
        } else {
            this.dispathMessage(msg);
        }
    }

    private void dispathMessage(JSONObject msg) {
        WebView view = (WebView)this.mWebViewHolder.get();
        if (view != null && msg != null) {
            String msgJSONString = msg.toString();
            msgJSONString = msgJSONString.replace("\\", "\\\\");
            msgJSONString = msgJSONString.replace("\"", "\\\"");
            msgJSONString = msgJSONString.replace("'", "\\'");
            msgJSONString = msgJSONString.replace("\n", "\\n");
            msgJSONString = msgJSONString.replace("\r", "\\r");
            if ((msgJSONString = msgJSONString.replace("\f", "\\f")) != null) {
                if (!MLog.isLogLevelAboveVerbose()) {
                    MLog.verbose((Object)"WVJSBridgeClient", (String)("xuwakao, dispathMessage msg = " + msgJSONString), (Object[])new Object[0]);
                }
                this.safetyLoadJs(view, "javascript:dispatchMsgToJs('" + msgJSONString + "')");
            }
        }
    }

    private void dispatchJSBridgeReadyEvent(WebView webView) {
        if (!MLog.isLogLevelAboveVerbose()) {
            MLog.verbose((Object)"WVJSBridgeClient", (String)"xuwakao dispatchJSBridgeReadyEvent", (Object[])new Object[0]);
        }
        this.safetyLoadJs(webView, "javascript:" + JSBridgeScript);
    }

    private void startFlushMessageQueue(WebView webView) {
        this.safetyLoadJs(webView, "javascript:WebViewJavascriptBridge._fetchQueue();");
    }

    private void sendData(Object data, IJavascriptCallback callback, String handlerName) {
        try {
            JSONObject dataObject = new JSONObject();
            dataObject.put("data", data);
            if (callback != null) {
                String callbackId = "java_CB_" + this.uniqueId++;
                dataObject.put("callbackId", (Object)callbackId);
                this.mResponseCallbacks.put(callbackId, callback);
            }
            if (handlerName != null) {
                dataObject.put("handlerName", (Object)handlerName);
            }
            this.queueMessage(dataObject);
        }
        catch (Throwable throwable) {
            MLog.error((Object)"WVJSBridgeClient", (Throwable)throwable);
        }
    }

    public boolean shouldOverrideUrlLoading(WebView view, String url) {
        if (!MLog.isLogLevelAboveVerbose()) {
            MLog.verbose((Object)"WVJSBridgeClient", (String)("kuiannan load web url = " + url), (Object[])new Object[0]);
        }
        Uri uri = Uri.parse((String)url);
        if (url.startsWith("weixin://wap/pay?appid")) {
            block16: {
                Intent intent = new Intent("android.intent.action.VIEW");
                intent.setData(Uri.parse((String)url));
                try {
                    view.getContext().startActivity(intent);
                }
                catch (Exception e) {
                    if (MLog.isLogLevelAboveVerbose()) break block16;
                    MLog.verbose((Object)"WVJSBridgeClient", (String)("start weixin error " + e.toString()), (Object[])new Object[0]);
                }
            }
            return true;
        }
        if (url.startsWith("intent://platformapi/startapp?")) {
            try {
                Intent intent = null;
                try {
                    intent = Intent.parseUri((String)url, (int)1);
                    intent.addCategory("android.intent.category.BROWSABLE");
                    intent.setComponent(null);
                    if (Build.VERSION.SDK_INT >= 15) {
                        intent.setSelector(null);
                    }
                }
                catch (URISyntaxException e) {
                    MLog.error((Object)"WVJSBridgeClient", (String)e.getMessage(), (Object[])new Object[0]);
                }
                view.getContext().startActivity(intent);
            }
            catch (Exception e) {
                MLog.error((Object)"WVJSBridgeClient", (String)e.getMessage(), (Object[])new Object[0]);
            }
            return true;
        }
        MimeTypeMap.getSingleton();
        String extension = MimeTypeMap.getFileExtensionFromUrl((String)url);
        if ("mp4".equalsIgnoreCase(extension)) {
            if (!MLog.isLogLevelAboveVerbose()) {
                MLog.verbose((Object)"WVJSBridgeClient", (String)("mp4 url " + url), (Object[])new Object[0]);
            }
            this.playWebViewVideo((Activity)view.getContext(), url);
        } else if (uri.getScheme().equalsIgnoreCase("wvjbscheme")) {
            if (uri.getHost().equalsIgnoreCase("__WVJB_QUEUE_MESSAGE__")) {
                this.startFlushMessageQueue(view);
            }
        } else {
            this.safetyLoadUrl(view, url);
        }
        return true;
    }

    private void safetyLoadUrl(final WebView view, final String url) {
        if (view != null && url != null) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                public void run() {
                    try {
                        view.loadUrl(url);
                    }
                    catch (Exception e) {
                        MLog.error((Object)"WVJSBridgeClient", (Throwable)e);
                    }
                }
            });
        }
    }

    private void safetyLoadJs(final WebView view, final String js) {
        if (Build.VERSION.SDK_INT <= 18) {
            this.safetyLoadUrl(view, js);
            return;
        }
        if (view != null && !FP.empty((CharSequence)js)) {
            YYTaskExecutor.postToMainThread((Runnable)new Runnable(){

                @Override
                @TargetApi(value=19)
                public void run() {
                    try {
                        if (Build.VERSION.SDK_INT > 18) {
                            try {
                                view.evaluateJavascript(js, null);
                            }
                            catch (Exception e) {
                                MLog.error((Object)"WVJSBridgeClient", (Throwable)e);
                                MLog.info((Object)"WVJSBridgeClient", (String)"switch to call loadUrl", (Object[])new Object[0]);
                                view.loadUrl(js);
                            }
                        }
                    }
                    catch (Exception e) {
                        MLog.error((Object)"WVJSBridgeClient", (Throwable)e);
                    }
                }
            });
        }
    }

    private void tryDispatchUnSupportAPIEvent(String apiStr) {
        try {
            JSONObject eventObj = new JSONObject();
            eventObj.put("type", (Object)"ApiUnSupportedEvent");
            eventObj.put("apiUri", (Object)apiStr);
            this.callHandler("brdigeEventHandler", eventObj);
        }
        catch (Exception e) {
            MLog.error((Object)"WVJSBridgeClient", (Throwable)e);
        }
    }

    public void onLoadResource(WebView view, String url) {
        super.onLoadResource(view, url);
        if (!MLog.isLogLevelAboveVerbose()) {
            MLog.verbose((Object)"WVJSBridgeClient", (String)("onLoadResource url = " + url), (Object[])new Object[0]);
        }
    }

    public void onReceivedError(WebView view, int errorCode, String description, String failingUrl) {
        super.onReceivedError(view, errorCode, description, failingUrl);
        MLog.error((Object)"WVJSBridgeClient", (String)("onReceivedError errorCode:" + errorCode + ",description:" + description + ",failingUrl:" + failingUrl), (Object[])new Object[0]);
        view.clearView();
        this.safetyLoadUrl(view, "file:///android_asset/load_page_fail.html");
    }

    public void onReceivedSslError(WebView view, final SslErrorHandler handler, SslError error) {
        String errorMsg = "";
        String url = "";
        if (error != null) {
            errorMsg = error.toString();
            url = error.getUrl();
        }
        MLog.info((Object)"WVJSBridgeClient", (String)"url=%s,onReceivedSslError=%s,%s", (Object[])new Object[]{url, errorMsg, this.ignoreSslError});
        if (this.ignoreSslError) {
            handler.proceed();
            return;
        }
        Activity activity = GlobalActivityManager.INSTANCE.getCurrentActivity();
        if (this.mWebViewHolder != null && this.mWebViewHolder.get() != null && activity != null) {
            DialogLinkManager dialogManager = new DialogLinkManager((Context)activity);
            dialogManager.showDialog((BaseDialog)new OkCancelDialog((CharSequence)"\u5f53\u524d\u7f51\u7ad9\u8bc1\u4e66\u975e\u6cd5\u6216\u5305\u542b\u9519\u8bef\uff0c\u662f\u5426\u4fe1\u4efb\u5e76\u7ee7\u7eed\u8bbf\u95ee", (CharSequence)"\u7ee7\u7eed\u8bbf\u95ee", (CharSequence)"\u53d6\u6d88", false, new OkCancelDialogListener(){

                public void onCancel() {
                    WVJSBridgeClient.this.ignoreSslError = false;
                    MLog.info((Object)"WVJSBridgeClient", (String)"onReceivedSslError onCancel", (Object[])new Object[0]);
                    handler.cancel();
                }

                public void onOk() {
                    MLog.info((Object)"WVJSBridgeClient", (String)"onReceivedSslError onOk", (Object[])new Object[0]);
                    WVJSBridgeClient.this.ignoreSslError = true;
                    handler.proceed();
                }
            }));
        }
    }

    public void onPageStarted(WebView view, String url, Bitmap favicon) {
        if (!FP.empty((CharSequence)url) && (url.startsWith("http://") || url.startsWith("https://"))) {
            this.mInsertJS = false;
        }
        super.onPageStarted(view, url, favicon);
    }

    public void onPageFinished(WebView view, String url) {
        super.onPageFinished(view, url);
        if (!MLog.isLogLevelAboveVerbose()) {
            MLog.verbose((Object)"WVJSBridgeClient", (String)("web onPageFinished url = " + url), (Object[])new Object[0]);
        }
        if (!this.mCurrentURLString.equalsIgnoreCase(url)) {
            this.mCurrentURLString = url;
        }
        this.dispatchJSBridgeReadyEvent(view);
        if (this.mStartupMessageQueue != null && !this.mStartupMessageQueue.isEmpty()) {
            for (JSONObject msg : this.mStartupMessageQueue) {
                this.dispathMessage(msg);
            }
            this.mStartupMessageQueue.clear();
        }
        this.mStartupMessageQueue = null;
    }

    private void playWebViewVideo(Activity act, String url) {
    }

    public void setInsertJs(boolean insertJs) {
        this.mInsertJS = insertJs;
    }

    public boolean getInserJs() {
        return this.mInsertJS;
    }

    @TargetApi(value=11)
    public static void removeJavascriptInterface(WebView view, String objName) {
        if (Build.VERSION.SDK_INT >= 11) {
            view.removeJavascriptInterface(objName);
        }
    }

    public static class BridgeWebChromeClient
    extends WebChromeClient {
        private AppearanceCallback mAppearanceCallack;
        UploadMessage uploadMessage = new UploadMessage();

        public void onConsoleMessage(String message, int lineNumber, String sourceID) {
            super.onConsoleMessage(message, lineNumber, sourceID);
        }

        public boolean onConsoleMessage(ConsoleMessage consoleMessage) {
            if (!MLog.isLogLevelAboveVerbose()) {
                MLog.verbose((Object)"WVJSBridgeClient", (String)("javascript console:" + consoleMessage.message() + ",lineNumber=" + consoleMessage.lineNumber() + ",messageLevel=" + consoleMessage.messageLevel()), (Object[])new Object[0]);
            }
            return super.onConsoleMessage(consoleMessage);
        }

        public void onReceivedTitle(WebView view, String title) {
            if (!MLog.isLogLevelAboveVerbose()) {
                MLog.verbose((Object)"WVJSBridgeClient", (String)("xuwakao, title = " + title + ", mAppearanceCallack = " + this.mAppearanceCallack), (Object[])new Object[0]);
            }
            super.onReceivedTitle(view, title);
            if (this.mAppearanceCallack != null) {
                this.mAppearanceCallack.onReceivedTitle(view, title);
            }
        }

        @TargetApi(value=21)
        public boolean onShowFileChooser(WebView webView, ValueCallback<Uri[]> filePathCallback, WebChromeClient.FileChooserParams fileChooserParams) {
            this.uploadMessage.setUploadMessageAboveL(filePathCallback);
            this.mAppearanceCallack.doOpenFileChooser(this.uploadMessage.openImageChooserActivity(fileChooserParams.getAcceptTypes()), this.uploadMessage);
            return true;
        }

        public void openFileChooser(ValueCallback<Uri> valueCallback) {
            this.uploadMessage.setUploadMessage(valueCallback);
            this.mAppearanceCallack.doOpenFileChooser(this.uploadMessage.openImageChooserActivity("image/*"), this.uploadMessage);
        }

        public void openFileChooser(ValueCallback valueCallback, String acceptType) {
            this.uploadMessage.setUploadMessage((ValueCallback<Uri>)valueCallback);
            this.mAppearanceCallack.doOpenFileChooser(this.uploadMessage.openImageChooserActivity(acceptType), this.uploadMessage);
        }

        public void openFileChooser(ValueCallback<Uri> valueCallback, String acceptType, String capture) {
            this.uploadMessage.setUploadMessage(valueCallback);
            this.mAppearanceCallack.doOpenFileChooser(this.uploadMessage.openImageChooserActivity(acceptType), this.uploadMessage);
        }

        public void onShowCustomView(View view, WebChromeClient.CustomViewCallback callback) {
            super.onShowCustomView(view, callback);
            if (!MLog.isLogLevelAboveVerbose()) {
                MLog.verbose((Object)"WVJSBridgeClient", (String)("xuwakao, onShowCustomView1 view = " + view), (Object[])new Object[0]);
            }
            if (this.mAppearanceCallack != null) {
                this.mAppearanceCallack.onShowCustomView(view, callback);
            }
        }

        @TargetApi(value=14)
        public void onShowCustomView(View view, int requestedOrientation, WebChromeClient.CustomViewCallback callback) {
            if (Build.VERSION.SDK_INT >= 14) {
                super.onShowCustomView(view, requestedOrientation, callback);
                this.mAppearanceCallack.onShowCustomView(view, callback);
                if (!MLog.isLogLevelAboveVerbose()) {
                    MLog.verbose((Object)"WVJSBridgeClient", (String)("xuwakao, onShowCustomView2 view = " + view), (Object[])new Object[0]);
                }
            }
        }

        public void onHideCustomView() {
            super.onHideCustomView();
            if (!MLog.isLogLevelAboveVerbose()) {
                MLog.verbose((Object)"WVJSBridgeClient", (String)"xuwakao, onHideCustomView", (Object[])new Object[0]);
            }
            if (this.mAppearanceCallack != null) {
                this.mAppearanceCallack.onHideCustomView();
            }
        }

        public void setAppearanceCallack(AppearanceCallback appearanceCallack) {
            this.mAppearanceCallack = appearanceCallack;
        }

        public static interface AppearanceCallback {
            public void onReceivedTitle(WebView var1, String var2);

            public void doOpenFileChooser(Intent var1, UploadMessage var2);

            public void onHideCustomView();

            public void onShowCustomView(View var1, WebChromeClient.CustomViewCallback var2);
        }
    }
}

