/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.utils.js.bridge;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.webkit.CookieManager;
import android.webkit.CookieSyncManager;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.plugin.main.events.IAuthClient_onLoginSucceed_EventArgs;
import com.yy.mobile.plugin.main.events.IAuthClient_onLogout_EventArgs;
import com.yy.mobile.plugin.main.events.INotification_onPermissionChane_EventArgs;
import com.yy.mobile.sdkwrapper.login.LoginProtocol;
import com.yy.mobile.ui.notify.NotificationsUtils;
import com.yy.mobile.ui.utils.NavigationUtils;
import com.yy.mobile.ui.utils.js.bridge.ApiChannel$$EventBinder;
import com.yy.mobile.ui.utils.js.bridge.IApiChannelCallBack;
import com.yy.mobile.ui.utils.js.bridge.IBridgeClient;
import com.yy.mobile.ui.utils.js.bridge.IJavascriptCallback;
import com.yy.mobile.ui.utils.js.bridge.INativeHandler;
import com.yy.mobile.ui.utils.js.bridge.WVJSBridgeClient;
import com.yy.mobile.ui.utils.js.delegate.UIDelegate;
import com.yy.mobile.ui.utils.js.exception.RestAPINotSupportException;
import com.yy.mobile.ui.utils.rest.NavRestHandler;
import com.yy.mobile.ui.webactivity.webviewbussiness.IAlertDialogCallBack;
import com.yy.mobile.util.TelephonyUtils;
import com.yy.mobile.util.VersionUtil;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.AbstractBaseCore;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.CoreManager;
import com.yymobile.core.channel.ChannelState;
import com.yymobile.core.live.gson.RightBtnInfo;
import com.yymobile.core.subscribe.ISubscribeClient;
import com.yymobile.core.subscribe.ISubscribeCore;
import com.yymobile.core.subscribe.SubscribeClients;
import com.yymobile.core.subscribe.SubscribeInfo;
import com.yymobile.core.user.UserInfo;
import java.lang.ref.WeakReference;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ApiChannel
extends AbstractBaseCore
implements EventCompat {
    public static Map<String, String> memStorage = new HashMap<String, String>();
    public WeakReference<IBridgeClient> bridgeClientHolder;
    public UIDelegate uiDelegate = null;
    public Map<String, Object> objectHolder;
    private Handler mHandler = new Handler(Looper.getMainLooper());
    private ISubscribeClient subscribeClient = new ISubscribeClient(){

        public void onGetSubscribeList(long uid, List<SubscribeInfo> list, boolean isLastPage) {
        }

        public void onSubscribeResult(long anchorUid, boolean success, String errorMsg) {
            try {
                JSONObject eventObj = new JSONObject();
                eventObj.put("type", (Object)"FollowEvent");
                eventObj.put("isSuccess", success);
                eventObj.put("uid", anchorUid);
                ApiChannel.this.dispathBridgeEvent(eventObj);
            }
            catch (JSONException e) {
                MLog.error((Object)"ApiChannel", (Throwable)e);
            }
        }

        public void onUnSubscribeResult(long anchorUid, boolean success) {
            try {
                JSONObject eventObj = new JSONObject();
                eventObj.put("type", (Object)"UnFollowEvent");
                eventObj.put("isSuccess", success);
                eventObj.put("uid", anchorUid);
                ApiChannel.this.dispathBridgeEvent(eventObj);
            }
            catch (JSONException e) {
                MLog.error((Object)"ApiChannel", (Throwable)e);
            }
        }

        public void onQuerySubscribeNumResult(long uid, long count) {
        }
    };
    private EventBinder mApiChannelSniperEventBinder;

    public void onEventBind() {
        super.onEventBind();
        if (this.mApiChannelSniperEventBinder == null) {
            this.mApiChannelSniperEventBinder = new ApiChannel$$EventBinder();
        }
        this.mApiChannelSniperEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        super.onEventUnBind();
        if (this.mApiChannelSniperEventBinder != null) {
            this.mApiChannelSniperEventBinder.unBindEvent();
        }
    }

    public void handleURI(Activity activity, String uriString) throws RestAPINotSupportException {
        NavRestHandler.getInstance().handleNavString(activity, uriString, (Object)Boolean.TRUE);
    }

    public ApiChannel(final Activity actSupport, IBridgeClient client, UIDelegate delegate, final IApiChannelCallBack callBack) {
        this.uiDelegate = delegate;
        this.objectHolder = new HashMap<String, Object>();
        if (actSupport != null) {
            if (client != null) {
                this.bridgeClientHolder = new WeakReference<IBridgeClient>(client);
                client.registerHandler("quitChannel", new INativeHandler(){

                    public void call(Object data, IJavascriptCallback callback) {
                        actSupport.runOnUiThread(new Runnable(){

                            @Override
                            public void run() {
                                if (CoreManager.getChannelLinkCore().getChannelState() == ChannelState.In_Channel) {
                                    CoreManager.getChannelLinkCore().leaveChannel();
                                }
                            }
                        });
                    }
                });
                client.registerHandler("gotoBrowser", new INativeHandler(){

                    public void call(Object data, IJavascriptCallback callback) {
                        try {
                            JSONObject dataObj = (JSONObject)data;
                            String urlStr = dataObj.getString("url");
                            if (callBack != null) {
                                callBack.gotoBrowser(urlStr);
                            } else {
                                NavigationUtils.toUrl(actSupport, urlStr);
                            }
                        }
                        catch (Exception e) {
                            MLog.error((Object)"ApiChannel", (Throwable)e);
                        }
                    }
                });
                client.registerHandler("closeAllWindow", new INativeHandler(){

                    public void call(Object data, IJavascriptCallback callback) {
                        if (callBack != null) {
                            callBack.toMainActivity();
                        } else {
                            NavigationUtils.toMain(actSupport);
                        }
                    }
                });
                client.registerHandler("yyuigoto", new INativeHandler(){

                    public void call(Object data, IJavascriptCallback callback) {
                        try {
                            JSONObject dataObj = (JSONObject)data;
                            String uriStr = dataObj.getString("uri");
                            if (uriStr != null) {
                                if (callBack != null) {
                                    callBack.handleNavRestUrl(uriStr);
                                } else {
                                    ApiChannel.this.handleURI(actSupport, uriStr);
                                }
                            } else {
                                MLog.error((Object)"ApiChannel", (String)"Error! null uri string.", (Object[])new Object[0]);
                            }
                        }
                        catch (RestAPINotSupportException e) {
                            MLog.error((Object)"ApiChannel", (Throwable)e);
                            ApiChannel.this.dispatcheUnSupportedEvent(e.getUriString());
                        }
                        catch (Exception e) {
                            MLog.error((Object)"ApiChannel", (Throwable)e);
                        }
                    }
                });
                client.registerHandler("isLoggedInWithUserPassword", new INativeHandler(){

                    public void call(Object data, IJavascriptCallback callback) {
                        callback.callback((Object)LoginUtil.isLogined());
                    }
                });
                client.registerHandler("requestWebToken", new INativeHandler(){

                    public void call(Object data, IJavascriptCallback callback) {
                        String ticket = null;
                        long myuid = LoginUtil.getUid();
                        if (myuid > 0L) {
                            ticket = LoginProtocol.Factory.get().getWebToken();
                        }
                        MLog.info((Object)"ApiChannel", (String)("xuwakao, client ticket = " + ticket + ", uid = " + myuid), (Object[])new Object[0]);
                        callback.callback((Object)ticket);
                    }
                });
                client.registerHandler("followUser", new INativeHandler(){

                    public void call(Object data, IJavascriptCallback callback) {
                        try {
                            if (!LoginUtil.isLogined()) {
                                if (callBack != null) {
                                    callBack.toLogin(true, false);
                                } else {
                                    NavigationUtils.toLogin((Context)actSupport, true, false);
                                }
                            } else {
                                long uid = Long.valueOf((String)data);
                                if (uid == 0L) {
                                    uid = LoginUtil.getUid();
                                }
                                ((ISubscribeCore)CoreFactory.getCore(ISubscribeCore.class)).subscribe(uid);
                            }
                        }
                        catch (Exception e) {
                            MLog.error((Object)"ApiChannel", (Throwable)e);
                        }
                    }
                });
                client.registerHandler("unFollowUser", new INativeHandler(){

                    public void call(Object data, IJavascriptCallback callback) {
                        try {
                            if (!LoginUtil.isLogined()) {
                                if (callBack != null) {
                                    callBack.toLogin(true, false);
                                } else {
                                    NavigationUtils.toLogin((Context)actSupport, true, false);
                                }
                            } else {
                                long uid = Long.valueOf((String)data);
                                if (uid == 0L) {
                                    uid = LoginUtil.getUid();
                                }
                                ((ISubscribeCore)CoreFactory.getCore(ISubscribeCore.class)).unSubscribe(uid);
                            }
                        }
                        catch (Exception e) {
                            MLog.error((Object)"ApiChannel", (Throwable)e);
                        }
                    }
                });
                client.registerHandler("getAppInfo", new INativeHandler(){

                    public void call(Object data, IJavascriptCallback callback) {
                        try {
                            if (callback != null) {
                                JSONObject result = new JSONObject();
                                long uid = LoginUtil.getUid();
                                long imid = 0L;
                                UserInfo info = CoreManager.getUserCore().getCacheUserInfoByUid(uid);
                                if (info != null) {
                                    imid = info.yyId;
                                }
                                result.put("uid", uid);
                                result.put("imid", imid);
                                result.put("system", (Object)"Android");
                                result.put("systemVersion", (Object)Build.VERSION.RELEASE);
                                result.put("appVersion", (Object)VersionUtil.getLocalVer((Context)BasicConfig.getInstance().getAppContext()).getVersionNameFor3GReq());
                                result.put("imei", (Object)TelephonyUtils.getImei((Context)BasicConfig.getInstance().getAppContext()));
                                result.put("imsi", (Object)TelephonyUtils.getIMSI((Context)BasicConfig.getInstance().getAppContext()));
                                MLog.info((Object)"ApiChannel", (String)("web get app info:" + result), (Object[])new Object[0]);
                                callback.callback((Object)result);
                            } else {
                                MLog.warn((Object)"ApiChannel", (String)"on js call getAppInfo. callback is null.", (Object[])new Object[0]);
                            }
                        }
                        catch (Exception e) {
                            MLog.error((Object)"ApiChannel", (Throwable)e);
                        }
                    }
                });
                client.registerHandler("showAlertMessage", new INativeHandler(){

                    public void call(Object data, IJavascriptCallback callback) {
                        if (callBack != null) {
                            this.remoteProc((JSONObject)data, callback);
                        } else {
                            this.defaultProc((JSONObject)data, callback);
                        }
                    }

                    private void defaultProc(JSONObject data, final IJavascriptCallback callback) {
                        try {
                            JSONObject jsonObject = data;
                            String title = jsonObject.optString("title", "");
                            String message = jsonObject.optString("message", "");
                            JSONArray buttons = jsonObject.optJSONArray("buttons");
                            if (message.length() > 0) {
                                AlertDialog.Builder builder = new AlertDialog.Builder((Context)actSupport);
                                builder.setTitle((CharSequence)title);
                                builder.setMessage((CharSequence)message);
                                if (buttons != null) {
                                    int btnArrLng = buttons.length();
                                    if (btnArrLng > 2) {
                                        btnArrLng = 2;
                                    }
                                    for (int i = 0; i < btnArrLng; ++i) {
                                        if (i == 0) {
                                            builder.setPositiveButton((CharSequence)buttons.optString(i), new DialogInterface.OnClickListener(){

                                                public void onClick(DialogInterface dialog2, int which) {
                                                    try {
                                                        JSONObject result = new JSONObject();
                                                        result.put("index", 0);
                                                        result.put("error", null);
                                                        callback.callback((Object)result);
                                                    }
                                                    catch (Exception e) {
                                                        MLog.error((Object)"ApiChannel", (Throwable)e);
                                                    }
                                                    dialog2.dismiss();
                                                }
                                            });
                                            continue;
                                        }
                                        builder.setNegativeButton((CharSequence)buttons.optString(i), new DialogInterface.OnClickListener(){

                                            public void onClick(DialogInterface dialog2, int which) {
                                                try {
                                                    JSONObject result = new JSONObject();
                                                    result.put("index", 1);
                                                    result.put("error", null);
                                                    callback.callback((Object)result);
                                                }
                                                catch (Exception e) {
                                                    MLog.error((Object)"ApiChannel", (Throwable)e);
                                                }
                                                dialog2.dismiss();
                                            }
                                        });
                                    }
                                }
                                builder.create().show();
                            } else if (callback != null) {
                                JSONObject errorMsg = new JSONObject();
                                errorMsg.put("index", -1);
                                errorMsg.put("error", (Object)"Error: message and buttons is required.");
                                callback.callback((Object)errorMsg);
                            }
                        }
                        catch (Exception e) {
                            MLog.error((Object)"ApiChannel", (Throwable)e);
                        }
                    }

                    private void remoteProc(JSONObject data, final IJavascriptCallback callback) {
                        try {
                            JSONObject jsonObject = data;
                            String title = jsonObject.optString("title", "");
                            String message = jsonObject.optString("message", "");
                            JSONArray buttons = jsonObject.optJSONArray("buttons");
                            if (message.length() > 0) {
                                if (buttons != null) {
                                    String posBtn = null;
                                    String negBtn = null;
                                    int btnArrLng = buttons.length();
                                    if (btnArrLng > 2) {
                                        btnArrLng = 2;
                                    }
                                    for (int i = 0; i < btnArrLng; ++i) {
                                        if (i == 0) {
                                            posBtn = buttons.optString(i);
                                            continue;
                                        }
                                        negBtn = buttons.optString(i);
                                    }
                                    if ((posBtn != null || negBtn != null) && callBack != null) {
                                        callBack.showAlertDialog(title, message, posBtn, negBtn, new IAlertDialogCallBack(){

                                            @Override
                                            public void onPositiveButtonClicked() {
                                                try {
                                                    JSONObject result = new JSONObject();
                                                    result.put("index", 0);
                                                    result.put("error", null);
                                                    callback.callback((Object)result);
                                                }
                                                catch (Exception e) {
                                                    MLog.error((Object)"ApiChannel", (Throwable)e);
                                                }
                                            }

                                            @Override
                                            public void onMiddleButtonClicked() {
                                            }

                                            @Override
                                            public void onNegativeButtonClicked() {
                                                try {
                                                    JSONObject result = new JSONObject();
                                                    result.put("index", 1);
                                                    result.put("error", null);
                                                    callback.callback((Object)result);
                                                }
                                                catch (Exception e) {
                                                    MLog.error((Object)"ApiChannel", (Throwable)e);
                                                }
                                            }
                                        });
                                    }
                                }
                            } else if (callback != null) {
                                JSONObject errorMsg = new JSONObject();
                                errorMsg.put("index", -1);
                                errorMsg.put("error", (Object)"Error: message and buttons is required.");
                                callback.callback((Object)errorMsg);
                            }
                        }
                        catch (Exception e) {
                            MLog.error((Object)"ApiChannel", (Throwable)e);
                        }
                    }
                });
                client.registerHandler("showProgressWindow", new INativeHandler(){

                    public void call(Object data, IJavascriptCallback callback) {
                        try {
                            if (ApiChannel.this.uiDelegate != null) {
                                JSONObject jsonObject = (JSONObject)data;
                                jsonObject.put("show", true);
                                ApiChannel.this.uiDelegate.delegateProgress(jsonObject);
                            }
                        }
                        catch (Exception e) {
                            MLog.error((Object)"ApiChannel", (Throwable)e);
                        }
                    }
                });
                client.registerHandler("hideProgressWindow", new INativeHandler(){

                    public void call(Object data, IJavascriptCallback callback) {
                        try {
                            if (ApiChannel.this.uiDelegate != null) {
                                JSONObject jsonObject = new JSONObject();
                                jsonObject.put("show", false);
                                ApiChannel.this.uiDelegate.delegateProgress(jsonObject);
                            }
                        }
                        catch (Exception e) {
                            MLog.error((Object)"ApiChannel", (Throwable)e);
                        }
                    }
                });
                client.registerHandler("setCommonStorageValueForKey", new INativeHandler(){

                    public void call(Object data, IJavascriptCallback callback) {
                        try {
                            JSONObject jsonObject = (JSONObject)data;
                            String key = jsonObject.getString("key");
                            String value = jsonObject.getString("value");
                            if (value != null) {
                                memStorage.put(key, value);
                                MLog.info((Object)"ApiChannel", (String)("JS set common storage value for key " + key + ",value:" + value), (Object[])new Object[0]);
                            } else if (memStorage.containsKey(key)) {
                                MLog.info((Object)"ApiChannel", (String)("JS remove common storage value for key " + key), (Object[])new Object[0]);
                                memStorage.remove(key);
                            }
                            if (callback != null) {
                                callback.callback(null);
                            }
                        }
                        catch (Exception e) {
                            MLog.error((Object)"ApiChannel", (Throwable)e);
                        }
                    }
                });
                client.registerHandler("getCommonStorageValueForKey", new INativeHandler(){

                    public void call(Object data, IJavascriptCallback callback) {
                        try {
                            if (data != null) {
                                String key = (String)data;
                                JSONObject result = new JSONObject();
                                MLog.info((Object)"ApiChannel", (String)("JS get common storage value for key " + key + ",value:" + memStorage.get(key)), (Object[])new Object[0]);
                                result.put("value", (Object)memStorage.get(key));
                                result.put("error", null);
                                if (callback != null) {
                                    callback.callback((Object)result);
                                }
                            } else {
                                JSONObject result = new JSONObject();
                                result.put("value", null);
                                result.put("error", (Object)"Error: key\u4e0d\u80fd\u4e3a\u7a7a\u4e14\u5fc5\u987b\u4e3astring\u7c7b\u578b");
                                if (callback != null) {
                                    callback.callback((Object)result);
                                }
                            }
                        }
                        catch (Exception e) {
                            MLog.error((Object)"ApiChannel", (Throwable)e);
                        }
                    }
                });
                client.registerHandler("postNotification", new INativeHandler(){

                    public void call(Object data, IJavascriptCallback callback) {
                        try {
                            JSONObject jsonObject = (JSONObject)data;
                            int notificationID = jsonObject.getInt("notificationID");
                            JSONObject userInfo = jsonObject.getJSONObject("userInfo");
                            if (callback != null) {
                                JSONObject result = new JSONObject();
                                result.put("result", true);
                                callback.callback((Object)result);
                            }
                        }
                        catch (Exception e) {
                            MLog.error((Object)"ApiChannel", (Throwable)e);
                            try {
                                if (callback != null) {
                                    JSONObject result = new JSONObject();
                                    result.put("result", false);
                                    callback.callback((Object)result);
                                }
                            }
                            catch (Exception e1) {
                                MLog.error((Object)"ApiChannel", (Throwable)e1);
                            }
                        }
                    }
                });
                client.registerHandler("deleteSharedCookie", new INativeHandler(){

                    public void call(Object data, IJavascriptCallback callback) {
                        try {
                            String domain = (String)data;
                            CookieSyncManager cookieSyncManager = CookieSyncManager.createInstance((Context)BasicConfig.getInstance().getAppContext());
                            CookieManager cookieManager = CookieManager.getInstance();
                            cookieManager.setAcceptCookie(true);
                            String cookieStr = cookieManager.getCookie(domain);
                            if (cookieStr != null && cookieStr.length() > 0) {
                                String[] cookies = cookieStr.split(";");
                                for (int i = 0; i < cookies.length; ++i) {
                                    String[] cookieparts = cookies[i].split("=");
                                    cookieManager.setCookie(domain, cookieparts[0].trim() + "=0;");
                                }
                            }
                            MLog.info((Object)"ApiChannel", (String)("web delete shared cookie, now is " + cookieManager.getCookie(domain)), (Object[])new Object[0]);
                            cookieSyncManager.sync();
                            if (callback != null) {
                                JSONObject result = new JSONObject();
                                result.put("count", 0);
                                callback.callback((Object)result);
                            }
                        }
                        catch (Exception e) {
                            MLog.error((Object)"ApiChannel", (Throwable)e);
                        }
                    }
                });
                client.registerHandler("getAPILevel", new INativeHandler(){

                    public void call(Object data, IJavascriptCallback callback) {
                        if (callback != null) {
                            WVJSBridgeClient holder;
                            if (ApiChannel.this.bridgeClientHolder != null && ApiChannel.this.bridgeClientHolder.get() instanceof WVJSBridgeClient && (holder = (WVJSBridgeClient)((Object)ApiChannel.this.bridgeClientHolder.get())) != null) {
                                holder.setInsertJs(true);
                            }
                            callback.callback((Object)2);
                        }
                    }
                });
            } else {
                MLog.error((Object)"ApiChannel", (String)"null bridge client.", (Object[])new Object[0]);
            }
        }
    }

    public void dispatcheUnSupportedEvent(String api) {
        try {
            JSONObject eventObj = new JSONObject();
            eventObj.put("type", (Object)"ApiUnSupportedEvent");
            eventObj.put("apiUri", (Object)api);
            this.dispathBridgeEvent(eventObj);
        }
        catch (Exception e) {
            MLog.error((Object)"ApiChannel", (Throwable)e);
        }
    }

    @BusEvent(sync=true)
    public void onLoginSucceed(IAuthClient_onLoginSucceed_EventArgs busEventArgs) {
        long userId = busEventArgs.getUid();
        try {
            MLog.info((Object)"ApiChannel", (String)"xuwakao, client dispatch event onLoginSuccess", (Object[])new Object[0]);
            JSONObject eventObj = new JSONObject();
            eventObj.put("type", (Object)"LoginEvent");
            eventObj.put("isSuccess", true);
            eventObj.put("uid", userId);
            this.dispathBridgeEvent(eventObj);
        }
        catch (Exception e) {
            MLog.error((Object)"ApiChannel", (Throwable)e);
        }
    }

    @BusEvent(sync=true)
    public void onLogout(IAuthClient_onLogout_EventArgs busEventArgs) {
        try {
            MLog.info((Object)"ApiChannel", (String)"xuwakao, client dispatch event onLogout", (Object[])new Object[0]);
            JSONObject eventObj = new JSONObject();
            eventObj.put("type", (Object)"LogoutEvent");
            this.dispathBridgeEvent(eventObj);
        }
        catch (Exception e) {
            MLog.error((Object)"ApiChannel", (Throwable)e);
        }
    }

    public void onRightBtnClicked(RightBtnInfo info) {
        if (!MLog.isLogLevelAboveVerbose()) {
            MLog.verbose((Object)"ApiChannel", (String)("xuwakao, RightBtnInfo = " + info + ", this = " + (Object)((Object)this)), (Object[])new Object[0]);
        }
        try {
            IBridgeClient client = (IBridgeClient)this.bridgeClientHolder.get();
            if (client != null) {
                JSONObject eventObj = new JSONObject();
                eventObj.put("identifier", info.identifier);
                eventObj.put("selected", info.selected);
                client.callHandler("1931NavigationBarButtonItemTapped", (Object)eventObj, null);
            }
        }
        catch (Exception e) {
            MLog.error((Object)"ApiChannel", (Throwable)e);
        }
    }

    public void onLeftBackClicked() {
        if (!MLog.isLogLevelAboveVerbose()) {
            MLog.verbose((Object)"ApiChannel", (String)("onLeftBackClicked, this = " + (Object)((Object)this)), (Object[])new Object[0]);
        }
        try {
            IBridgeClient client = (IBridgeClient)this.bridgeClientHolder.get();
            if (client != null) {
                client.callHandler("1931LeftButtonClick");
            }
        }
        catch (Exception e) {
            MLog.error((Object)"ApiChannel", (Throwable)e);
        }
    }

    @BusEvent(sync=true)
    public void onNotificationPermissionEvent(INotification_onPermissionChane_EventArgs eventArgs) {
        boolean ntyEnable = NotificationsUtils.isNotificationEnable();
        MLog.info((Object)"ApiChannel", (String)"onNotificationPermissionEvent, ntyEnable: %s", (Object[])new Object[]{ntyEnable});
        try {
            IBridgeClient client = (IBridgeClient)this.bridgeClientHolder.get();
            if (client != null) {
                JSONObject eventObj = new JSONObject();
                eventObj.put("data", (Object)(ntyEnable ? "1" : "0"));
                eventObj.put("code", (Object)"1");
                client.callHandler("onNotificationPermissionEvent", (Object)eventObj, null);
            }
        }
        catch (Exception e) {
            MLog.error((Object)"ApiChannel", (Throwable)e);
        }
    }

    public void dispathBridgeEvent(JSONObject eventObject) {
        IBridgeClient client = (IBridgeClient)this.bridgeClientHolder.get();
        if (client != null) {
            MLog.info((Object)"ApiChannel", (String)("client dispatch event:" + eventObject.toString()), (Object[])new Object[0]);
            client.callHandler("brdigeEventHandler", (Object)eventObject);
        } else {
            MLog.error((Object)"ApiChannel", (String)"fail dispatch bridge event, client is null.", (Object[])new Object[0]);
        }
    }

    public void dispatchAskForHandlePopActionEvent(JSONObject object, IJavascriptCallback callback) {
        IBridgeClient client = (IBridgeClient)this.bridgeClientHolder.get();
        if (client != null) {
            client.callHandler("askForHandlePopAction", (Object)object, callback);
        }
    }

    public void regsiterNotification() {
        SubscribeClients.addCallBack((ISubscribeClient)this.subscribeClient);
        CoreManager.addClient((Object)((Object)this));
    }

    public void unregsiternotification() {
        CoreManager.removeClient((Object)((Object)this));
        SubscribeClients.removeCallBack((ISubscribeClient)this.subscribeClient);
    }

    public void release() {
        try {
            this.unregsiternotification();
            this.uiDelegate = null;
            if (this.bridgeClientHolder != null) {
                IBridgeClient client = (IBridgeClient)this.bridgeClientHolder.get();
                if (client != null) {
                    client.destory();
                }
                this.bridgeClientHolder.clear();
                this.bridgeClientHolder = null;
            }
        }
        catch (Exception e) {
            MLog.error((Object)"ApiChannel", (Throwable)e);
        }
    }
}

