/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.utils;

import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Rect;
import com.yy.mobile.YYMobileApp;
import com.yy.mobile.plugin.pluginunionmain.R;
import java.util.ArrayList;
import java.util.List;

public class UserGradeDrawer {
    private static RangeNode sIconNode = null;
    private int mPreferWidth = 0;
    private int mLevel = 0;
    private Bitmap mGradeBitmap = null;
    private Bitmap mShortGradeBitmap = null;

    public static int convertExpToLevel(int exp) {
        int f1 = exp * 16 + 1;
        float f2 = (float)Math.sqrt(f1) + 1.0f;
        return (int)(f2 / 2.0f);
    }

    public UserGradeDrawer() {
        if (sIconNode == null) {
            RangeNode nodeLeaf = new RangeNode(1, 3, null, R.drawable.icon_leaf);
            RangeNode nodeDiamond = new RangeNode(4, 15, nodeLeaf, R.drawable.mn_icon_diamond);
            RangeNode nodeShield = new RangeNode(16, 63, nodeDiamond, R.drawable.icon_shield);
            RangeNode nodeCrown = new RangeNode(64, 255, nodeShield, R.drawable.mn_icon_crown);
            RangeNode nodeBigCrown = new RangeNode(256, 1023, nodeCrown, R.drawable.icon_big_crown);
            RangeNode nodeLantern = new RangeNode(1024, Integer.MAX_VALUE, nodeBigCrown, R.drawable.icon_lantern);
            sIconNode = nodeLeaf;
        }
    }

    private List<Bitmap> getIconListByLevel(int level, boolean fullGrade) {
        ArrayList<Bitmap> iconList = new ArrayList<Bitmap>();
        while (level > 0) {
            RangeNode node = sIconNode.getNode(level);
            int iconCount = node.getIconCount(level);
            for (int i = 0; i < iconCount; ++i) {
                iconList.add(node.mIcon);
            }
            level = fullGrade ? node.getLeftValue(level) : 0;
        }
        return iconList;
    }

    public Bitmap getFirstGradeIcon(int exp) {
        int level = UserGradeDrawer.convertExpToLevel(exp);
        List<Bitmap> iconList = this.getIconListByLevel(level, false);
        return iconList.get(0);
    }

    public Bitmap getGradeBitmap(int exp, boolean fullGrade) {
        Bitmap bmp;
        int level = UserGradeDrawer.convertExpToLevel(exp);
        Bitmap bitmap = bmp = fullGrade ? this.mGradeBitmap : this.mShortGradeBitmap;
        if (this.mLevel != level || bmp == null) {
            List<Bitmap> iconList = this.getIconListByLevel(level, fullGrade);
            if (iconList.size() > 0) {
                int[] size = this.getBitmapSize(iconList);
                bmp = Bitmap.createBitmap((int)size[0], (int)size[1], (Bitmap.Config)Bitmap.Config.ARGB_4444);
                this.drawGrade(bmp, iconList, size);
            }
            this.mLevel = level;
            if (fullGrade) {
                this.mGradeBitmap = bmp;
            } else {
                this.mShortGradeBitmap = bmp;
            }
        }
        return bmp;
    }

    private int[] getBitmapSize(List<Bitmap> iconList) {
        int iconHeight = 18;
        int[] size = new int[]{0, iconHeight};
        for (Bitmap bmp : iconList) {
            size[1] = Math.max(size[1], bmp.getHeight());
            this.mPreferWidth = (int)((float)bmp.getWidth() / (float)bmp.getHeight() * (float)size[1]);
            size[0] = size[0] + this.mPreferWidth;
        }
        size[0] = size[0] + this.mPreferWidth;
        return size;
    }

    private void drawGrade(Bitmap gradeBmp, List<Bitmap> iconList, int[] size) {
        Canvas canvas = new Canvas(gradeBmp);
        Rect dst = new Rect(0, 0, 0, size[1]);
        for (Bitmap bmp : iconList) {
            Rect src = new Rect(0, 0, bmp.getWidth(), bmp.getHeight());
            dst.right += this.mPreferWidth;
            canvas.drawBitmap(bmp, src, dst, null);
            dst.left += this.mPreferWidth;
        }
    }

    private static class RangeNode {
        public int mBase;
        public int mMax;
        public RangeNode mLeft = null;
        public RangeNode mRight = null;
        public Bitmap mIcon;

        RangeNode(int base, int max, RangeNode left, int iconId) {
            this.mBase = base;
            this.mMax = max;
            this.mLeft = left;
            if (left != null) {
                left.mRight = this;
            }
            this.mIcon = BitmapFactory.decodeResource((Resources)YYMobileApp.gContext.getResources(), (int)iconId);
        }

        public RangeNode getNode(int level) {
            if (level < this.mBase && this.mLeft != null) {
                return this.mLeft.getNode(level);
            }
            if (level > this.mMax && this.mRight != null) {
                return this.mRight.getNode(level);
            }
            return this;
        }

        public int getIconCount(int level) {
            return Math.min(level / this.mBase, this.mMax == Integer.MAX_VALUE ? Integer.MAX_VALUE : 3);
        }

        public int getLeftValue(int level) {
            return level % this.mBase;
        }
    }
}

