/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.utils;

import android.media.AudioRecord;
import android.media.MediaRecorder;
import android.os.Environment;
import android.util.Log;
import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;

public class AudioRecoder {
    public static final String TAG = AudioRecoder.class.getSimpleName();
    private static final int[] sampleRates = new int[]{44100, 22050, 11025, 8000};
    private static AudioRecoder result;
    private boolean rUncompressed;
    public AudioRecord audioRecorder = null;
    private MediaRecorder mediaRecorder = null;
    public int cAmplitude = 0;
    private String filePath = null;
    private State state;
    public RandomAccessFile randomAccessWriter;
    private short nChannels;
    private int sRate;
    public short bSamples;
    private int bufferSize;
    private int aSource;
    private int aFormat;
    private int framePeriod;
    public byte[] buffer;
    public int payloadSize;
    private AudioRecord.OnRecordPositionUpdateListener updateListener = new AudioRecord.OnRecordPositionUpdateListener(){

        public void onPeriodicNotification(AudioRecord recorder) {
            AudioRecoder.this.audioRecorder.read(AudioRecoder.this.buffer, 0, AudioRecoder.this.buffer.length);
            Log.d((String)TAG, (String)"updateListenerrecording is ing");
            try {
                AudioRecoder.this.randomAccessWriter.write(AudioRecoder.this.buffer);
                AudioRecoder.this.payloadSize = AudioRecoder.this.payloadSize + AudioRecoder.this.buffer.length;
                if (AudioRecoder.this.bSamples == 16) {
                    for (int i = 0; i < AudioRecoder.this.buffer.length / 2; ++i) {
                        short curSample = AudioRecoder.this.getShort(AudioRecoder.this.buffer[i * 2], AudioRecoder.this.buffer[i * 2 + 1]);
                        if (curSample <= AudioRecoder.this.cAmplitude) continue;
                        AudioRecoder.this.cAmplitude = curSample;
                    }
                } else {
                    for (int i = 0; i < AudioRecoder.this.buffer.length; ++i) {
                        if (AudioRecoder.this.buffer[i] <= AudioRecoder.this.cAmplitude) continue;
                        int cfr_ignored_0 = AudioRecoder.this.buffer[i];
                        AudioRecoder.this.cAmplitude = AudioRecoder.this.cAmplitude;
                    }
                }
            }
            catch (IOException e) {
                Log.d((String)TAG, (String)"updateListenerrecord succ");
                AudioRecoder.this.reset();
            }
        }

        public void onMarkerReached(AudioRecord recorder) {
        }
    };

    public static AudioRecoder getInstanse() {
        if (result != null) {
            return result;
        }
        result = new AudioRecoder(true, 1, sampleRates[3], 16, 2);
        return result;
    }

    public State getState() {
        return this.state;
    }

    public AudioRecoder(boolean uncompressed, int audioSource, int sampleRate, int channelConfig, int audioFormat) {
        try {
            this.rUncompressed = uncompressed;
            if (this.rUncompressed) {
                this.bSamples = audioFormat == 2 ? (short)16 : (short)8;
                this.nChannels = channelConfig == 16 ? (short)1 : (short)2;
                this.aSource = audioSource;
                this.sRate = sampleRate;
                this.aFormat = audioFormat;
                this.framePeriod = sampleRate * 120 / 1000;
                this.bufferSize = this.framePeriod * 2 * this.bSamples * this.nChannels / 8;
                if (this.bufferSize < AudioRecord.getMinBufferSize((int)sampleRate, (int)channelConfig, (int)audioFormat)) {
                    this.bufferSize = AudioRecord.getMinBufferSize((int)sampleRate, (int)channelConfig, (int)audioFormat);
                    this.framePeriod = this.bufferSize / (2 * this.bSamples * this.nChannels / 8);
                    Log.w((String)TAG, (String)("AudioRecoderIncreasing buffer size to " + Integer.toString(this.bufferSize)));
                }
                this.audioRecorder = new AudioRecord(audioSource, sampleRate, channelConfig, audioFormat, this.bufferSize);
                if (this.audioRecorder.getState() != 1) {
                    throw new Exception("AudioRecord initialization failed");
                }
                this.audioRecorder.setRecordPositionUpdateListener(this.updateListener);
                this.audioRecorder.setPositionNotificationPeriod(this.framePeriod);
            } else {
                this.mediaRecorder = new MediaRecorder();
                this.mediaRecorder.setAudioSource(5);
                this.mediaRecorder.setOutputFormat(1);
                this.mediaRecorder.setAudioEncoder(1);
            }
            this.cAmplitude = 0;
            this.filePath = null;
            this.state = State.INITIALIZING;
        }
        catch (Exception e) {
            if (e.getMessage() != null) {
                Log.e((String)TAG, (String)("AudioRecoder" + e.getMessage()));
            } else {
                Log.e((String)TAG, (String)"AudioRecoderUnknown error occured while initializing recording");
            }
            this.state = State.ERROR;
        }
    }

    public void setOutputFile(String argPath) {
        try {
            if (this.state == State.INITIALIZING) {
                this.filePath = argPath;
                if (!this.rUncompressed) {
                    this.mediaRecorder.setOutputFile(this.filePath);
                }
            }
        }
        catch (Exception e) {
            if (e.getMessage() != null) {
                Log.e((String)TAG, (String)("setOutputFile" + e.getMessage()));
            } else {
                Log.e((String)TAG, (String)"setOutputFileUnknown error occured while setting output path");
            }
            this.state = State.ERROR;
        }
    }

    public String getFilePath() {
        return this.filePath;
    }

    public int getMaxAmplitude() {
        if (this.state == State.RECORDING) {
            if (this.rUncompressed) {
                int result = this.cAmplitude;
                this.cAmplitude = 0;
                return result;
            }
            try {
                return this.mediaRecorder.getMaxAmplitude();
            }
            catch (IllegalStateException e) {
                return 0;
            }
        }
        return 0;
    }

    public void prepare() {
        Log.d((String)TAG, (String)("prepare prepare state:" + (Object)((Object)this.state) + ""));
        Log.d((String)TAG, (String)("prepare prepare filePath:" + this.filePath + ""));
        Log.d((String)TAG, (String)("prepare audioRecorder.getState():" + this.audioRecorder.getState() + ""));
        try {
            if (this.state == State.INITIALIZING) {
                if (this.rUncompressed) {
                    if (this.audioRecorder.getState() == 1 & this.filePath != null) {
                        this.randomAccessWriter = new RandomAccessFile(this.filePath, "rw");
                        this.randomAccessWriter.setLength(0L);
                        this.randomAccessWriter.writeBytes("RIFF");
                        this.randomAccessWriter.writeInt(0);
                        this.randomAccessWriter.writeBytes("WAVE");
                        this.randomAccessWriter.writeBytes("fmt ");
                        this.randomAccessWriter.writeInt(Integer.reverseBytes(16));
                        this.randomAccessWriter.writeShort(Short.reverseBytes((short)1));
                        this.randomAccessWriter.writeShort(Short.reverseBytes(this.nChannels));
                        this.randomAccessWriter.writeInt(Integer.reverseBytes(this.sRate));
                        this.randomAccessWriter.writeInt(Integer.reverseBytes(this.sRate * this.bSamples * this.nChannels / 8));
                        this.randomAccessWriter.writeShort(Short.reverseBytes((short)(this.nChannels * this.bSamples / 8)));
                        this.randomAccessWriter.writeShort(Short.reverseBytes(this.bSamples));
                        this.randomAccessWriter.writeBytes("data");
                        this.randomAccessWriter.writeInt(0);
                        this.buffer = new byte[this.framePeriod * this.bSamples / 8 * this.nChannels];
                        this.state = State.READY;
                    } else {
                        Log.e((String)TAG, (String)"prepareprepare() method called on uninitialized recorder");
                        this.state = State.ERROR;
                    }
                } else {
                    this.mediaRecorder.prepare();
                    this.state = State.READY;
                }
            } else if (this.state == State.STOPPED || this.state == State.ERROR) {
                String fileTempPath = this.filePath;
                this.reset();
                this.setOutputFile(fileTempPath);
            } else {
                Log.e((String)TAG, (String)"prepareprepare() method called on illegal state");
                this.release();
                this.state = State.ERROR;
            }
        }
        catch (Exception e) {
            if (e.getMessage() != null) {
                Log.e((String)TAG, (String)("prepare" + e.getMessage()));
            } else {
                Log.e((String)TAG, (String)"prepareUnknown error occured in prepare()");
            }
            this.state = State.ERROR;
        }
    }

    public void release() {
        if (this.state == State.RECORDING) {
            this.stop();
        } else if (this.state == State.READY & this.rUncompressed) {
            try {
                this.randomAccessWriter.close();
            }
            catch (IOException e) {
                Log.e((String)TAG, (String)"releaseI/O exception occured while closing output file");
            }
            new File(this.filePath).delete();
        }
        if (this.rUncompressed) {
            if (this.audioRecorder != null) {
                this.audioRecorder.release();
            }
        } else if (this.mediaRecorder != null) {
            this.mediaRecorder.release();
        }
    }

    public void reset() {
        try {
            this.release();
            this.filePath = null;
            this.cAmplitude = 0;
            if (this.rUncompressed) {
                this.audioRecorder = new AudioRecord(this.aSource, this.sRate, this.nChannels + 1, this.aFormat, this.bufferSize);
                if (this.audioRecorder.getState() != 1) {
                    throw new Exception("AudioRecord initialization failed");
                }
            } else {
                this.mediaRecorder = new MediaRecorder();
                this.mediaRecorder.setAudioSource(5);
                this.mediaRecorder.setOutputFormat(1);
                this.mediaRecorder.setAudioEncoder(1);
            }
            this.state = State.INITIALIZING;
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)("reset" + e.getMessage()));
            this.state = State.ERROR;
        }
    }

    public void start() {
        if (this.state == State.READY) {
            if (this.rUncompressed) {
                this.payloadSize = 0;
                this.audioRecorder.setRecordPositionUpdateListener(this.updateListener);
                this.audioRecorder.setPositionNotificationPeriod(this.framePeriod);
                this.audioRecorder.startRecording();
                this.audioRecorder.read(this.buffer, 0, this.buffer.length);
            } else {
                this.mediaRecorder.start();
            }
            this.state = State.RECORDING;
        } else {
            Log.e((String)TAG, (String)"startcalled on illegal state");
            this.state = State.ERROR;
        }
    }

    public void stop() {
        if (this.state == State.RECORDING) {
            if (this.rUncompressed) {
                this.audioRecorder.stop();
                try {
                    this.randomAccessWriter.seek(4L);
                    this.randomAccessWriter.writeInt(Integer.reverseBytes(36 + this.payloadSize));
                    this.randomAccessWriter.seek(40L);
                    this.randomAccessWriter.writeInt(Integer.reverseBytes(this.payloadSize));
                    this.randomAccessWriter.close();
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)"stopI/O exception occured while closing output file");
                    this.state = State.ERROR;
                }
            } else {
                this.mediaRecorder.stop();
            }
            this.state = State.STOPPED;
        } else {
            Log.e((String)TAG, (String)"stopcalled on illegal state");
            this.state = State.ERROR;
        }
    }

    public short getShort(byte argB1, byte argB2) {
        return (short)(argB1 | argB2 << 8);
    }

    public void recordChat(String fileName) {
        if (!Environment.getExternalStorageState().equals("mounted")) {
            return;
        }
        File file = new File(this.makeFileStroagePath(), fileName);
        this.setOutputFile(file.getAbsolutePath());
        this.prepare();
        this.start();
    }

    public void stopRecord() {
        this.stop();
        this.release();
    }

    public File makeFileStroagePath() {
        File file = new File(Environment.getExternalStorageDirectory() + "/yymobile/audio");
        try {
            if (!file.exists()) {
                file.mkdirs();
                return file;
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        return file;
    }

    public static enum State {
        INITIALIZING,
        READY,
        RECORDING,
        ERROR,
        STOPPED;

    }
}

