/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.setting.item;

import android.content.Context;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.yy.mobile.plugin.pluginunionmain.R;
import com.yy.mobile.ui.setting.item.ISettingListItem;
import com.yy.mobile.ui.setting.model.SettingModel;
import com.yy.mobile.ui.setting.widget.BaseSettingItemGroup;
import com.yy.mobile.ui.setting.widget.SettingItemClickListener;
import com.yy.mobile.ui.setting.widget.SettingItemView;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import java.util.ArrayList;
import java.util.List;

public class SettingItemGroup
extends LinearLayout
implements ISettingListItem<BaseSettingItemGroup> {
    private List<ISettingListItem> mItemList;
    private TextView topText;
    private TextView bottomText;
    private LinearLayout content;
    private BaseSettingItemGroup datas;
    private SettingItemClickListener listener;

    public static SettingItemGroup newInstance(Context context) {
        return (SettingItemGroup)LayoutInflater.from((Context)context).inflate(R.layout.activity_setting_item_group, null);
    }

    public SettingItemGroup(Context context) {
        super(context);
        this.init();
    }

    public SettingItemGroup(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.init();
    }

    public SettingItemGroup(Context context, @Nullable AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.init();
    }

    private void init() {
        this.mItemList = new ArrayList<ISettingListItem>();
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.bottomText = (TextView)this.findViewById(R.id.setting_group_bottom_text);
        this.topText = (TextView)this.findViewById(R.id.setting_group_top_text);
        this.content = (LinearLayout)this.findViewById(R.id.setting_group_content);
        MLog.info((Object)"SettingItemGroup", (String)"onFinishInflate", (Object[])new Object[0]);
    }

    protected void onDetachedFromWindow() {
        this.performItemDestory();
        super.onDetachedFromWindow();
    }

    @Override
    public void setData(BaseSettingItemGroup baseSettingItemGroup) {
        MLog.info((Object)"SettingItemGroup", (String)"setData", (Object[])new Object[0]);
        this.datas = baseSettingItemGroup;
        if (this.datas != null) {
            String topTips = baseSettingItemGroup.getTopTips();
            if (StringUtils.isEmpty((String)topTips).booleanValue()) {
                this.topText.setVisibility(8);
            } else {
                this.topText.setVisibility(0);
                this.topText.setText((CharSequence)topTips);
            }
            String bottomTips = baseSettingItemGroup.getBottomTips();
            if (StringUtils.isEmpty((String)bottomTips).booleanValue()) {
                this.bottomText.setVisibility(8);
            } else {
                this.bottomText.setVisibility(0);
                this.bottomText.setText((CharSequence)baseSettingItemGroup.getBottomTips());
            }
            List<SettingModel> items = baseSettingItemGroup.getDatas();
            for (int i = 0; i < items.size(); ++i) {
                this.createItemView(items.get(i), i);
            }
        }
    }

    private SettingItemView createItemView(SettingModel item, int index) {
        if (item.enable()) {
            Object view = item.bindView(this.getContext());
            this.content.addView(view);
            item.onCreate();
            this.mItemList.add((ISettingListItem)view);
            return view;
        }
        return null;
    }

    private void performItemDestory() {
        if (this.datas != null) {
            for (SettingModel settingModel : this.datas.getDatas()) {
                settingModel.onDestroy();
            }
        }
    }

    @Override
    public BaseSettingItemGroup getData() {
        return this.datas;
    }
}

