/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.report.module;

import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.android.sniper.api.event.EventCompat;
import com.yy.mobile.RxBus;
import com.yy.mobile.baseapi.model.store.YYStore;
import com.yy.mobile.model.ReqAction;
import com.yy.mobile.plugin.main.events.IReportClient_onReport_EventArgs;
import com.yy.mobile.plugin.main.events.IReportUploadClient_onUploadFail_EventArgs;
import com.yy.mobile.plugin.main.events.IReportUploadClient_onUploadSuccess_EventArgs;
import com.yy.mobile.ui.basicfunction.uicore.IBasicFunctionCore;
import com.yy.mobile.ui.report.event.ReportQueryImMsgEventArgs;
import com.yy.mobile.ui.report.module.ReportModule$$EventBinder;
import com.yy.mobile.ui.report.module.ReportModuleListener;
import com.yy.mobile.util.FP;
import com.yy.mobile.util.RxUtils;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.im.request.QueryImMsgAction;
import com.yymobile.core.report.IReportCore;
import io.reactivex.annotations.NonNull;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class ReportModule
implements EventCompat {
    private int mStyle;
    private long mMineUid;
    public long mUserUid;
    private String mTitle;
    private String mFilePath;
    public final List<String> mRecentChatsList = new ArrayList<String>();
    private ReportModuleListener mReportModuleListener;
    private final List<Disposable> mDisposableList = new ArrayList<Disposable>();
    private EventBinder mReportModuleSniperEventBinder;

    public void onEventBind() {
        if (this.mReportModuleSniperEventBinder == null) {
            this.mReportModuleSniperEventBinder = new ReportModule$$EventBinder();
        }
        this.mReportModuleSniperEventBinder.bindEvent((Object)this);
    }

    public void onEventUnBind() {
        if (this.mReportModuleSniperEventBinder != null) {
            this.mReportModuleSniperEventBinder.unBindEvent();
        }
    }

    private void initRxEvents() {
        Disposable onQueryMsgByIndex = RxBus.getDefault().register(ReportQueryImMsgEventArgs.class).subscribe((Consumer)new Consumer<ReportQueryImMsgEventArgs>(){

            public void accept(@NonNull ReportQueryImMsgEventArgs eventArgs) throws Exception {
                List msgs;
                if (eventArgs.getUid() == ReportModule.this.mUserUid && !FP.empty((Collection)(msgs = eventArgs.getRecentChatsList()))) {
                    ReportModule.this.mRecentChatsList.addAll(msgs);
                }
            }
        }, RxUtils.errorConsumer((String)"ImReportModule_XXX"));
        this.mDisposableList.add(onQueryMsgByIndex);
    }

    private void disposeRxEvents() {
        for (Disposable d : this.mDisposableList) {
            d.dispose();
        }
    }

    public void setImReportModuleListener(ReportModuleListener listener2) {
        this.mReportModuleListener = listener2;
    }

    public ReportModule(long mineId, long userId) {
        this.mMineUid = mineId;
        this.mUserUid = userId;
        this.initRxEvents();
        ICoreManagerBase.addClient((Object)this);
        YYStore.INSTANCE.dispatch((ReqAction)new QueryImMsgAction(this.mUserUid, 30L));
    }

    public void destroy() {
        this.disposeRxEvents();
        this.mRecentChatsList.clear();
        ICoreManagerBase.removeClient((Object)this);
    }

    public void submitReport(int style2, String title, String filePath) {
        if (this.mMineUid > 0L && this.mUserUid > 0L) {
            this.mTitle = title;
            this.mStyle = style2;
            this.mFilePath = filePath;
            this.uploadReportScreenshot();
        } else {
            this.reportFailed(-2);
            MLog.info((Object)"ImReportModule_XXX", (String)("submitReport mMineUid = " + this.mMineUid + " mUserUid = " + this.mUserUid), (Object[])new Object[0]);
        }
    }

    private void reportFailed(int errCode) {
        if (this.mReportModuleListener != null) {
            this.mReportModuleListener.reportFailed(errCode);
        }
    }

    private void reportSuccessed() {
        if (this.mReportModuleListener != null) {
            this.mReportModuleListener.reportSuccessed();
        }
    }

    private void uploadReportScreenshot() {
        if (this.mFilePath != null && !this.mFilePath.isEmpty()) {
            ((IReportCore)ICoreManagerBase.getCore(IReportCore.class)).uploadScreenshot(this.mFilePath, this.mStyle, this.mTitle, "ImReportModule_XXX");
        }
    }

    @BusEvent(sync=true)
    public void onUploadSuccess(IReportUploadClient_onUploadSuccess_EventArgs busEventArgs) {
        String url = busEventArgs.getUrl();
        int style2 = busEventArgs.getStyle();
        String title = busEventArgs.getTitle();
        String context = busEventArgs.getContext();
        if (!StringUtils.isEmptyString((String)context) && context.equals("ImReportModule_XXX")) {
            this.onImUploadSuccess(url, style2, title);
        } else {
            MLog.info((Object)"ImReportModule_XXX", (String)("onUploadSuccess context = " + context), (Object[])new Object[0]);
        }
    }

    private void onImUploadSuccess(String url, int style2, String title) {
        int type = 2;
        int child = 41;
        String content = this.buildReportContent(url);
        String extParUrlEncoder = this.buildAnchorExtParUrlEncoder();
        String extProductParam = this.buildExtProductParam(url);
        HashMap<String, String> extendInfo = new HashMap<String, String>();
        extendInfo.put("ReportContext", "ImReportModule_XXX");
        ((IBasicFunctionCore)ICoreManagerBase.getCore(IBasicFunctionCore.class)).sendReportBasic(type, (long)child, style2, this.mUserUid, content, extParUrlEncoder, extProductParam, extendInfo);
    }

    private String buildReportContent(String picUrl) {
        JSONObject jContent = new JSONObject();
        try {
            Date currentDate = new Date();
            SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            String dateString = formatter.format(currentDate);
            jContent.put("id", (Object)("im_report_" + this.mMineUid + "_" + this.mUserUid));
            jContent.put("title", (Object)"");
            jContent.put("type", 8);
            jContent.put("createTime", (Object)dateString);
            JSONArray jcontentArray = new JSONArray();
            JSONObject titleItem = new JSONObject();
            titleItem.put("type", 1);
            titleItem.put("value", (Object)("\u7528\u6237\u63cf\u8ff0\uff1a" + this.mTitle));
            jcontentArray.put((Object)titleItem);
            if (this.mRecentChatsList != null && this.mRecentChatsList.size() > 0) {
                for (int i = 0; i < this.mRecentChatsList.size(); ++i) {
                    JSONObject textItem = new JSONObject();
                    textItem.put("type", 1);
                    textItem.put("value", (Object)("im\uff1a" + this.mRecentChatsList.get(i)));
                    jcontentArray.put((Object)textItem);
                }
            }
            JSONObject picItem = new JSONObject();
            picItem.put("type", 2);
            picItem.put("value", (Object)picUrl);
            jcontentArray.put((Object)picItem);
            jContent.put("contents", (Object)jcontentArray);
        }
        catch (JSONException e) {
            MLog.error((Object)"ImReportModule_XXX", (Throwable)e);
        }
        return jContent.toString();
    }

    private String buildAnchorExtParUrlEncoder() {
        JSONObject jExtParUrlEncoder = new JSONObject();
        try {
            jExtParUrlEncoder.put("uid", (Object)"");
            jExtParUrlEncoder.put("sid", (Object)"");
            jExtParUrlEncoder.put("appId", 15013);
        }
        catch (JSONException e) {
            MLog.error((Object)"ImReportModule_XXX", (Throwable)e);
        }
        return jExtParUrlEncoder.toString();
    }

    private String buildExtProductParam(String picUrl) {
        JSONObject jExtProductParam = new JSONObject();
        try {
            jExtProductParam.put("submitPhoneNum", (Object)"");
            jExtProductParam.put("reportedLocation", (Object)"");
            jExtProductParam.put("reportedPhoneNum", (Object)"");
            jExtProductParam.put("lianmaiUid", (Object)"");
            jExtProductParam.put("reportedSid", (Object)"");
            jExtProductParam.put("reportedSsid", (Object)"");
            jExtProductParam.put("reportedVideoId", (Object)"");
            jExtProductParam.put("reportedVideoAppid", (Object)"");
            jExtProductParam.put("reportedVideoTitle", (Object)"");
            jExtProductParam.put("reportedVideoOnlineNum", (Object)"");
            JSONArray reportedCaptureUrlArray = new JSONArray();
            JSONObject reportedCaptureUrl = new JSONObject();
            reportedCaptureUrl.put("url", (Object)picUrl);
            reportedCaptureUrlArray.put((Object)reportedCaptureUrl);
            jExtProductParam.put("reportedCaptureUrl", (Object)reportedCaptureUrlArray);
        }
        catch (JSONException e) {
            MLog.error((Object)"ImReportModule_XXX", (Throwable)e);
        }
        return jExtProductParam.toString();
    }

    @BusEvent(sync=true)
    public void onUploadFail(IReportUploadClient_onUploadFail_EventArgs busEventArgs) {
        String context = busEventArgs.getContext();
        if (!StringUtils.isEmptyString((String)context) && context.equals("ImReportModule_XXX")) {
            this.reportFailed(-1);
        } else {
            MLog.info((Object)"ImReportModule_XXX", (String)("onUploadFail context = " + context), (Object[])new Object[0]);
        }
    }

    @BusEvent(sync=true)
    public void onReport(IReportClient_onReport_EventArgs busEventArgs) {
        int code = busEventArgs.getCode();
        Map extendInfo = busEventArgs.getData();
        if (extendInfo != null && extendInfo.size() > 0 && extendInfo.containsKey("ReportContext")) {
            if (code == 0) {
                this.reportSuccessed();
            } else if (code == 1) {
                this.reportFailed(1);
            }
        } else {
            MLog.info((Object)"ImReportModule_XXX", (String)("onReport extendInfo =" + extendInfo), (Object[])new Object[0]);
        }
    }
}

