/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.profile.takephoto;

import android.app.Activity;
import android.app.AppOpsManager;
import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.net.Uri;
import android.os.Build;
import android.os.Bundle;
import android.os.Parcelable;
import android.os.Process;
import android.support.v4.app.ActivityCompat;
import android.support.v4.content.FileProvider;
import android.view.View;
import android.widget.RelativeLayout;
import com.gyf.immersionbar.ImmersionBar;
import com.yy.mobile.android.arouter.facade.annotation.Route;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.permission.AndroidPermission;
import com.yy.mobile.plugin.pluginunionmain.R;
import com.yy.mobile.ui.BaseActivity;
import com.yy.mobile.ui.profile.takephoto.PhotoEditController;
import com.yy.mobile.ui.profile.takephoto.TakePhotoController;
import com.yy.mobile.ui.utils.SingleToastUtil;
import com.yy.mobile.ui.utils.YYImageUtils;
import com.yy.mobile.ui.utils.dialog.DialogLinkManager;
import com.yy.mobile.util.ScreenUtil;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.YYFileUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import java.io.File;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;

@Route(path="/Media/TakePhoto")
public class PictureTakerActivity
extends BaseActivity {
    private IController mController;
    private String mPath;
    private ArrayList<String> mSelectedPaths;
    private int mStyle;
    public int mMethod;
    private int amount = 9;
    private int maxSize = Integer.MAX_VALUE;
    private String[] mResultPath;
    private String mCameraCapturingName;
    private String mFlagOfJump;
    DialogLinkManager dialogManager;
    private static String[] PERMISSIONS_STORAGE = new String[]{"android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE"};

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        Bundle data = savedInstanceState != null ? savedInstanceState : this.getIntent().getExtras();
        if (data != null) {
            this.mPath = data.getString("edit_photo_path_key");
            this.mStyle = data.getInt("act_style_key", 1);
            this.amount = data.getInt("params_picture_amount", 9);
            this.maxSize = data.getInt("params_picture_max_size", Integer.MAX_VALUE);
            this.mFlagOfJump = data.getString("params_picture_flag_of_jump", "");
            MLog.info((Object)"PictureTakerActivity", (String)("onCreate, savedInstanceState = " + savedInstanceState + ", mPath = " + this.mPath + ", mStyle = " + this.mStyle), (Object[])new Object[0]);
        } else {
            MLog.error((Object)"PictureTakerActivity", (String)"onCreate error, bundle is null.", (Object[])new Object[0]);
        }
        try {
            int permission2 = ActivityCompat.checkSelfPermission((Context)this, (String)"android.permission.WRITE_EXTERNAL_STORAGE");
            if (permission2 != 0) {
                ActivityCompat.requestPermissions((Activity)this, (String[])PERMISSIONS_STORAGE, (int)1);
            }
        }
        catch (Exception e) {
            MLog.error((Object)"PictureTakerActivity", (String)"onCreate: check external storage error, which is ", (Throwable)e, (Object[])new Object[0]);
        }
        if (!StringUtils.isEmptyString((String)this.mPath)) {
            this.mMethod = 0;
        } else if (data != null) {
            this.mMethod = data.getInt("take_photo_method_key", 2);
        }
        if (this.mStyle == 1 || this.mStyle == 2 || this.mStyle == 5) {
            boolean compress = this.mStyle != 2 && this.mStyle != 5;
            this.mController = new TakePhotoController(this, compress);
            this.mSelectedPaths = data.getStringArrayList("act_extra_key_selected");
        } else {
            PhotoEditController ctrl = new PhotoEditController(this, this.mMethod);
            if (this.mStyle == 4) {
                ctrl.enableClipPortrait(true);
            }
            this.mController = ctrl;
        }
        this.getWindow().setBackgroundDrawableResource(R.color.transparent);
        this.setContentView(this.mController.getContentView());
        if (this.mStyle == 5) {
            ((TakePhotoController)this.mController).setContentViewOkText("\u786e\u8ba4");
            ((TakePhotoController)this.mController).setContentViewTitle("\u786e\u8ba4\u56fe\u7247");
        }
        if (savedInstanceState != null) {
            Object[] result = savedInstanceState.getStringArray("result_path_key");
            MLog.info((Object)"PictureTakerActivity", (String)("post handle result. result = " + Arrays.toString(result)), (Object[])new Object[0]);
            if (this.validateImages((String[])result)) {
                this.getHandler().post(new Runnable((String[])result){
                    final /* synthetic */ String[] val$result;
                    {
                        this.val$result = stringArray;
                    }

                    @Override
                    public void run() {
                        PictureTakerActivity.this.handleResult(this.val$result, PictureTakerActivity.this.mMethod);
                    }
                });
            }
            this.mCameraCapturingName = savedInstanceState.getString("take_photo_file_path");
        } else if (this.mMethod == 0) {
            this.mController.onResult(new String[]{this.mPath}, this.mMethod);
        } else {
            this.takePhoto();
        }
    }

    @Override
    public void onBackPressed() {
        this.mController.onCancel();
        super.onBackPressed();
    }

    protected void onSaveInstanceState(Bundle outState) {
        super.onSaveInstanceState(outState);
        outState.putInt("act_style_key", this.mStyle);
        outState.putStringArray("result_path_key", this.mResultPath);
        outState.putString("take_photo_file_path", this.mCameraCapturingName);
    }

    /*
     * Unable to fully structure code
     */
    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        block8: {
            paths = null;
            MLog.info((Object)"PictureTakerActivity", (String)("onActivityResult requestCode = " + requestCode + ", resultCode = " + resultCode + ", data = " + data), (Object[])new Object[0]);
            if (resultCode != -1) break block8;
            if (requestCode != 1) ** GOTO lbl-1000
            file = YYFileUtils.getTempFile((Context)this, (String)this.mCameraCapturingName);
            MLog.info((Object)"PictureTakerActivity", (String)("PictureTaskerAct.onActivityResult, file = " + file), (Object[])new Object[0]);
            if (YYImageUtils.isImage(file)) {
                paths = new String[]{file.getPath()};
            } else if (requestCode == 3) {
                if (data != null) {
                    pathList = data.getStringArrayListExtra("result_params_selected_paths");
                    paths = new String[pathList.size()];
                    pathList.toArray(paths);
                }
            } else if (data != null) {
                uri = data.getData();
                MLog.info((Object)"PictureTakerActivity", (String)("PictureTaskerAct.onActivityResult, uri = " + uri), (Object[])new Object[0]);
                paths = new String[]{YYFileUtils.getImageFilePathFromUri((Context)this, (Uri)uri)};
            }
        }
        if (this.validateImages(paths)) {
            this.handleResult(paths, requestCode);
        } else {
            this.finish();
        }
    }

    public void takePhoto() {
        if ((this.mMethod == 1 || this.mMethod == 0) && this.hasExternalStoragePermission()) {
            this.takePhotoFromCamera();
        } else if (this.mMethod == 2) {
            this.selectPhoto();
        }
    }

    private boolean hasExternalStoragePermission() {
        int perm = this.checkCallingOrSelfPermission("android.permission.WRITE_EXTERNAL_STORAGE");
        MLog.info((Object)"PictureTakerActivity", (String)("hasExternalStoragePermission: perm is " + perm), (Object[])new Object[0]);
        return perm == 0;
    }

    private void takePhotoFromCamera() {
        final Intent intent = new Intent("android.media.action.IMAGE_CAPTURE");
        this.mCameraCapturingName = "picture_" + System.currentTimeMillis() + ".jpg";
        File out = YYFileUtils.getTempFile((Context)this, (String)this.mCameraCapturingName);
        out.delete();
        Uri photoUri = Build.VERSION.SDK_INT >= 24 ? FileProvider.getUriForFile((Context)this, (String)(this.getPackageName() + ".unionyy.fileprovider"), (File)out) : Uri.fromFile((File)out);
        intent.putExtra("output", (Parcelable)photoUri);
        List<String> permissions = Collections.singletonList("android.permission.CAMERA");
        AndroidPermission p = (AndroidPermission)ICoreManagerBase.getCore(AndroidPermission.class);
        if (p != null) {
            p.checkPermission(BasicConfig.getInstance().getAppContext(), permissions, (Function0)new Function0<Unit>(){

                public Unit invoke() {
                    block2: {
                        try {
                            PictureTakerActivity.this.startActivityForResult(intent, 1);
                        }
                        catch (Exception e) {
                            boolean permission2;
                            MLog.error((Object)"PictureTakerActivity", (String)"takePotoFromCamera fail, %s", (Throwable)e, (Object[])new Object[0]);
                            PackageManager pm = PictureTakerActivity.this.getPackageManager();
                            boolean bl = permission2 = 0 == pm.checkPermission("android.permission.CAMERA", "packageName");
                            if (permission2) break block2;
                            SingleToastUtil.showToast((String)"\u8bf7\u5230\u8bbe\u7f6e\u9875\u4e2d\u6253\u5f00\u76f8\u673a\u6743\u9650");
                        }
                    }
                    return null;
                }
            }, (Function0)new Function0<Unit>(){

                public Unit invoke() {
                    SingleToastUtil.showToast((String)"\u8bf7\u5230\u8bbe\u7f6e\u9875\u4e2d\u6253\u5f00\u76f8\u673a\u6743\u9650");
                    return null;
                }
            });
        }
    }

    private void selectPhoto() {
        if (this.preCheckBeforeSelectPhoto()) {
            SingleToastUtil.showToast((String)"\u8bf7\u5230\u8bbe\u7f6e\u9875\u6253\u5f00\"\u540e\u53f0\u5f39\u51fa\u754c\u9762\u6743\u9650\"");
            return;
        }
        Intent intent = new Intent();
        intent.setType("image/*");
        intent.setAction("android.intent.action.PICK");
        try {
            this.startActivityForResult(intent, 2);
        }
        catch (Exception e) {
            MLog.error((Object)"PictureTakerActivity", (String)"selectPhoto fail, %s", (Throwable)e, (Object[])new Object[0]);
        }
    }

    private boolean preCheckBeforeSelectPhoto() {
        if ("Redmi Note 3".equals(Build.MODEL) && !PictureTakerActivity.canBackgroundStart((Context)this)) {
            MLog.info((Object)"PictureTakerActivity", (String)("preCheckBeforeSelectPhoto: special devices = " + Build.MODEL), (Object[])new Object[0]);
            return true;
        }
        return false;
    }

    public void handleResult(String[] paths, int requestCode) {
        MLog.info((Object)"PictureTakerActivity", (String)("handleResult paths = " + Arrays.toString(paths) + " requestCode = " + requestCode), (Object[])new Object[0]);
        this.mResultPath = paths;
        this.mController.onResult(paths, requestCode);
    }

    private boolean validateImages(String[] paths) {
        boolean result = false;
        if (paths == null || paths.length == 0) {
            return false;
        }
        for (int i = 0; i < paths.length; ++i) {
            String path = paths[i];
            if (YYImageUtils.isImage(path)) continue;
            return false;
        }
        return true;
    }

    protected boolean handleStatusBar() {
        ImmersionBar.with((Activity)this).statusBarColor(17170444).init();
        return true;
    }

    protected void configView() {
        View view = this.findViewById(R.id.title);
        if (view != null) {
            RelativeLayout.LayoutParams lp = (RelativeLayout.LayoutParams)view.getLayoutParams();
            lp.height += ScreenUtil.getStatusBarHeight();
        }
    }

    public static boolean canBackgroundStart(Context context) {
        AppOpsManager ops = null;
        if (Build.VERSION.SDK_INT >= 19) {
            ops = (AppOpsManager)context.getSystemService("appops");
            try {
                int op = 10021;
                Method method = ops.getClass().getMethod("checkOpNoThrow", Integer.TYPE, Integer.TYPE, String.class);
                Integer result = (Integer)method.invoke((Object)ops, op, Process.myUid(), context.getPackageName());
                return result == 0;
            }
            catch (Exception e) {
                MLog.error((Object)"PictureTakerActivity", (String)"not support", (Throwable)e, (Object[])new Object[0]);
            }
        }
        return false;
    }

    public static interface IController {
        public View getContentView();

        public void onResult(String[] var1, int var2);

        public void onCancel();
    }
}

