/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.mobilelive;

import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapRegionDecoder;
import android.graphics.Matrix;
import android.graphics.Rect;
import android.graphics.RectF;
import android.media.ExifInterface;
import android.util.DisplayMetrics;
import android.view.View;
import android.view.WindowManager;
import com.yy.mobile.ui.mobilelive.clipimage.ClipImageView;
import com.yy.mobile.ui.mobilelive.clipimage.ClipParaInfo;
import com.yy.mobile.ui.mobilelive.clipimage.IClipImagePresenter;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import java.io.IOException;

public class ClipImagePresent
implements IClipImagePresenter,
View.OnLayoutChangeListener {
    public ClipImageView mClipImageView;
    private String mOutput;
    private String mInput;
    private int mMaxWidth;
    private int mDegree;
    private int mSampleSize;
    private int mSourceWidth;
    private int mSourceHeight;
    private int mClipImageViewWidth;

    @Override
    public void setClipImageView(ClipImageView view) {
        this.mClipImageView = view;
        this.mClipImageView.addOnLayoutChangeListener(this);
    }

    public void onLayoutChange(View v, int left, int top, int right, int bottom, int oldLeft, int oldTop, int oldRight, int oldBottom) {
        int oldWidth = right - left;
        if (this.mClipImageViewWidth != oldWidth) {
            this.mClipImageViewWidth = oldWidth;
            if (this.mInput != null && this.mInput.length() > 0 && v.isShown()) {
                this.setImageAndClipParams("onLayoutChange");
            }
        }
        MLog.info((Object)"clipImagePresent", (String)(" oldWidth=" + oldWidth + " mClipImageViewWidth=" + this.mClipImageViewWidth), (Object[])new Object[0]);
    }

    @Override
    public Bitmap getClipBitmap() {
        return this.createClippedBitmap();
    }

    @Override
    public void initClipParaInfo(ClipParaInfo info) {
        ClipOptions clipOptions = ClipOptions.createFromParaInfo(info);
        this.mInput = clipOptions.getInputPath();
        DisplayMetrics dm = new DisplayMetrics();
        WindowManager wm = (WindowManager)ICoreManagerBase.getContext().getSystemService("window");
        wm.getDefaultDisplay().getMetrics(dm);
        this.mMaxWidth = dm.widthPixels;
        this.mClipImageView.setMaxOutputWidth(this.mMaxWidth);
        this.setImageAndClipParams("initClipParaInfo");
    }

    private void setImageAndClipParams(String triggerFrom) {
        if (this.mClipImageViewWidth > 0) {
            try {
                Bitmap target;
                this.mDegree = ClipImagePresent.readPictureDegree(this.mInput);
                boolean isRotate = this.mDegree == 90 || this.mDegree == 270;
                BitmapFactory.Options options = new BitmapFactory.Options();
                options.inJustDecodeBounds = true;
                BitmapFactory.decodeFile((String)this.mInput, (BitmapFactory.Options)options);
                this.mSourceWidth = options.outWidth;
                this.mSourceHeight = options.outHeight;
                int w = isRotate ? options.outHeight : options.outWidth;
                this.mSampleSize = ClipImagePresent.findBestSample(w, this.mClipImageViewWidth);
                if (w > 2048 && this.mSampleSize < 4) {
                    this.mSampleSize = 4;
                } else if (w > 1080 && this.mSampleSize < 2) {
                    this.mSampleSize = 2;
                }
                options.inJustDecodeBounds = false;
                options.inSampleSize = this.mSampleSize;
                options.inPreferredConfig = Bitmap.Config.RGB_565;
                Bitmap source = BitmapFactory.decodeFile((String)this.mInput, (BitmapFactory.Options)options);
                MLog.info((Object)"clipImagePresent", (String)(triggerFrom + " mClipImageViewWidth=" + this.mClipImageViewWidth + " SourceWidth=" + this.mSourceWidth + " SourceHeight=" + this.mSourceHeight + " mSampleSize=" + this.mSampleSize), (Object[])new Object[0]);
                if (this.mDegree == 0) {
                    target = source;
                } else {
                    Matrix matrix = new Matrix();
                    matrix.postRotate((float)this.mDegree);
                    target = Bitmap.createBitmap((Bitmap)source, (int)0, (int)0, (int)source.getWidth(), (int)source.getHeight(), (Matrix)matrix, (boolean)false);
                    if (target != source && !source.isRecycled()) {
                        source.recycle();
                    }
                }
                this.mClipImageView.setImageBitmap(target);
                this.mClipImageView.invalidate();
            }
            catch (Throwable ex) {
                MLog.error((Object)"clipImagePresent", (Throwable)ex);
            }
        }
    }

    @Override
    public void setClipImageViewBitmapPath(String path) {
        this.mInput = path;
    }

    private static int findBestSample(int origin, int target) {
        int sample = 1;
        for (int out = origin / 2; out > target; out /= 2) {
            sample *= 2;
        }
        return sample;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bitmap createClippedBitmap() {
        if (this.mSampleSize <= 1) {
            return this.mClipImageView.clip();
        }
        float[] matrixValues = this.mClipImageView.getClipMatrixValues();
        float scale = matrixValues[0];
        float transX = matrixValues[2];
        float transY = matrixValues[5];
        Rect border = this.mClipImageView.getClipBorder();
        float cropX = (-transX + (float)border.left) / scale * (float)this.mSampleSize;
        float cropY = (-transY + (float)border.top) / scale * (float)this.mSampleSize;
        float cropWidth = (float)border.width() / scale * (float)this.mSampleSize;
        float cropHeight = (float)border.height() / scale * (float)this.mSampleSize;
        RectF srcRect = new RectF(cropX, cropY, cropX + cropWidth, cropY + cropHeight);
        Rect clipRect = this.getRealRect(srcRect);
        BitmapFactory.Options ops = new BitmapFactory.Options();
        Matrix outputMatrix = new Matrix();
        outputMatrix.setRotate((float)this.mDegree);
        if (this.mMaxWidth > 0 && cropWidth > (float)this.mMaxWidth) {
            ops.inSampleSize = ClipImagePresent.findBestSample((int)cropWidth, this.mMaxWidth);
            float outputScale = (float)this.mMaxWidth / (cropWidth / (float)ops.inSampleSize);
            outputMatrix.postScale(outputScale, outputScale);
        }
        BitmapRegionDecoder decoder = null;
        try {
            decoder = BitmapRegionDecoder.newInstance((String)this.mInput, (boolean)false);
            Bitmap source = decoder.decodeRegion(clipRect, ops);
            Bitmap bitmap = Bitmap.createBitmap((Bitmap)source, (int)0, (int)0, (int)source.getWidth(), (int)source.getHeight(), (Matrix)outputMatrix, (boolean)false);
            return bitmap;
        }
        catch (Exception e) {
            Bitmap bitmap = this.mClipImageView.clip();
            return bitmap;
        }
        finally {
            if (decoder != null && !decoder.isRecycled()) {
                decoder.recycle();
            }
        }
    }

    private Rect getRealRect(RectF srcRect) {
        switch (this.mDegree) {
            case 90: {
                return new Rect((int)srcRect.top, (int)((float)this.mSourceHeight - srcRect.right), (int)srcRect.bottom, (int)((float)this.mSourceHeight - srcRect.left));
            }
            case 180: {
                return new Rect((int)((float)this.mSourceWidth - srcRect.right), (int)((float)this.mSourceHeight - srcRect.bottom), (int)((float)this.mSourceWidth - srcRect.left), (int)((float)this.mSourceHeight - srcRect.top));
            }
            case 270: {
                return new Rect((int)((float)this.mSourceWidth - srcRect.bottom), (int)srcRect.left, (int)((float)this.mSourceWidth - srcRect.top), (int)srcRect.right);
            }
        }
        return new Rect((int)srcRect.left, (int)srcRect.top, (int)srcRect.right, (int)srcRect.bottom);
    }

    public static int readPictureDegree(String path) {
        int degree = 0;
        try {
            ExifInterface exifInterface = new ExifInterface(path);
            int orientation = exifInterface.getAttributeInt("Orientation", 1);
            switch (orientation) {
                case 6: {
                    degree = 90;
                    break;
                }
                case 3: {
                    degree = 180;
                    break;
                }
                case 8: {
                    degree = 270;
                    break;
                }
            }
        }
        catch (IOException e) {
            MLog.error((Object)"clipImagePresent", (Throwable)e);
        }
        return degree;
    }

    private void recycleImageViewBitmap() {
        this.mClipImageView.post(new Runnable(){

            @Override
            public void run() {
                ClipImagePresent.this.mClipImageView.setImageBitmap(null);
            }
        });
    }

    public static ClipOptions prepare() {
        return new ClipOptions();
    }

    public static class ClipOptions {
        private int aspectX;
        private int aspectY;
        private int maxWidth;
        private String tip;
        private String inputPath;
        private String outputPath;

        private ClipOptions() {
        }

        public ClipOptions aspectX(int aspectX) {
            this.aspectX = aspectX;
            return this;
        }

        public ClipOptions aspectY(int aspectY) {
            this.aspectY = aspectY;
            return this;
        }

        public ClipOptions maxWidth(int maxWidth) {
            this.maxWidth = maxWidth;
            return this;
        }

        public ClipOptions tip(String tip) {
            this.tip = tip;
            return this;
        }

        public ClipOptions inputPath(String path) {
            this.inputPath = path;
            return this;
        }

        public ClipOptions outputPath(String path) {
            this.outputPath = path;
            return this;
        }

        public int getAspectX() {
            return this.aspectX;
        }

        public int getAspectY() {
            return this.aspectY;
        }

        public int getMaxWidth() {
            return this.maxWidth;
        }

        public String getTip() {
            return this.tip;
        }

        public String getInputPath() {
            return this.inputPath;
        }

        public String getOutputPath() {
            return this.outputPath;
        }

        public static ClipOptions createFromParaInfo(ClipParaInfo info) {
            return new ClipOptions().aspectX(info.aspectX).aspectY(info.aspectX).maxWidth(info.maxWidth).tip(info.tip).inputPath(info.inputPath);
        }
    }
}

