/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.ui.channel;

import android.content.Context;
import android.os.Bundle;
import android.text.Html;
import android.view.View;
import android.view.ViewGroup;
import android.widget.GridView;
import android.widget.ListAdapter;
import android.widget.TextView;
import com.yy.android.sniper.annotation.inject.BusEvent;
import com.yy.android.sniper.api.event.EventBinder;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.plugin.main.events.ISignInClient_onSignHistoryResp_EventArgs;
import com.yy.mobile.plugin.pluginunionmain.R;
import com.yy.mobile.ui.BaseActivity;
import com.yy.mobile.ui.channel.DayOfMonthGridAdapter;
import com.yy.mobile.ui.channel.SignDetailsActivity$$EventBinder;
import com.yy.mobile.ui.utils.SingleToastUtil;
import com.yy.mobile.ui.utils.dialog.BaseDialog;
import com.yy.mobile.ui.utils.dialog.ProgressDialog;
import com.yy.mobile.ui.widget.SimpleTitleBar;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import com.yymobile.core.mobilelive.ILivePluginCore;
import com.yymobile.core.signin.info.SignHistoryRespInfo;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import java.util.Map;

public class SignDetailsActivity
extends BaseActivity {
    private GridView mGridDayOfMonth;
    private DayOfMonthGridAdapter mAdapter;
    private TextView mTvHistoryTitle;
    private TextView mTvHistoryMonth;
    private TextView mTvHistoryRuleTitle;
    private TextView mTvHistoryDetail;
    private View mRootView;
    private EventBinder mSignDetailsActivitySniperEventBinder;

    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_sign_details);
        SimpleTitleBar titleBar = (SimpleTitleBar)this.findViewById(R.id.title_bar);
        titleBar.setTitlte(this.getString(R.string.title_sign_details));
        titleBar.setLeftBtn(R.drawable.icon_nav_back, new View.OnClickListener(){

            public void onClick(View v) {
                SignDetailsActivity.this.finish();
            }
        });
        this.initView();
        this.mRootView = this.findViewById(R.id.root);
        this.reqSignHistory();
        this.getDialogLinkManager().showDialog((BaseDialog)new ProgressDialog("", true, true, 0, null));
        Object var4_3 = null;
        if (this.mSignDetailsActivitySniperEventBinder == null) {
            this.mSignDetailsActivitySniperEventBinder = new SignDetailsActivity$$EventBinder();
        }
        this.mSignDetailsActivitySniperEventBinder.bindEvent((Object)this);
    }

    @BusEvent(sync=true)
    public void onSignHistoryResp(ISignInClient_onSignHistoryResp_EventArgs busEventArgs) {
        boolean result = busEventArgs.getResult();
        SignHistoryRespInfo resp = busEventArgs.getResp();
        Map extendInfo = busEventArgs.getExtendInfo();
        this.getDialogLinkManager().hideProgressDialog();
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)"SignDetailsActivity", (String)("onSignHistoryResp result:" + result + "resp:" + resp), (Object[])new Object[0]);
        }
        if (result) {
            if (resp != null) {
                this.updateView(resp);
            } else {
                this.showNoData();
            }
        }
    }

    private void initView() {
        this.mTvHistoryTitle = (TextView)this.findViewById(R.id.tv_history_title);
        this.mTvHistoryMonth = (TextView)this.findViewById(R.id.tv_history_month);
        this.mTvHistoryDetail = (TextView)this.findViewById(R.id.tv_history_rule_details);
        this.mTvHistoryRuleTitle = (TextView)this.findViewById(R.id.tv_history_rule_title);
        this.mGridDayOfMonth = (GridView)this.findViewById(R.id.grid_day_of_month);
        this.mAdapter = new DayOfMonthGridAdapter((Context)this);
        this.mGridDayOfMonth.setAdapter((ListAdapter)this.mAdapter);
    }

    private void updateView(SignHistoryRespInfo resp) {
        if (!this.mRootView.isShown()) {
            this.mRootView.setVisibility(0);
        }
        String displaySignDay = String.format("\u672c\u8f6e\u5df2\u8fde\u7b7e<font color='#ff8900' size='26px'>%d</font><font color='#333333'/>\u5929", resp.signLongTimesInThisTurn);
        this.mTvHistoryTitle.setText((CharSequence)Html.fromHtml((String)displaySignDay));
        String displayMonth = String.format("%s\u5e74%s\u6708", resp.year, resp.month);
        this.mTvHistoryMonth.setText((CharSequence)displayMonth);
        this.mTvHistoryDetail.setText((CharSequence)Html.fromHtml((String)resp.ruleDetail));
        this.mTvHistoryRuleTitle.setText((CharSequence)Html.fromHtml((String)resp.ruleTitle));
        List<DayOfMonthGridAdapter.SignDayInfo> calendarData = this.caculateCalendar(resp);
        this.mAdapter.setData(calendarData);
        int count = this.mAdapter.getCount();
        int row = count / 7;
        int modValue = count % 7;
        if (modValue > 0) {
            ++row;
        }
        ViewGroup.LayoutParams params = this.mGridDayOfMonth.getLayoutParams();
        params.height = (this.getResources().getDimensionPixelSize(R.dimen.item_height_sign_day) + this.getResources().getDimensionPixelSize(R.dimen.divider_hight)) * row;
        this.mGridDayOfMonth.setLayoutParams(params);
    }

    public void reqSignHistory() {
        if (!this.isNetworkAvailable()) {
            SingleToastUtil.showToast((Context)BasicConfig.getInstance().getAppContext(), (int)R.string.network_error);
            return;
        }
        if (ICoreManagerBase.getCore(ILivePluginCore.class) != null) {
            ((ILivePluginCore)ICoreManagerBase.getCore(ILivePluginCore.class)).reqSignHistory(this.getUid());
        }
    }

    private long getUid() {
        return LoginUtil.getUid();
    }

    private List<DayOfMonthGridAdapter.SignDayInfo> caculateCalendar(SignHistoryRespInfo resp) {
        Calendar calendar = Calendar.getInstance();
        ArrayList<DayOfMonthGridAdapter.SignDayInfo> data = new ArrayList<DayOfMonthGridAdapter.SignDayInfo>();
        calendar = Calendar.getInstance();
        int year = calendar.get(1);
        int month = calendar.get(2);
        if (resp.year > 0) {
            year = resp.year;
        }
        if (resp.month > 0) {
            month = resp.month - 1;
        }
        calendar.set(year, month, 1);
        int firstDayOfWeek = calendar.get(7) - 1;
        for (int index = 0; index < firstDayOfWeek; ++index) {
            data.add(this.mAdapter.getEmptyInfo());
        }
        int dayCount = calendar.getActualMaximum(5);
        List signDays = resp.signDays;
        for (int index = 1; index <= dayCount; ++index) {
            DayOfMonthGridAdapter.SignDayInfo info = new DayOfMonthGridAdapter.SignDayInfo();
            info.displayType = 1;
            info.isSign = false;
            info.dayOfMonth = resp.today > 0 && index == resp.today ? this.getString(R.string.display_today) : String.valueOf(index);
            for (int i = 0; i < signDays.size(); ++i) {
                Integer day = (Integer)signDays.get(i);
                if (index != day) continue;
                info.isSign = true;
                break;
            }
            data.add(info);
        }
        int count = data.size();
        int modValue = count % 7;
        if (modValue > 0) {
            int emptyEndCount = 7 - modValue;
            for (int index = 0; index < emptyEndCount; ++index) {
                data.add(this.mAdapter.getEmptyInfo());
            }
        }
        return data;
    }

    @Override
    protected void onDestroy() {
        super.onDestroy();
        if (this.mSignDetailsActivitySniperEventBinder != null) {
            this.mSignDetailsActivitySniperEventBinder.unBindEvent();
        }
    }
}

