/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.plugin.main.init;

import android.content.Intent;
import com.yy.mobile.RxBus;
import com.yy.mobile.baseapi.model.store.YYStore;
import com.yy.mobile.bizmodel.login.LoginUtil;
import com.yy.mobile.config.BasicConfig;
import com.yy.mobile.model.ReqAction;
import com.yy.mobile.plugin.homeapi.GetTargetTabViewAction;
import com.yy.mobile.plugin.homeapi.tab.TabViewDesc;
import com.yy.mobile.ui.community.DiscoveryRedDotUtil;
import com.yy.mobile.util.CommonUtils;
import com.yy.mobile.util.RxUtils;
import com.yy.mobile.util.StringUtils;
import com.yy.mobile.util.log.MLog;
import com.yy.mobile.util.log.PerfLog;
import com.yy.mobile.util.pref.CommonPref;
import com.yy.mobile.yyprotocol.core.Uint32;
import com.yymobile.core.CoreFactory;
import com.yymobile.core.CoreManager;
import com.yymobile.core.reqaction.SetHomeBottomRedDotAction;
import com.yymobile.core.truelove.ITrueLoveCore;
import com.yymobile.core.truelove.TrueLoveInfo;
import com.yymobile.core.vip.Vip;
import com.yymobile.core.vip.action.OnVipStateChangeNotify;
import com.yymobile.core.vip.dressup.DressupCore;
import com.yymobile.core.vip.dressup.TypeKey;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Consumer;
import io.reactivex.internal.functions.Functions;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.json.JSONException;
import org.json.JSONObject;

public class DelayShowView {
    private static final DelayShowView instance = new DelayShowView();
    public Disposable getTargetTabViewDisposable;
    public Disposable getTargetTabViewToRedDisposable;
    private long mUnreadImMsgCount;
    private DiscoveryRedDotUtil.DiscoveryRedDotListener listener = new DiscoveryRedDotUtil.DiscoveryRedDotListener(){

        @Override
        public void showRedDot(boolean showRedDot) {
            if (showRedDot && !CommonPref.instance().getBoolean("discovery_red_dot_first", true)) {
                DiscoveryRedDotUtil.getInstance().setRefAppCounts(1);
                DelayShowView.this.getTargetTabViewDisposable = YYStore.INSTANCE.dispatch((ReqAction)new GetTargetTabViewAction("", true)).subscribe((Consumer)new Consumer<TabViewDesc>(){

                    public void accept(TabViewDesc tabViewDesc) throws Exception {
                        if (DelayShowView.this.getTargetTabViewDisposable != null && DelayShowView.this.getTargetTabViewDisposable.isDisposed()) {
                            DelayShowView.this.getTargetTabViewDisposable.dispose();
                        }
                    }
                }, RxUtils.errorConsumer((String)"DelayShowView"));
            }
            CommonPref.instance().putBoolean("discovery_red_dot_first", false);
        }
    };

    private DelayShowView() {
    }

    public static DelayShowView getInstance() {
        return instance;
    }

    public void onLogout() {
        YYStore.INSTANCE.dispatch((ReqAction)new SetHomeBottomRedDotAction("/Me/Home", false));
        this.updatePerfLogInfo();
    }

    public void requestVip() {
        CoreManager.getVipCore().clearVipCache();
        CoreManager.getVipCore().getCacheUserVip(LoginUtil.getUid()).subscribe((Consumer)new Consumer<Vip>(){

            public void accept(Vip vip) throws Exception {
                RxBus.getDefault().post((Object)new OnVipStateChangeNotify());
            }
        }, RxUtils.errorConsumer((String)"DelayShowView"));
    }

    public void requestVipBubble() {
        ((DressupCore)CoreFactory.getCore(DressupCore.class)).onQueryBubbleReq(LoginUtil.getUid(), TypeKey.OUTGOING).subscribe(Functions.emptyConsumer(), RxUtils.errorConsumer((String)"DelayShowView"));
    }

    public void discoveryRemove() {
        DiscoveryRedDotUtil.getInstance().unRegisterClient();
        this.listener = null;
    }

    private void updatePerfLogInfo() {
        long uid = LoginUtil.isLogined() ? LoginUtil.getUid() : LoginUtil.getAnoymousUid();
        String phoneNum = "";
        MLog.info((Object)"DelayShowView", (String)("updatePerfLogInfo uid:" + uid + " phoneNum:" + phoneNum), (Object[])new Object[0]);
        PerfLog.init((long)uid, (String)phoneNum);
    }

    public void onNewUnreadMsgEntranceCount(int intStrongCount, int intWeakCount) {
        this.mUnreadImMsgCount = intStrongCount + intWeakCount;
        MLog.info((Object)"DelayShowView", (String)("[onNewUnreadMsgEntranceCount] intStrongCount=" + intStrongCount + ", intWeakCount=" + intWeakCount), (Object[])new Object[0]);
        if (LoginUtil.isLogined() && this.mUnreadImMsgCount > 0L) {
            this.updateUnreadNotifyTipsView();
        }
        if (!MLog.isLogLevelAboveVerbose()) {
            MLog.verbose((Object)"DelayShowView", (String)("zs---onNewUnreadMsgEntranceCount-- cout " + this.mUnreadImMsgCount + " isLastUnReadCount-- "), (Object[])new Object[0]);
        }
        this.sendMsgCountUpdate(this.mUnreadImMsgCount);
    }

    private void sendMsgCountUpdate(long count) {
        Intent intent = new Intent("com.duowan.mobile.action.UPDATE_MESSAGE_COUNT");
        intent.putExtra("TOTAL", count);
        BasicConfig.getInstance().getAppContext().sendBroadcast(intent);
    }

    public void updateUnreadNotifyTipsView() {
        this.getTargetTabViewToRedDisposable = YYStore.INSTANCE.dispatch((ReqAction)new GetTargetTabViewAction("", true)).subscribe((Consumer)new Consumer<TabViewDesc>(){

            public void accept(TabViewDesc tabViewDesc) throws Exception {
                if (!tabViewDesc.mCurTabId.equals("/Me/Home")) {
                    YYStore.INSTANCE.dispatch((ReqAction)new SetHomeBottomRedDotAction("/Me/Home", true));
                }
                if (DelayShowView.this.getTargetTabViewToRedDisposable != null && DelayShowView.this.getTargetTabViewToRedDisposable.isDisposed()) {
                    DelayShowView.this.getTargetTabViewToRedDisposable.dispose();
                }
            }
        }, RxUtils.errorConsumer((String)"DelayShowView"));
    }

    public void showDueTime(Map<Uint32, TrueLoveInfo.TrueLoveUserData> mAnchorList) {
        if (MLog.isLogLevelAboveDebug()) {
            MLog.debug((Object)"DelayShowView", (String)"showDueTime", (Object[])new Object[0]);
        }
        Set<Uint32> keys = mAnchorList.keySet();
        for (Uint32 key : keys) {
            TrueLoveInfo.TrueLoveUserData tlUserData = mAnchorList.get(key);
            if (tlUserData == null) continue;
            MLog.info((Object)"DelayShowView", (String)("showDueTime anchorId=" + key.intValue() + ",xufei_click=" + tlUserData.xufeiClick.intValue() + ",leftDay=" + tlUserData.leftday.intValue()), (Object[])new Object[0]);
            if (tlUserData.xufeiClick.intValue() != 1 || tlUserData.leftday.intValue() >= 8 || ((ITrueLoveCore)CoreManager.getCore(ITrueLoveCore.class)).isClickTrueLoveRedDot() || this.isClickMeRedDot()) continue;
            this.updateUnreadNotifyTipsView();
        }
    }

    public boolean isClickMeRedDot() {
        String jsonStr = CommonPref.instance().getString("me_tab_red_dot_notice");
        MLog.info((Object)"MeFragment", (String)("isClickMeRedDot : " + jsonStr), (Object[])new Object[0]);
        if (!StringUtils.isNullOrEmpty((String)jsonStr)) {
            try {
                Date today;
                JSONObject jsonObject = new JSONObject(jsonStr);
                HashMap<String, Boolean> click = new HashMap<String, Boolean>();
                Iterator it = jsonObject.keys();
                while (it.hasNext()) {
                    String key1 = (String)it.next();
                    click.put(key1, jsonObject.optBoolean(key1));
                }
                SimpleDateFormat format = CommonUtils.getSimpleDateFormat((String)"yyyy-MM-dd");
                String key = format.format(today = new Date());
                Boolean value = (Boolean)click.get(key);
                if (value != null && value.booleanValue()) {
                    return true;
                }
            }
            catch (JSONException e) {
                MLog.error((Object)"MeFragment", (String)e.getMessage(), (Object[])new Object[0]);
            }
        }
        return false;
    }
}

