/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.photoselect;

import android.content.Context;
import android.database.Cursor;
import android.provider.MediaStore;
import android.support.v4.content.CursorLoader;
import com.yy.mobile.permission.AndroidPermission;
import com.yy.mobile.photoselect.AlbumInfo;
import com.yy.mobile.photoselect.IPhotoPickCallback;
import com.yy.mobile.photoselect.PhotoInfo;
import com.yy.mobile.util.SafeDispatchHandlerUtil;
import com.yy.mobile.util.YYFileUtils;
import com.yy.mobile.util.log.MLog;
import com.yymobile.core.ICoreManagerBase;
import java.text.CollationKey;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;

public class PhotoSelectHelper {
    private List<AlbumInfo> mAlbumInfos = new ArrayList<AlbumInfo>();
    private List<PhotoInfo> mPhotoInfos = new ArrayList<PhotoInfo>();
    private static PhotoSelectHelper sInstance;

    private PhotoSelectHelper() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static PhotoSelectHelper getInstance() {
        if (sInstance != null) return sInstance;
        Class<PhotoSelectHelper> clazz = PhotoSelectHelper.class;
        synchronized (PhotoSelectHelper.class) {
            if (sInstance != null) return sInstance;
            sInstance = new PhotoSelectHelper();
            // ** MonitorExit[var0] (shouldn't be in output)
            return sInstance;
        }
    }

    public void queryLocalAlbum(final Context context, final IPhotoPickCallback client) {
        List<String> permissions = Arrays.asList("android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE");
        AndroidPermission p = (AndroidPermission)ICoreManagerBase.getCore(AndroidPermission.class);
        if (p != null) {
            p.checkPermission(context, permissions, (Function0)new Function0<Unit>(){

                public Unit invoke() {
                    PhotoSelectHelper.this.queryLocalAlbumInternal(context, client);
                    return null;
                }
            }, (Function0)new Function0<Unit>(){

                public Unit invoke() {
                    MLog.info((Object)"PhotoPickHelper", (String)"queryLocalAlbum denied storage permission", (Object[])new Object[0]);
                    return null;
                }
            });
        }
    }

    public void queryLocalAlbumInternal(Context context, IPhotoPickCallback client) {
        ArrayList<AlbumInfo> data = new ArrayList<AlbumInfo>();
        String[] imageColumns = new String[]{"_id", "bucket_display_name", "bucket_id", "count(_id)", "_data"};
        String groupby = " 1=1 ) group by (bucket_id";
        try {
            CursorLoader loader = new CursorLoader(context, MediaStore.Images.Media.EXTERNAL_CONTENT_URI, imageColumns, groupby, null, null);
            Cursor cursor = loader.loadInBackground();
            if (cursor != null) {
                while (cursor.moveToNext()) {
                    String folderName = cursor.getString(cursor.getColumnIndexOrThrow("bucket_display_name"));
                    int count = cursor.getInt(3);
                    String image = cursor.getString(cursor.getColumnIndexOrThrow("_data"));
                    String bucketId = cursor.getString(cursor.getColumnIndexOrThrow("bucket_id"));
                    int id = cursor.getInt(cursor.getColumnIndexOrThrow("_id"));
                    AlbumInfo info = new AlbumInfo();
                    info.folder = folderName;
                    info.count = count;
                    info.image = image;
                    info.bucketId = bucketId;
                    info.imageId = id;
                    data.add(info);
                    if (!MLog.isLogLevelAboveVerbose()) {
                        MLog.verbose((Object)"PhotoPickHelper", (String)("xuwakao, id = " + id), (Object[])new Object[0]);
                    }
                    if (MLog.isLogLevelAboveVerbose()) continue;
                    MLog.verbose((Object)"PhotoPickHelper", (String)("xuwakao, AlbumInfo = " + info), (Object[])new Object[0]);
                }
                if (!cursor.isClosed()) {
                    cursor.close();
                }
            }
        }
        catch (SecurityException e) {
            MLog.error((Object)"PhotoPickHelper", (Throwable)e);
        }
        catch (Throwable throwable) {
            MLog.error((Object)"PhotoPickHelper", (Throwable)throwable);
        }
        try {
            Collections.sort(data, new Comparator<AlbumInfo>(){

                @Override
                public int compare(AlbumInfo lhs, AlbumInfo rhs) {
                    if (lhs.folder.trim().equalsIgnoreCase("Camera") || lhs.folder.trim().equals("\u76f8\u673a")) {
                        return -1;
                    }
                    if (rhs.folder.trim().equalsIgnoreCase("Camera") || rhs.folder.trim().equals("\u76f8\u673a")) {
                        return 1;
                    }
                    if (lhs.folder.trim().equalsIgnoreCase("DCIM")) {
                        return -1;
                    }
                    if (rhs.folder.trim().equalsIgnoreCase("DCIM")) {
                        return 1;
                    }
                    if (lhs.folder.trim().equalsIgnoreCase("Screenshots") || lhs.folder.trim().equals("\u622a\u5c4f")) {
                        return -1;
                    }
                    if (rhs.folder.trim().equalsIgnoreCase("Screenshots") || rhs.folder.trim().equals("\u622a\u5c4f")) {
                        return 1;
                    }
                    Collator collator = Collator.getInstance();
                    CollationKey key1 = collator.getCollationKey(lhs.folder.trim().toLowerCase());
                    CollationKey key2 = collator.getCollationKey(rhs.folder.trim().toLowerCase());
                    return key1.compareTo(key2);
                }
            });
        }
        catch (Throwable ex) {
            MLog.error((Object)"PhotoPickHelper", (Throwable)ex);
        }
        this.mAlbumInfos.clear();
        this.mAlbumInfos.addAll(data);
        client.onAlbumInfos(data);
    }

    public void queryAllPhotos(final Context context, final IPhotoPickCallback client) {
        MLog.info((Object)"PhotoPickHelper", (String)("-- queryAllPhotos context = " + context), (Object[])new Object[0]);
        final List<String> permissions = Arrays.asList("android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE");
        AndroidPermission p = (AndroidPermission)ICoreManagerBase.getCore(AndroidPermission.class);
        if (p != null) {
            p.checkPermission(context, permissions, (Function0)new Function0<Unit>(){

                public Unit invoke() {
                    MLog.info((Object)"PhotoPickHelper", (String)("-- queryAllPhotos granted data = " + permissions), (Object[])new Object[0]);
                    PhotoSelectHelper.this.queryAllPhotosInternal(context, client);
                    return null;
                }
            }, (Function0)new Function0<Unit>(){

                public Unit invoke() {
                    MLog.info((Object)"PhotoPickHelper", (String)"-- queryAllPhotos denied storage permission", (Object[])new Object[0]);
                    return null;
                }
            });
        }
    }

    public void queryAllPhotosInternal(Context context, final IPhotoPickCallback client) {
        final ArrayList<PhotoInfo> data = new ArrayList<PhotoInfo>();
        String[] imageColumns = new String[]{"_id", "_data", "orientation"};
        CursorLoader loader = new CursorLoader(context, MediaStore.Images.Media.EXTERNAL_CONTENT_URI, imageColumns, null, null, "date_modified");
        try {
            Cursor cursor = loader.loadInBackground();
            if (cursor != null) {
                while (cursor.moveToNext()) {
                    String image = cursor.getString(cursor.getColumnIndexOrThrow("_data"));
                    String id = cursor.getString(cursor.getColumnIndexOrThrow("_id"));
                    PhotoInfo info = new PhotoInfo();
                    info.image = image;
                    if (!PhotoSelectHelper.isFileExisted(info.image, id)) continue;
                    data.add(info);
                }
                if (!cursor.isClosed()) {
                    cursor.close();
                }
            }
        }
        catch (SecurityException e) {
            MLog.error((Object)"PhotoPickHelper", (Throwable)e);
        }
        if (data != null) {
            this.mPhotoInfos.clear();
            Collections.reverse(data);
            this.mPhotoInfos.addAll(data);
        }
        SafeDispatchHandlerUtil.runOnMainThread((Runnable)new Runnable(){

            @Override
            public void run() {
                client.onPhotoInfos(data);
            }
        });
    }

    public void queryPhotos(final Context context, final String bucketId, final IPhotoPickCallback client) {
        List<String> permissions = Arrays.asList("android.permission.READ_EXTERNAL_STORAGE", "android.permission.WRITE_EXTERNAL_STORAGE");
        AndroidPermission p = (AndroidPermission)ICoreManagerBase.getCore(AndroidPermission.class);
        if (p != null) {
            p.checkPermission(context, permissions, (Function0)new Function0<Unit>(){

                public Unit invoke() {
                    PhotoSelectHelper.this.queryPhotosInternal(context, bucketId, client);
                    return null;
                }
            }, (Function0)new Function0<Unit>(){

                public Unit invoke() {
                    MLog.info((Object)"PhotoPickHelper", (String)"queryPhotos denied storage permission", (Object[])new Object[0]);
                    return null;
                }
            });
        }
    }

    public void queryPhotosInternal(Context context, String bucketId, IPhotoPickCallback client) {
        ArrayList<PhotoInfo> data = new ArrayList<PhotoInfo>();
        String[] imageColumns = new String[]{"_id", "_data", "orientation"};
        String selection = "bucket_id=?";
        String[] selectionArgs = new String[]{String.valueOf(bucketId)};
        CursorLoader loader = new CursorLoader(context, MediaStore.Images.Media.EXTERNAL_CONTENT_URI, imageColumns, selection, selectionArgs, "date_modified");
        try {
            Cursor cursor = loader.loadInBackground();
            if (cursor != null) {
                while (cursor.moveToNext()) {
                    String image = cursor.getString(cursor.getColumnIndexOrThrow("_data"));
                    String id = cursor.getString(cursor.getColumnIndexOrThrow("_id"));
                    PhotoInfo info = new PhotoInfo();
                    info.image = image;
                    if (PhotoSelectHelper.isFileExisted(info.image, id)) {
                        data.add(info);
                    }
                    if (MLog.isLogLevelAboveVerbose()) continue;
                    MLog.verbose((Object)"PhotoPickHelper", (String)("xuwakao, PhotoInfo = " + info), (Object[])new Object[0]);
                }
                if (!cursor.isClosed()) {
                    cursor.close();
                }
            }
        }
        catch (SecurityException e) {
            MLog.error((Object)"PhotoPickHelper", (Throwable)e);
        }
        if (data != null) {
            this.mPhotoInfos.clear();
            Collections.reverse(data);
            this.mPhotoInfos.addAll(data);
        }
        client.onPhotoInfos(data);
    }

    private static boolean isFileExisted(String image, String id) {
        return YYFileUtils.isFileExisted((String)image);
    }

    public List<AlbumInfo> getAlbumInfos() {
        return this.mAlbumInfos;
    }

    public List<PhotoInfo> getPhotoInfos() {
        return this.mPhotoInfos;
    }
}

