/*
 * Decompiled with CFR 0.152.
 */
package com.yy.mobile.photoselect;

import android.content.Context;
import android.net.Uri;
import android.text.TextUtils;
import com.yy.mobile.util.log.MLog;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class GetImagePathUtil {
    public static String getFilePathFromURI(Context context, Uri contentUri) {
        MLog.info((Object)"GetImagePathUtil", (String)("context value is " + context + " contentUri value is " + contentUri), (Object[])new Object[0]);
        File rootDataDir = context.getFilesDir();
        String fileName = GetImagePathUtil.getFileName(contentUri);
        MLog.info((Object)"GetImagePathUtil", (String)("fileName value is " + fileName), (Object[])new Object[0]);
        if (!TextUtils.isEmpty((CharSequence)fileName)) {
            File copyFile = new File(rootDataDir + File.separator + fileName);
            GetImagePathUtil.copyFile(context, contentUri, copyFile);
            return copyFile.getAbsolutePath();
        }
        return null;
    }

    private static String getFileName(Uri uri) {
        if (uri == null) {
            return null;
        }
        String fileName = null;
        String path = uri.getPath();
        int cut = -1;
        if (path != null) {
            cut = path.lastIndexOf(47);
        }
        MLog.info((Object)"GetImagePathUtil", (String)("cut value is " + cut), (Object[])new Object[0]);
        if (cut != -1) {
            fileName = path.substring(cut + 1);
        }
        return fileName;
    }

    private static void copyFile(Context context, Uri srcUri, File dstFile) {
        try {
            InputStream inputStream = context.getContentResolver().openInputStream(srcUri);
            if (inputStream == null) {
                return;
            }
            FileOutputStream outputStream = new FileOutputStream(dstFile);
            GetImagePathUtil.copyStream(inputStream, outputStream);
            inputStream.close();
            ((OutputStream)outputStream).close();
        }
        catch (Exception e) {
            MLog.error((Object)"GetImagePathUtil", (String)("copyFile method error: " + e.getMessage()), (Object[])new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void copyStream(InputStream input, OutputStream output) throws IOException {
        int bufferSize = 1024;
        byte[] buffer = new byte[1024];
        BufferedInputStream in = new BufferedInputStream(input, 1024);
        BufferedOutputStream out = new BufferedOutputStream(output, 1024);
        int flag = 0;
        int count = 0;
        int n = 0;
        try {
            while ((n = in.read(buffer)) != -1) {
                out.write(buffer, 0, n);
                count += n;
                MLog.error((Object)"GetImagePathUtil", (String)("flag value is\uff1a" + ++flag), (Object[])new Object[0]);
            }
        }
        finally {
            try {
                out.flush();
                out.close();
                in.close();
            }
            catch (IOException e) {
                MLog.error((Object)"GetImagePathUtil", (String)("IO close error: " + e.getMessage()), (Object[])new Object[0]);
            }
        }
    }
}

